/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.scheduler;

import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.context.Flag;
import org.wildfly.clustering.cache.Key;
import org.wildfly.clustering.cache.infinispan.embedded.distribution.Locality;
import org.wildfly.clustering.server.infinispan.scheduler.CacheEntryScheduler;

public class ScheduleLocalEntriesTask<I, M, K extends Key<I>>
implements BiConsumer<Locality, Locality> {
    private final Cache<K, Object> cache;
    private final Predicate<Map.Entry<? super K, ? super Object>> filter;
    private final CacheEntryScheduler<I, M> scheduler;

    public ScheduleLocalEntriesTask(Cache<K, Object> cache, Predicate<Map.Entry<? super K, ? super Object>> filter, CacheEntryScheduler<I, M> scheduler) {
        this.cache = cache;
        this.filter = filter;
        this.scheduler = scheduler;
    }

    @Override
    public void accept(Locality oldLocality, Locality newLocality) {
        try (CacheStream stream = this.cache.getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL).entrySet().stream().filter(this.filter);){
            Iterator entries = stream.iterator();
            while (entries.hasNext()) {
                if (Thread.currentThread().isInterrupted()) {
                    break;
                }
                Key key = (Key)((Map.Entry)entries.next()).getKey();
                if (oldLocality.isLocal((Object)key) || !newLocality.isLocal((Object)key)) continue;
                this.scheduler.schedule(key.getId());
            }
        }
    }
}

