/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.scheduler;

import java.util.function.Supplier;
import org.wildfly.clustering.server.scheduler.Scheduler;

public interface Scheduler<I, M>
extends org.wildfly.clustering.server.scheduler.Scheduler<I, M> {
    public void schedule(I var1);

    public static <I, M> Scheduler<I, M> inactive() {
        return new InactiveScheduler();
    }

    public static <I, M> Scheduler<I, M> fromReference(Supplier<? extends Scheduler<I, M>> reference) {
        return new ReferenceScheduler(reference);
    }

    public static class InactiveScheduler<I, M>
    extends Scheduler.InactiveScheduler<I, M>
    implements Scheduler<I, M> {
        @Override
        public void schedule(I id) {
        }
    }

    public static class ReferenceScheduler<I, M>
    extends Scheduler.ReferenceScheduler<I, M>
    implements Scheduler<I, M> {
        private final Supplier<? extends Scheduler<I, M>> reference;

        ReferenceScheduler(Supplier<? extends Scheduler<I, M>> reference) {
            super(reference);
            this.reference = reference;
        }

        @Override
        public void schedule(I id) {
            this.reference.get().schedule(id);
        }
    }
}

