/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.metadata.coarse;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.function.Supplier;
import org.wildfly.clustering.server.offset.OffsetValue;
import org.wildfly.clustering.server.util.Supplied;
import org.wildfly.clustering.session.cache.metadata.coarse.AbstractSessionMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.coarse.ContextualSessionMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.coarse.SessionMetaDataEntryOffsets;

public class DefaultSessionMetaDataEntry<C>
extends AbstractSessionMetaDataEntry
implements ContextualSessionMetaDataEntry<C> {
    private volatile Duration timeout = Duration.ZERO;
    private final OffsetValue<Instant> lastAccessStartTime;
    private final OffsetValue<Instant> lastAccessEndTime;
    private final Supplied<C> context = Supplied.cached();

    public DefaultSessionMetaDataEntry() {
        this(Instant.now().truncatedTo(ChronoUnit.MILLIS));
    }

    public DefaultSessionMetaDataEntry(Instant creationTime) {
        this.lastAccessStartTime = OffsetValue.from((Instant)creationTime);
        this.lastAccessEndTime = this.lastAccessStartTime.rebase();
    }

    @Override
    public boolean isNew() {
        return this.getLastAccessEndTime().getOffset().isZero();
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }

    @Override
    public OffsetValue<Instant> getLastAccessStartTime() {
        return this.lastAccessStartTime;
    }

    @Override
    public OffsetValue<Instant> getLastAccessEndTime() {
        return this.lastAccessEndTime;
    }

    @Override
    public Supplied<C> getContext() {
        return this.context;
    }

    public ContextualSessionMetaDataEntry<C> remap(SessionMetaDataEntryOffsets offsets) {
        DefaultSessionMetaDataEntry<C> result = new DefaultSessionMetaDataEntry<C>(this.getCreationTime());
        result.setTimeout((Duration)offsets.getTimeoutOffset().apply((Object)this.timeout));
        result.getLastAccessStartTime().set((Object)((Instant)offsets.getLastAccessStartTimeOffset().apply((Object)((Instant)this.lastAccessStartTime.get()))));
        result.getLastAccessEndTime().set((Object)((Instant)offsets.getLastAccessEndTimeOffset().apply((Object)((Instant)this.lastAccessEndTime.get()))));
        result.getContext().get((Supplier)org.wildfly.clustering.function.Supplier.of((Object)this.context.get((Supplier)org.wildfly.clustering.function.Supplier.empty())));
        return result;
    }
}

