/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.embedded;

import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.ImmutableSessionMetaData;
import org.wildfly.clustering.session.cache.SessionFactory;

public class SessionExpirationTask<SC, MV, AV, LC>
implements Predicate<String> {
    private static final System.Logger LOGGER = System.getLogger(SessionExpirationTask.class.getName());
    private final SessionFactory<SC, MV, AV, LC> sessionFactory;
    private final Supplier<Batch> batchFactory;
    private final Consumer<ImmutableSession> expirationListener;

    public SessionExpirationTask(SessionFactory<SC, MV, AV, LC> sessionFactory, Supplier<Batch> batchFactory, Consumer<ImmutableSession> expirationListener) {
        this.sessionFactory = sessionFactory;
        this.batchFactory = batchFactory;
        this.expirationListener = expirationListener;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean test(String id) {
        LOGGER.log(System.Logger.Level.DEBUG, "Initiating expiration of session {0}", id);
        try {
            Throwable throwable2;
            Batch batch = this.batchFactory.get();
            try {
                Object metaDataValue = this.sessionFactory.getSessionMetaDataFactory().tryValue((Object)id);
                if (metaDataValue != null) {
                    ImmutableSessionMetaData metaData = this.sessionFactory.getSessionMetaDataFactory().createImmutableSessionMetaData(id, metaDataValue);
                    if (metaData.isExpired()) {
                        LOGGER.log(System.Logger.Level.TRACE, "Removing expired session {0}.", id);
                        Object attributesValue = this.sessionFactory.getSessionAttributesFactory().findValue((Object)id);
                        if (attributesValue != null) {
                            Map attributes = this.sessionFactory.getSessionAttributesFactory().createImmutableSessionAttributes(id, attributesValue);
                            ImmutableSession session = this.sessionFactory.createImmutableSession(id, metaData, attributes);
                            this.expirationListener.accept(session);
                        }
                        try {
                            this.sessionFactory.remove((Object)id);
                            boolean attributes = true;
                            return attributes;
                        }
                        catch (CancellationException e) {
                            boolean bl;
                            block18: {
                                LOGGER.log(System.Logger.Level.TRACE, "Removal of session {0} was cancelled.", id);
                                bl = false;
                                if (batch == null) break block18;
                                batch.close();
                            }
                            return bl;
                        }
                    }
                    LOGGER.log(System.Logger.Level.TRACE, "Session {0} does not expire until {1}", id, metaData.getExpirationTime().orElse(null));
                    boolean bl = false;
                    return bl;
                }
                LOGGER.log(System.Logger.Level.TRACE, "Session {0} was not found or is currently in use.", id);
                boolean bl = true;
                return bl;
                {
                    catch (Error | RuntimeException e) {
                        batch.discard();
                        throw e;
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                }
            }
            finally {
                if (batch != null) {
                    try {
                        batch.close();
                    }
                    catch (Throwable throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                }
            }
        }
        catch (Error | RuntimeException e) {
            LOGGER.log(System.Logger.Level.WARNING, e.getLocalizedMessage(), e);
            return false;
        }
    }
}

