/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.embedded;

import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.context.Flag;
import org.wildfly.clustering.cache.CacheProperties;
import org.wildfly.clustering.cache.Key;
import org.wildfly.clustering.cache.infinispan.embedded.EmbeddedCacheConfiguration;
import org.wildfly.clustering.cache.infinispan.embedded.distribution.CacheStreamFilter;
import org.wildfly.clustering.function.BiConsumer;
import org.wildfly.clustering.server.expiration.ExpirationMetaData;
import org.wildfly.clustering.server.scheduler.Scheduler;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.SessionStatistics;
import org.wildfly.clustering.session.cache.AbstractSessionManager;
import org.wildfly.clustering.session.infinispan.embedded.SessionCacheKeyFilter;

public class InfinispanSessionManager<DC, MV, AV, SC>
extends AbstractSessionManager<DC, MV, AV, SC> {
    private final Cache<Key<String>, ?> cache;
    private final CacheProperties properties;
    private final Scheduler<String, ExpirationMetaData> scheduler;

    public InfinispanSessionManager(Configuration<DC, MV, AV, SC> configuration) {
        super(configuration);
        this.cache = configuration.getCacheConfiguration().getCache();
        this.properties = configuration.getCacheConfiguration().getCacheProperties();
        this.scheduler = configuration.getExpirationScheduler();
    }

    public void stop() {
        PersistenceConfiguration persistence;
        if (!this.properties.isPersistent() && (persistence = this.cache.getCacheConfiguration().persistence()).passivation() && !persistence.stores().stream().allMatch(StoreConfiguration::purgeOnStartup)) {
            try (CacheStream stream = this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.SKIP_CACHE_LOAD, Flag.SKIP_LOCKING}).keySet().stream();){
                stream.filter(SessionCacheKeyFilter.META_DATA).forEach(arg_0 -> this.cache.evict(arg_0));
            }
        }
        super.stop();
    }

    public CompletionStage<Session<SC>> findSessionAsync(String id) {
        this.scheduler.cancel((Object)id);
        return super.findSessionAsync(id);
    }

    public SessionStatistics getStatistics() {
        return this;
    }

    public Set<String> getActiveSessions() {
        return this.getLocalSessions((Cache<Key<String>, ?>)this.cache.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD));
    }

    public Set<String> getSessions() {
        return this.getLocalSessions(this.cache);
    }

    private Set<String> getLocalSessions(Cache<Key<String>, ?> cache) {
        CacheStreamFilter filter = CacheStreamFilter.local(cache);
        try (Stream keys = (Stream)filter.apply((Object)cache.keySet().stream());){
            Set<String> set = keys.filter(SessionCacheKeyFilter.META_DATA).map(Key::getId).collect(Collectors.toUnmodifiableSet());
            return set;
        }
    }

    static interface Configuration<DC, MV, AV, SC>
    extends AbstractSessionManager.Configuration<DC, MV, AV, SC> {
        public EmbeddedCacheConfiguration getCacheConfiguration();

        default public Consumer<ImmutableSession> getSessionCloseTask() {
            final Scheduler<String, ExpirationMetaData> scheduler = this.getExpirationScheduler();
            return new Consumer<ImmutableSession>(){

                @Override
                public void accept(ImmutableSession session) {
                    if (session.isValid() && !session.getMetaData().isImmortal()) {
                        scheduler.schedule((Object)session.getId(), (Object)session.getMetaData());
                    }
                }
            };
        }

        default public Consumer<ImmutableSession> getExpiredSessionHandler() {
            BiConsumer schedule = (arg_0, arg_1) -> this.getExpirationScheduler().schedule(arg_0, arg_1);
            return schedule.composeUnary(ImmutableSession::getId, ImmutableSession::getMetaData);
        }

        public Scheduler<String, ExpirationMetaData> getExpirationScheduler();
    }
}

