/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.remote;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.wildfly.clustering.cache.Key;
import org.wildfly.clustering.cache.infinispan.remote.RemoteCacheConfiguration;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.cache.AbstractSessionManager;
import org.wildfly.clustering.session.infinispan.remote.metadata.SessionCreationMetaDataKey;

public class HotRodSessionManager<C, MV, AV, SC>
extends AbstractSessionManager<C, MV, AV, SC> {
    private final RemoteCache<Key<String>, ?> cache;

    public HotRodSessionManager(Configuration<C, MV, AV, SC> configuration) {
        super(configuration);
        this.cache = configuration.getCacheConfiguration().getCache();
    }

    public Set<String> getActiveSessions() {
        return this.getSessions();
    }

    public Set<String> getSessions() {
        try (Stream keys = this.cache.withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).keySet().stream();){
            Set<String> set = keys.filter(SessionCreationMetaDataKey.class::isInstance).map(Key::getId).collect(Collectors.toUnmodifiableSet());
            return set;
        }
    }

    static interface Configuration<C, MV, AV, SC>
    extends AbstractSessionManager.Configuration<C, MV, AV, SC> {
        public RemoteCacheConfiguration getCacheConfiguration();

        default public java.util.function.Consumer<ImmutableSession> getSessionCloseTask() {
            return Consumer.empty();
        }
    }
}

