/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.tomcat.catalina;

import java.util.function.Consumer;
import org.apache.catalina.Context;
import org.wildfly.clustering.tomcat.ContextClassLoaderAction;
import org.wildfly.clustering.tomcat.catalina.CatalinaSessionDestroyAction;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.SessionExpirationListener;

public class CatalinaSessionExpirationListener
implements SessionExpirationListener {
    private final Consumer<ImmutableSession> expireAction;
    private final Consumer<Runnable> classLoaderAction;

    public CatalinaSessionExpirationListener(Context context) {
        this.expireAction = new CatalinaSessionDestroyAction(context);
        this.classLoaderAction = new ContextClassLoaderAction(context.getLoader().getClassLoader());
    }

    public void sessionExpired(ImmutableSession session) {
        this.classLoaderAction.accept(() -> this.expireAction.accept(session));
    }
}

