/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.tomcat.catalina;

import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.catalina.Context;
import org.wildfly.clustering.web.session.ImmutableHttpSessionAdapter;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;

public class CatalinaSessionDestroyAction
implements Consumer<ImmutableSession> {
    private final Context context;

    public CatalinaSessionDestroyAction(Context context) {
        this.context = context;
    }

    @Override
    public void accept(ImmutableSession session) {
        ImmutableHttpSessionAdapter httpSession = new ImmutableHttpSessionAdapter(session, this.context.getServletContext());
        HttpSessionEvent event = new HttpSessionEvent((HttpSession)httpSession);
        Stream.of(this.context.getApplicationLifecycleListeners()).filter(listener -> listener instanceof HttpSessionListener).map(listener -> (HttpSessionListener)listener).forEach(listener -> {
            try {
                this.context.fireContainerEvent("beforeSessionDestroyed", listener);
                listener.sessionDestroyed(event);
            }
            catch (Throwable e) {
                this.context.getLogger().warn((Object)e.getMessage(), e);
            }
            finally {
                this.context.fireContainerEvent("afterSessionDestroyed", listener);
            }
        });
        ImmutableSessionAttributes attributes = session.getAttributes();
        for (String name : attributes.getAttributeNames()) {
            Object attribute = attributes.getAttribute(name);
            if (!(attribute instanceof HttpSessionBindingListener)) continue;
            HttpSessionBindingListener listener2 = (HttpSessionBindingListener)attribute;
            try {
                listener2.valueUnbound(new HttpSessionBindingEvent((HttpSession)httpSession, name, attribute));
            }
            catch (Throwable e) {
                this.context.getLogger().warn((Object)e.getMessage(), e);
            }
        }
    }
}

