/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.tomcat.hotrod;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.NearCacheConfiguration;
import org.infinispan.client.hotrod.event.impl.ClientListenerNotifier;
import org.infinispan.client.hotrod.near.NearCacheService;
import org.wildfly.clustering.infinispan.client.RemoteCacheContainer;

public class RemoteCacheManager
extends org.infinispan.client.hotrod.RemoteCacheManager
implements RemoteCacheContainer {
    private static final ThreadLocal<String> CURRENT_CACHE_NAME = new ThreadLocal();
    private final Map<String, Function<ClientListenerNotifier, NearCacheService<?, ?>>> nearCacheFactories = new ConcurrentHashMap();
    private final String name;

    public RemoteCacheManager(String name, Configuration configuration) {
        super(configuration, false);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public <K, V> RemoteCache<K, V> getCache(String cacheName) {
        CURRENT_CACHE_NAME.set(cacheName);
        try {
            RemoteCache remoteCache = super.getCache(cacheName);
            return remoteCache;
        }
        finally {
            CURRENT_CACHE_NAME.remove();
        }
    }

    public <K, V> RemoteCacheContainer.NearCacheRegistration registerNearCacheFactory(String cacheName, Function<ClientListenerNotifier, NearCacheService<K, V>> factory) {
        Map<String, Function<ClientListenerNotifier, NearCacheService<?, ?>>> factories = this.nearCacheFactories;
        factories.put(cacheName, factory);
        return () -> {
            Function cfr_ignored_0 = (Function)factories.remove(cacheName);
        };
    }

    protected <K, V> NearCacheService<K, V> createNearCacheService(NearCacheConfiguration config) {
        String cacheName = CURRENT_CACHE_NAME.get();
        Function<ClientListenerNotifier, NearCacheService<?, ?>> factory = cacheName != null ? this.nearCacheFactories.get(cacheName) : null;
        return factory != null ? factory.apply(this.listenerNotifier) : super.createNearCacheService(config);
    }
}

