/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.jdk;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import org.wildfly.clustering.marshalling.jdk.ClassResolver;

public class ObjectInputStream
extends java.io.ObjectInputStream {
    private final ClassResolver resolver;

    public ObjectInputStream(InputStream input, ClassResolver resolver) throws IOException {
        super(input);
        this.resolver = resolver;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass description) throws IOException, ClassNotFoundException {
        return this.resolver.resolveClass(this, description.getName());
    }

    @Override
    protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        Class[] interfaceClasses = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            interfaceClasses[i] = this.resolver.resolveClass(this, interfaces[i]);
        }
        try {
            return Proxy.getProxyClass(this.resolver.getClassLoader(), interfaceClasses);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }
}

