/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.jdk;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import org.wildfly.clustering.marshalling.Externalizer;

public class ObjectInputStream
extends java.io.ObjectInputStream {
    private final Externalizer<ClassLoader> externalizer;

    public ObjectInputStream(InputStream input, Externalizer<ClassLoader> externalizer) throws IOException {
        super(input);
        this.externalizer = externalizer;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass description) throws IOException, ClassNotFoundException {
        String className = description.getName();
        return ((ClassLoader)this.externalizer.readObject((ObjectInput)this)).loadClass(className);
    }

    @Override
    protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        Class[] interfaceClasses = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            interfaceClasses[i] = ((ClassLoader)this.externalizer.readObject((ObjectInput)this)).loadClass(interfaces[i]);
        }
        try {
            return Proxy.getProxyClass((ClassLoader)this.externalizer.readObject((ObjectInput)this), interfaceClasses);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }
}

