/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.apigen.invocation;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class MapTypeAdapter {
    public void toDmr(ModelNode modelMode, String detypedName, Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            modelMode.get(detypedName).get(entry.getKey()).set(entry.getValue());
        }
    }

    public void fromDmr(Object entity, String javaName, ModelType dmrType, Class<?> propertyType, ModelNode dmrPayload) throws Exception {
        List properties;
        Method target = entity.getClass().getMethod(javaName, propertyType);
        List list = properties = dmrPayload.isDefined() ? dmrPayload.asPropertyList() : Collections.EMPTY_LIST;
        if (properties.isEmpty()) {
            target.invoke(entity, Collections.EMPTY_MAP);
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>(properties.size());
            for (Property prop : properties) {
                map.put(prop.getName(), this.toJavaValue(prop.getValue().getType(), prop.getValue()));
            }
            target.invoke(entity, map);
        }
    }

    private Object toJavaValue(ModelType type, ModelNode propValue) {
        if (type.equals((Object)ModelType.STRING)) {
            return propValue.asString();
        }
        if (type.equals((Object)ModelType.INT)) {
            return propValue.asInt();
        }
        if (type.equals((Object)ModelType.DOUBLE)) {
            return propValue.asDouble();
        }
        if (type.equals((Object)ModelType.LONG)) {
            return propValue.asLong();
        }
        if (type.equals((Object)ModelType.BOOLEAN)) {
            return propValue.asBoolean();
        }
        throw new RuntimeException("Unsupported DMR type: " + type);
    }
}

