/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.apigen.model;

import java.util.Collection;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.wildfly.config.model.ResourceAddress;

public class Operation
extends ModelNode {
    protected Operation(String name, ResourceAddress address, ModelNode parameter, String role) {
        this.get("operation").set(name);
        this.get("address").set((ModelNode)address);
        if (parameter.isDefined()) {
            for (Property property : parameter.asPropertyList()) {
                this.get(property.getName()).set(property.getValue());
            }
        }
        if (role != null && !name.equals("WHOMAI")) {
            this.get("operation-headers").get("roles").set(role);
        }
    }

    public static class Builder {
        private final String name;
        private final ResourceAddress address;
        private final ModelNode parameter;
        private String role;

        public Builder(String name, ResourceAddress address) {
            this.address = address;
            this.name = name;
            this.parameter = new ModelNode();
        }

        public Builder param(String name, boolean value) {
            this.parameter.get(name).set(value);
            return this;
        }

        public Builder param(String name, int value) {
            this.parameter.get(name).set(value);
            return this;
        }

        public Builder param(String name, long value) {
            this.parameter.get(name).set(value);
            return this;
        }

        public Builder param(String name, double value) {
            this.parameter.get(name).set(value);
            return this;
        }

        public Builder param(String name, String value) {
            this.parameter.get(name).set(value);
            return this;
        }

        public Builder param(String name, ModelNode value) {
            this.parameter.get(name).set(value);
            return this;
        }

        public Builder param(String name, Collection<ModelNode> value) {
            this.parameter.get(name).set(value);
            return this;
        }

        public Builder runAs(String role) {
            this.role = role;
            return this;
        }

        public Operation build() {
            return new Operation(this.name, this.address, this.parameter, this.role);
        }
    }
}

