/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.config.invocation;

import java.lang.reflect.Method;
import java.util.List;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.ValueExpression;

public class SimpleTypeAdapter {
    public void toDmr(ModelNode target, String detypedName, ModelType dmrType, Object value) {
        this.setDmrValueOn(target.get(detypedName), dmrType, value);
    }

    private ModelNode setDmrValueOn(ModelNode target, ModelType type, Object propValue) {
        if (type.equals((Object)ModelType.STRING)) {
            String value = propValue.toString();
            if (value.startsWith("${") && value.endsWith("}")) {
                value = new ValueExpression(value).resolveString();
            }
            target.set(value);
        } else if (type.equals((Object)ModelType.INT)) {
            target.set(((Integer)propValue).intValue());
        } else if (type.equals((Object)ModelType.DOUBLE)) {
            target.set(((Double)propValue).doubleValue());
        } else if (type.equals((Object)ModelType.LONG)) {
            target.set(((Long)propValue).longValue());
        } else if (type.equals((Object)ModelType.BOOLEAN)) {
            target.set(((Boolean)propValue).booleanValue());
        } else if (type.equals((Object)ModelType.LIST)) {
            target.setEmptyList();
            List list = (List)propValue;
            for (Object item : list) {
                target.add(String.valueOf(item));
            }
        } else {
            throw new RuntimeException("Unsupported DMR type: " + type);
        }
        return target;
    }

    public void fromDmr(Object entity, String javaName, ModelType dmrType, Class<?> propertyType, ModelNode dmrPayload) throws Exception {
        Method target = entity.getClass().getMethod(javaName, propertyType);
        this.setJavaValueOn(entity, target, propertyType, dmrPayload);
    }

    private void setJavaValueOn(Object entity, Method method, Class<?> propertyType, ModelNode dmrPayload) throws Exception {
        Object value = null;
        if (Boolean.class.equals(propertyType)) {
            value = dmrPayload.isDefined() ? Boolean.valueOf(dmrPayload.asBoolean()) : Boolean.valueOf(false);
        } else if (Long.class.equals(propertyType)) {
            value = dmrPayload.isDefined() ? Long.valueOf(dmrPayload.asLong()) : null;
        } else if (Integer.class.equals(propertyType)) {
            value = dmrPayload.isDefined() ? Integer.valueOf(dmrPayload.asInt()) : null;
        } else if (Double.class.equals(propertyType)) {
            value = dmrPayload.isDefined() ? Double.valueOf(dmrPayload.asDouble()) : null;
        } else if (Float.class.equals(propertyType)) {
            value = dmrPayload.isDefined() ? Double.valueOf(dmrPayload.asDouble()) : null;
        } else if (String.class.equals(propertyType)) {
            value = dmrPayload.isDefined() ? dmrPayload.asString() : "";
        } else {
            throw new RuntimeException("Unsupported java type: " + propertyType.getName());
        }
        method.invoke(entity, value);
    }
}

