/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.patching;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.Values;

public final class RollbackLastPatch
implements OnlineCommand {
    private final Boolean resetConfiguration;
    private final Boolean overrideAll;
    private final Boolean overrideModules;
    private final List<String> overridePaths;
    private final List<String> preservePaths;

    private RollbackLastPatch(Builder builder) {
        this.resetConfiguration = builder.resetConfiguration;
        this.overrideAll = builder.overrideAll;
        this.overrideModules = builder.overrideModules;
        this.overridePaths = builder.overridePaths;
        this.preservePaths = builder.preservePaths;
    }

    public void apply(OnlineCommandContext ctx) throws IOException {
        Operations ops = new Operations(ctx.client);
        ops.invoke("rollback-last", Address.coreService((String)"patching"), Values.empty().andOptional("reset-configuration", this.resetConfiguration).andOptional("override-all", this.overrideAll).andOptional("override-modules", this.overrideModules).andListOptional(String.class, "override", this.overridePaths).andListOptional(String.class, "preserve", this.preservePaths));
    }

    public static final class Builder {
        private Boolean resetConfiguration;
        private Boolean overrideAll;
        private Boolean overrideModules;
        private List<String> overridePaths;
        private List<String> preservePaths;

        public Builder resetConfiguration(boolean resetConfiguration) {
            this.resetConfiguration = resetConfiguration;
            return this;
        }

        public Builder overrideAll(boolean overrideAll) {
            this.overrideAll = overrideAll;
            return this;
        }

        public Builder overrideModules(boolean overrideModules) {
            this.overrideModules = overrideModules;
            return this;
        }

        public Builder overridePaths(String ... pathsToOverride) {
            if (this.overridePaths == null && pathsToOverride != null) {
                this.overridePaths = new ArrayList<String>();
            }
            if (pathsToOverride != null) {
                this.overridePaths.addAll(Arrays.asList(pathsToOverride));
            }
            return this;
        }

        public Builder preservePaths(String ... pathsToPreserve) {
            if (this.preservePaths == null && pathsToPreserve != null) {
                this.preservePaths = new ArrayList<String>();
            }
            if (pathsToPreserve != null) {
                this.preservePaths.addAll(Arrays.asList(pathsToPreserve));
            }
            return this;
        }

        public RollbackLastPatch build() {
            return new RollbackLastPatch(this);
        }
    }
}

