/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.security;

import org.wildfly.extras.creaper.commands.security.AddAuthorizationModule;
import org.wildfly.extras.creaper.commands.security.AddLoginModule;
import org.wildfly.extras.creaper.commands.security.AddMappingModule;
import org.wildfly.extras.creaper.commands.security.AddSecurityDomain;
import org.wildfly.extras.creaper.commands.security.RemoveAuthorizationModule;
import org.wildfly.extras.creaper.commands.security.RemoveLoginModule;
import org.wildfly.extras.creaper.commands.security.RemoveMappingModule;
import org.wildfly.extras.creaper.commands.security.RemoveSecurityDomain;

public class Security {
    private Security() {
    }

    public static SecurityDomain securityDomain(String name) {
        return new SecurityDomain(name);
    }

    public static final class SecurityDomain {
        private final String name;

        private SecurityDomain(String name) {
            this.name = name;
        }

        public AddSecurityDomain.Builder add() {
            return new AddSecurityDomain.Builder(this.name);
        }

        public RemoveSecurityDomain remove() {
            return new RemoveSecurityDomain(this.name);
        }

        public AddLoginModule.Builder addLoginModule(String loginModuleCode) {
            return new AddLoginModule.Builder(loginModuleCode).securityDomainName(this.name);
        }

        public AddLoginModule.Builder addLoginModule(String loginModuleCode, String loginModuleName) {
            return new AddLoginModule.Builder(loginModuleCode, loginModuleName).securityDomainName(this.name);
        }

        public RemoveLoginModule removeLoginModule(String loginModuleName) {
            return new RemoveLoginModule(this.name, loginModuleName);
        }

        public AddAuthorizationModule.Builder addAuthorizationModule(String loginModuleCode) {
            return new AddAuthorizationModule.Builder(loginModuleCode).securityDomainName(this.name);
        }

        public AddAuthorizationModule.Builder addAuthorizationModule(String loginModuleCode, String authorizationModuleName) {
            return new AddAuthorizationModule.Builder(loginModuleCode, authorizationModuleName).securityDomainName(this.name);
        }

        public RemoveAuthorizationModule removeAuthorizationModule(String authorizationModuleName) {
            return new RemoveAuthorizationModule(this.name, authorizationModuleName);
        }

        public AddMappingModule.Builder addMappingModule(String mappingModuleCode) {
            return new AddMappingModule.Builder(mappingModuleCode).securityDomainName(this.name);
        }

        public AddMappingModule.Builder addMappingModule(String loginModuleCode, String mappingModuleName) {
            return new AddMappingModule.Builder(loginModuleCode, mappingModuleName).securityDomainName(this.name);
        }

        public RemoveMappingModule removeMappingModule(String mappingModuleName) {
            return new RemoveMappingModule(this.name, mappingModuleName);
        }

        public AddLoginModule.UsersRolesBuilder addUsersRolesLoginModule() {
            return (AddLoginModule.UsersRolesBuilder)new AddLoginModule.UsersRolesBuilder().securityDomainName(this.name);
        }

        public AddLoginModule.UsersRolesBuilder addUsersRolesLoginModule(String loginModuleCode) {
            return (AddLoginModule.UsersRolesBuilder)new AddLoginModule.UsersRolesBuilder(loginModuleCode).securityDomainName(this.name);
        }

        public AddLoginModule.AdvancedLdapBuilder addAdvancedLdapLoginModule() {
            return (AddLoginModule.AdvancedLdapBuilder)new AddLoginModule.AdvancedLdapBuilder().securityDomainName(this.name);
        }

        public AddLoginModule.AdvancedLdapBuilder addAdvancedLdapLoginModule(String loginModuleCode) {
            return (AddLoginModule.AdvancedLdapBuilder)new AddLoginModule.AdvancedLdapBuilder(loginModuleCode).securityDomainName(this.name);
        }

        public AddLoginModule.CertificateBuilder addCertificateLoginModule() {
            return (AddLoginModule.CertificateBuilder)new AddLoginModule.CertificateBuilder().securityDomainName(this.name);
        }

        public AddLoginModule.CertificateBuilder addCertificateLoginModule(String loginModuleCode) {
            return (AddLoginModule.CertificateBuilder)new AddLoginModule.CertificateBuilder(loginModuleCode).securityDomainName(this.name);
        }

        public AddLoginModule.CertificateRolesBuilder addCertificateRolesLoginModule() {
            return (AddLoginModule.CertificateRolesBuilder)new AddLoginModule.CertificateRolesBuilder().securityDomainName(this.name);
        }

        public AddLoginModule.CertificateRolesBuilder addCertificateRolesLoginModule(String loginModuleCode) {
            return (AddLoginModule.CertificateRolesBuilder)new AddLoginModule.CertificateRolesBuilder(loginModuleCode).securityDomainName(this.name);
        }

        public AddLoginModule.DatabaseCertificateBuilder addDatabaseCertificateLoginModule() {
            return (AddLoginModule.DatabaseCertificateBuilder)new AddLoginModule.DatabaseCertificateBuilder().securityDomainName(this.name);
        }

        public AddLoginModule.DatabaseCertificateBuilder addDatabaseCertificateLoginModule(String loginModuleCode) {
            return (AddLoginModule.DatabaseCertificateBuilder)new AddLoginModule.DatabaseCertificateBuilder(loginModuleCode).securityDomainName(this.name);
        }

        public AddLoginModule.DatabaseBuilder addDatabaseLoginModule() {
            return (AddLoginModule.DatabaseBuilder)new AddLoginModule.DatabaseBuilder().securityDomainName(this.name);
        }

        public AddLoginModule.DatabaseBuilder addDatabaseLoginModule(String loginModuleCode) {
            return (AddLoginModule.DatabaseBuilder)new AddLoginModule.DatabaseBuilder(loginModuleCode).securityDomainName(this.name);
        }

        public AddLoginModule.KerberosBuilder addKerberosLoginModule() {
            return (AddLoginModule.KerberosBuilder)new AddLoginModule.KerberosBuilder().securityDomainName(this.name);
        }

        public AddLoginModule.KerberosBuilder addKerberosLoginModule(String loginModuleCode) {
            return (AddLoginModule.KerberosBuilder)new AddLoginModule.KerberosBuilder(loginModuleCode).securityDomainName(this.name);
        }

        public AddLoginModule.LdapExtendedBuilder addLdapExtendedLoginModule() {
            return (AddLoginModule.LdapExtendedBuilder)new AddLoginModule.LdapExtendedBuilder().securityDomainName(this.name);
        }

        public AddLoginModule.LdapExtendedBuilder addLdapExtendedLoginModule(String loginModuleCode) {
            return (AddLoginModule.LdapExtendedBuilder)new AddLoginModule.LdapExtendedBuilder(loginModuleCode).securityDomainName(this.name);
        }

        public AddLoginModule.LdapBuilder addLdapLoginModule() {
            return (AddLoginModule.LdapBuilder)new AddLoginModule.LdapBuilder().securityDomainName(this.name);
        }

        public AddLoginModule.LdapBuilder addLdapLoginModule(String loginModuleCode) {
            return (AddLoginModule.LdapBuilder)new AddLoginModule.LdapBuilder(loginModuleCode).securityDomainName(this.name);
        }

        public AddLoginModule.RealmDirectBuilder addRealmDirectLoginModule() {
            return (AddLoginModule.RealmDirectBuilder)new AddLoginModule.RealmDirectBuilder().securityDomainName(this.name);
        }

        public AddLoginModule.RealmDirectBuilder addRealmDirectLoginModule(String loginModuleCode) {
            return (AddLoginModule.RealmDirectBuilder)new AddLoginModule.RealmDirectBuilder(loginModuleCode).securityDomainName(this.name);
        }

        public AddLoginModule.SpnegoBuilder addSpnegoLoginModule() {
            return (AddLoginModule.SpnegoBuilder)new AddLoginModule.SpnegoBuilder().securityDomainName(this.name);
        }

        public AddLoginModule.SpnegoBuilder addSpnegoLoginModule(String loginModuleCode) {
            return (AddLoginModule.SpnegoBuilder)new AddLoginModule.SpnegoBuilder(loginModuleCode).securityDomainName(this.name);
        }
    }
}

