/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.undertow;

import java.io.IOException;
import org.wildfly.extras.creaper.commands.undertow.UndertowListenerType;
import org.wildfly.extras.creaper.core.ServerVersion;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Operations;

public final class RemoveUndertowListener
implements OnlineCommand {
    private final UndertowListenerType listenerType;
    private final String listenerName;
    private final String serverName;

    private RemoveUndertowListener(Builder builder) {
        this.listenerType = builder.listenerType;
        this.listenerName = builder.listenerName;
        this.serverName = builder.serverName;
    }

    public void apply(OnlineCommandContext ctx) throws IOException {
        ctx.version.assertAtLeast(ServerVersion.VERSION_2_0_0);
        Operations ops = new Operations(ctx.client);
        Address listenerAddress = Address.subsystem((String)"undertow").and("server", this.serverName).and(this.listenerType.listenerTypeName(), this.listenerName);
        ops.remove(listenerAddress);
    }

    public String toString() {
        return "RemoveUndertowListener " + this.listenerName + " of type " + this.listenerType.listenerTypeName() + " for server " + this.serverName;
    }

    public static final class Builder {
        private final UndertowListenerType listenerType;
        private final String listenerName;
        private String serverName = "default-server";

        public Builder(UndertowListenerType listenerType, String listenerName) {
            if (listenerName == null) {
                throw new IllegalArgumentException("Name of the listener must be specified as non null value");
            }
            if (listenerType == null) {
                throw new IllegalArgumentException("Listener type must be specified as non null value");
            }
            this.listenerType = listenerType;
            this.listenerName = listenerName;
        }

        public RemoveUndertowListener forServer(String serverName) {
            this.serverName = serverName;
            return new RemoveUndertowListener(this);
        }

        public RemoveUndertowListener forDefaultServer() {
            return new RemoveUndertowListener(this);
        }
    }
}

