/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.auditlog;

import org.wildfly.extras.creaper.commands.foundation.offline.xml.GroovyXmlTransform;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.Subtree;
import org.wildfly.extras.creaper.core.CommandFailedException;
import org.wildfly.extras.creaper.core.offline.OfflineCommand;
import org.wildfly.extras.creaper.core.offline.OfflineCommandContext;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.OperationException;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.Values;

public final class AddAuditLogFileHandler
implements OnlineCommand,
OfflineCommand {
    private final String name;
    private final String formatter;
    private final int maxFailureCount;
    private final String path;
    private final String relativeTo;
    private final boolean replaceExisting;

    public AddAuditLogFileHandler(Builder builder) {
        this.name = builder.name;
        this.formatter = builder.formatter;
        this.maxFailureCount = builder.maxFailureCount;
        this.path = builder.path;
        this.relativeTo = builder.relativeTo;
        this.replaceExisting = builder.replaceExisting;
    }

    public void apply(OnlineCommandContext ctx) throws Exception {
        Operations ops = new Operations(ctx.client);
        Address handlerAddress = Address.coreService((String)"management").and("access", "audit").and("file-handler", this.name);
        if (this.replaceExisting) {
            try {
                ops.removeIfExists(handlerAddress);
            }
            catch (OperationException ex) {
                throw new CommandFailedException("Failed to remove existing file-handler " + this.name, (Throwable)ex);
            }
        }
        ops.add(handlerAddress, Values.empty().andOptional("name", this.name).andOptional("formatter", this.formatter).andOptional("max-failure-count", Integer.valueOf(this.maxFailureCount)).andOptional("path", this.path).andOptional("relative-to", this.relativeTo));
    }

    public void apply(OfflineCommandContext ctx) throws Exception {
        ctx.client.apply(new OfflineCommand[]{GroovyXmlTransform.of(AddAuditLogFileHandler.class).subtree("management", Subtree.management()).parameter("atrName", this.name).parameter("atrFormatter", this.formatter).parameter("atrMaxFailureCount", this.maxFailureCount).parameter("atrPath", this.path).parameter("atrRelativeTo", this.relativeTo).parameter("atrReplaceExisting", this.replaceExisting).build()});
    }

    public static final class Builder {
        private String name;
        private String formatter;
        private int maxFailureCount;
        private String path;
        private String relativeTo;
        private boolean replaceExisting;

        public Builder(String name) {
            if (name == null) {
                throw new IllegalArgumentException("File handler name must be specified as non null value");
            }
            if (name.isEmpty()) {
                throw new IllegalArgumentException("File handler name must not be an empty string");
            }
            this.name = name;
        }

        public Builder formatter(String formatter) {
            this.formatter = formatter;
            return this;
        }

        public Builder maxFailureCount(int maxFailureCount) {
            this.maxFailureCount = maxFailureCount;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder relativeTo(String relativeTo) {
            this.relativeTo = relativeTo;
            return this;
        }

        public Builder replaceExisting() {
            this.replaceExisting = true;
            return this;
        }

        public AddAuditLogFileHandler build() {
            if (this.path == null) {
                throw new IllegalArgumentException("Path parameter must be specified as non null value");
            }
            if (this.path.isEmpty()) {
                throw new IllegalArgumentException("Path parameter cannot be empty");
            }
            if (this.formatter == null) {
                throw new IllegalArgumentException("Formatter parameter must be specified as non null value");
            }
            if (this.formatter.isEmpty()) {
                throw new IllegalArgumentException("Formatter parameter cannot be empty");
            }
            return new AddAuditLogFileHandler(this);
        }
    }
}

