/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.elytron.tls;

import java.util.HashMap;
import java.util.Map;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.GroovyXmlTransform;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.Subtree;
import org.wildfly.extras.creaper.core.ServerVersion;
import org.wildfly.extras.creaper.core.offline.OfflineCommand;
import org.wildfly.extras.creaper.core.offline.OfflineCommandContext;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.Values;
import org.wildfly.extras.creaper.core.online.operations.admin.Administration;

public final class AddTrustManager
implements OnlineCommand,
OfflineCommand {
    private final String name;
    private final String algorithm;
    private final String aliasFilter;
    private final String keyStore;
    private final String providerName;
    private final String providers;
    private final CertificateRevocationList certificateRevocationList;
    private final boolean replaceExisting;

    private AddTrustManager(Builder builder) {
        this.name = builder.name;
        this.algorithm = builder.algorithm;
        this.aliasFilter = builder.aliasFilter;
        this.keyStore = builder.keyStore;
        this.providerName = builder.providerName;
        this.providers = builder.providers;
        this.certificateRevocationList = builder.certificateRevocationList;
        this.replaceExisting = builder.replaceExisting;
    }

    public void apply(OnlineCommandContext ctx) throws Exception {
        if (ctx.version.lessThan(ServerVersion.VERSION_5_0_0)) {
            throw new AssertionError((Object)"Elytron is available since WildFly 11.");
        }
        Operations ops = new Operations(ctx.client);
        Address trustManagerAddress = Address.subsystem((String)"elytron").and("trust-manager", this.name);
        if (this.replaceExisting) {
            ops.removeIfExists(trustManagerAddress);
            new Administration(ctx.client).reloadIfRequired();
        }
        ops.add(trustManagerAddress, Values.empty().and("name", this.name).and("key-store", this.keyStore).andOptional("algorithm", this.algorithm).andOptional("alias-filter", this.aliasFilter).andOptional("provider-name", this.providerName).andOptional("providers", this.providers).andObjectOptional("certificate-revocation-list", this.certificateRevocationList != null ? this.certificateRevocationList.toValues() : null));
    }

    public void apply(OfflineCommandContext ctx) throws Exception {
        if (ctx.version.lessThan(ServerVersion.VERSION_5_0_0)) {
            throw new AssertionError((Object)"Elytron is available since WildFly 11.");
        }
        ctx.client.apply(new OfflineCommand[]{GroovyXmlTransform.of(AddTrustManager.class).subtree("elytronSubsystem", Subtree.subsystem("elytron")).parameter("atrName", this.name).parameter("atrAlgorithm", this.algorithm).parameter("atrAliasFilter", this.aliasFilter).parameter("atrKeyStore", this.keyStore).parameter("atrProviderName", this.providerName).parameter("atrProviders", this.providers).parameters(this.certificateRevocationList != null ? this.certificateRevocationList.toParameters() : CertificateRevocationList.EMPTY_PARAMETERS).parameter("atrReplaceExisting", this.replaceExisting).build()});
    }

    public static final class CertificateRevocationListBuilder {
        private String path;
        private String relativeTo;
        private Integer maximumCertPath;

        public CertificateRevocationListBuilder path(String path) {
            this.path = path;
            return this;
        }

        public CertificateRevocationListBuilder relativeTo(String relativeTo) {
            this.relativeTo = relativeTo;
            return this;
        }

        public CertificateRevocationListBuilder maximumCertPath(int maximumCertPath) {
            this.maximumCertPath = maximumCertPath;
            return this;
        }

        public CertificateRevocationList build() {
            if (this.relativeTo != null && this.path == null) {
                throw new IllegalArgumentException("relativeTo requires path to be set");
            }
            return new CertificateRevocationList(this);
        }
    }

    public static final class CertificateRevocationList {
        static final Map<String, Object> EMPTY_PARAMETERS = new HashMap<String, Object>();
        private final String path;
        private final String relativeTo;
        private final Integer maximumCertPath;

        private CertificateRevocationList(CertificateRevocationListBuilder builder) {
            this.path = builder.path;
            this.relativeTo = builder.relativeTo;
            this.maximumCertPath = builder.maximumCertPath;
        }

        public String getPath() {
            return this.path;
        }

        public String getRelativeTo() {
            return this.relativeTo;
        }

        public Integer getMaximumCertPath() {
            return this.maximumCertPath;
        }

        public Values toValues() {
            return Values.empty().andOptional("path", this.path).andOptional("relative-to", this.relativeTo).andOptional("maximum-cert-path", this.maximumCertPath);
        }

        public Map<String, Object> toParameters() {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("atrCrl", true);
            parameters.put("atrCrlPath", this.path);
            parameters.put("atrCrlRelativeTo", this.relativeTo);
            parameters.put("atrCrlMaximumCertPath", this.maximumCertPath);
            return parameters;
        }

        static {
            EMPTY_PARAMETERS.put("atrCrl", false);
            EMPTY_PARAMETERS.put("atrCrlPath", null);
            EMPTY_PARAMETERS.put("atrCrlRelativeTo", null);
            EMPTY_PARAMETERS.put("atrCrlMaximumCertPath", null);
        }
    }

    public static final class Builder {
        private final String name;
        private String algorithm;
        private String aliasFilter;
        private String keyStore;
        private String providerName;
        private String providers;
        private CertificateRevocationList certificateRevocationList;
        private boolean replaceExisting;

        public Builder(String name) {
            if (name == null || name.isEmpty()) {
                throw new IllegalArgumentException("Name of the trust-manager must be specified as non empty value");
            }
            this.name = name;
        }

        public Builder algorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Builder aliasFilter(String aliasFilter) {
            this.aliasFilter = aliasFilter;
            return this;
        }

        public Builder keyStore(String keyStore) {
            this.keyStore = keyStore;
            return this;
        }

        public Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public Builder providers(String providers) {
            this.providers = providers;
            return this;
        }

        public Builder certificateRevocationList(CertificateRevocationList certificateRevocationList) {
            this.certificateRevocationList = certificateRevocationList;
            return this;
        }

        public Builder replaceExisting() {
            this.replaceExisting = true;
            return this;
        }

        public AddTrustManager build() {
            return new AddTrustManager(this);
        }
    }
}

