/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.messaging;

import java.io.IOException;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.GroovyXmlTransform;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.Subtree;
import org.wildfly.extras.creaper.commands.messaging.MessagingUtils;
import org.wildfly.extras.creaper.core.CommandFailedException;
import org.wildfly.extras.creaper.core.offline.OfflineCommand;
import org.wildfly.extras.creaper.core.offline.OfflineCommandContext;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Operations;

public final class DisableMessagingSecurity
implements OfflineCommand,
OnlineCommand {
    private final String serverName;

    public DisableMessagingSecurity() {
        this("default");
    }

    public DisableMessagingSecurity(String serverName) {
        if (serverName == null) {
            throw new IllegalArgumentException("Messaging server name must be specified as non null value");
        }
        this.serverName = serverName;
    }

    public void apply(OfflineCommandContext ctx) throws CommandFailedException, IOException {
        GroovyXmlTransform disableSecurity = GroovyXmlTransform.of(DisableMessagingSecurity.class).subtree("messagingHornetq", Subtree.subsystem("messaging")).subtree("messagingActivemq", Subtree.subsystem("messaging-activemq")).build();
        ctx.client.apply(new OfflineCommand[]{disableSecurity});
    }

    public void apply(OnlineCommandContext ctx) throws Exception {
        Operations ops = new Operations(ctx.client);
        Address address = MessagingUtils.address(ctx.client, this.serverName);
        ops.writeAttribute(address, "security-enabled", false);
    }
}

