/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.security.realms;

import com.google.common.io.BaseEncoding;
import java.io.IOException;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.GroovyXmlTransform;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.Subtree;
import org.wildfly.extras.creaper.commands.security.realms.AbstractAddSecurityRealmSubElement;
import org.wildfly.extras.creaper.core.ServerVersion;
import org.wildfly.extras.creaper.core.offline.OfflineCommand;
import org.wildfly.extras.creaper.core.offline.OfflineCommandContext;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.Values;
import org.wildfly.extras.creaper.core.online.operations.admin.Administration;

public final class AddSecretAuthentication
extends AbstractAddSecurityRealmSubElement {
    private final String password;

    protected AddSecretAuthentication(Builder builder) {
        super(builder);
        this.password = builder.password;
    }

    public void apply(OfflineCommandContext ctx) throws Exception {
        if (ctx.version.greaterThanOrEqualTo(ServerVersion.VERSION_18_0_0)) {
            throw new AssertionError((Object)"Legacy security was removed in WildFly 25.");
        }
        ctx.client.apply(new OfflineCommand[]{GroovyXmlTransform.of(AddSecretAuthentication.class).subtree("management", Subtree.management()).parameter("realmName", this.securityRealmName).parameter("password", this.password).parameter("replaceExisting", this.replaceExisting).build()});
    }

    public void apply(OnlineCommandContext ctx) throws Exception {
        if (ctx.version.greaterThanOrEqualTo(ServerVersion.VERSION_18_0_0)) {
            throw new AssertionError((Object)"Legacy security was removed in WildFly 25.");
        }
        Address secretServerIdentitiesAddress = this.securityRealmAddress.and("server-identity", "secret");
        Operations ops = new Operations(ctx.client);
        if (this.replaceExisting) {
            boolean secretServerIdentityExists = ops.exists(secretServerIdentitiesAddress);
            if (secretServerIdentityExists) {
                ops.remove(secretServerIdentitiesAddress);
            }
            new Administration(ctx.client).reloadIfRequired();
        }
        ops.add(secretServerIdentitiesAddress, Values.empty().and("value", this.password));
    }

    public static final class Builder
    extends AbstractAddSecurityRealmSubElement.Builder<Builder> {
        private String password;

        public Builder(String securityRealmName) {
            super(securityRealmName);
        }

        public Builder password(String password) throws IOException {
            this.password = BaseEncoding.base64().encode(password.getBytes("UTF-8"));
            return this;
        }

        public Builder passwordBase64(String password) throws IOException {
            this.password = password;
            return this;
        }

        @Override
        public AddSecretAuthentication build() {
            if (this.password == null) {
                throw new IllegalArgumentException("Password must be specified");
            }
            return new AddSecretAuthentication(this);
        }
    }
}

