/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.socketbindings;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.wildfly.extras.creaper.core.CommandFailedException;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.OperationException;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.Values;

public final class AddSocketBinding
implements OnlineCommand {
    private final String socketBindingName;
    private final String socketBindingGroup;
    private final List<String> clientMappings;
    private final Boolean fixedPort;
    private final String interfaceName;
    private final String multicastAddress;
    private final Integer multicastPort;
    private final Integer port;
    private final boolean replaceExisting;

    private AddSocketBinding(Builder builder) {
        this.socketBindingName = builder.socketBindingName;
        this.socketBindingGroup = builder.socketBindingGroup;
        this.clientMappings = builder.clientMappings;
        this.fixedPort = builder.fixedPort;
        this.interfaceName = builder.interfaceName;
        this.multicastAddress = builder.multicastAddress;
        this.multicastPort = builder.multicastPort;
        this.port = builder.port;
        this.replaceExisting = builder.replaceExisting;
    }

    public void apply(OnlineCommandContext ctx) throws CommandFailedException, IOException {
        Operations ops = new Operations(ctx.client);
        String socketBindingGroup = this.socketBindingGroup;
        if (socketBindingGroup == null) {
            socketBindingGroup = ctx.client.options().isDomain ? "full-sockets" : "standard-sockets";
        }
        Address socketBindingAddress = Address.of((String)"socket-binding-group", (String)socketBindingGroup).and("socket-binding", this.socketBindingName);
        if (this.replaceExisting) {
            try {
                ops.removeIfExists(socketBindingAddress);
            }
            catch (OperationException e) {
                throw new CommandFailedException("Failed to remove existing socket binding " + this.socketBindingName, (Throwable)e);
            }
        }
        ops.add(socketBindingAddress, Values.empty().andListOptional(String.class, "client-mappings", this.clientMappings).andOptional("fixed-port", this.fixedPort).andOptional("interface", this.interfaceName).andOptional("multicast-address", this.multicastAddress).andOptional("multicast-port", this.multicastPort).andOptional("port", this.port));
    }

    public static final class Builder {
        private final String socketBindingName;
        private final String socketBindingGroup;
        private List<String> clientMappings;
        private Boolean fixedPort;
        private String interfaceName;
        private String multicastAddress;
        private Integer multicastPort;
        private Integer port;
        private boolean replaceExisting;

        public Builder(String socketBindingName) {
            this(socketBindingName, null);
        }

        public Builder(String socketBindingName, String socketBindingGroup) {
            this.socketBindingName = socketBindingName;
            this.socketBindingGroup = socketBindingGroup;
        }

        public Builder clientMappings(String ... clientMappingsToAdd) {
            if (this.clientMappings == null && clientMappingsToAdd != null) {
                this.clientMappings = new ArrayList<String>();
            }
            if (clientMappingsToAdd != null) {
                this.clientMappings.addAll(Arrays.asList(clientMappingsToAdd));
            }
            return this;
        }

        public Builder fixedPort(boolean isPortFixed) {
            this.fixedPort = isPortFixed;
            return this;
        }

        public Builder interfaceName(String interfaceName) {
            this.interfaceName = interfaceName;
            return this;
        }

        public Builder multicastAddress(String multicastAddress) {
            this.multicastAddress = multicastAddress;
            return this;
        }

        public Builder multicastPort(Integer multicastPort) {
            this.multicastPort = multicastPort;
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public Builder replaceExisting(boolean replaceExisting) {
            this.replaceExisting = replaceExisting;
            return this;
        }

        public AddSocketBinding build() {
            return new AddSocketBinding(this);
        }
    }
}

