/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.config;

import java.util.regex.Pattern;

public class LayerConfig {
    public static LayerConfig FUSE_LAYER = new LayerConfig("fuse", Type.INSTALLING, -10);
    public final String name;
    public final Pattern pattern;
    public final Type type;
    public final int priority;

    public LayerConfig(String nameAndVersion, Type type, int priority) {
        this.name = nameAndVersion;
        this.type = type;
        this.priority = priority;
        String shortName = nameAndVersion;
        int i = nameAndVersion.indexOf("_");
        if (i > 0) {
            shortName = nameAndVersion.substring(0, i);
        }
        this.pattern = Pattern.compile("^" + Pattern.quote(shortName) + "(_.*)?$");
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LayerConfig)) {
            return false;
        }
        LayerConfig other = (LayerConfig)obj;
        return this.name.equals(other.name) && this.priority == other.priority && this.type.equals((Object)other.type);
    }

    public String toString() {
        return "Layer[name=" + this.name + ",prio=" + this.priority + ",type=" + (Object)((Object)this.type) + "]";
    }

    public static enum Type {
        INSTALLING,
        OPTIONAL,
        REQUIRED;

    }
}

