/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.vertx.logging;

import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.msc.service.StartException;

@MessageLogger(projectCode="WFLYVTX", length=4)
public interface VertxLogger
extends BasicLogger {
    public static final VertxLogger VERTX_LOGGER = (VertxLogger)Logger.getMessageLogger(VertxLogger.class, (String)"org.wildfly.extension.vertx");

    @Message(id=1, value="Could not read VertxOptions from file: %s")
    public OperationFailedException cannotReadVertxOptionsFile(String var1);

    @Message(id=2, value="Could not find VertxOptions from: %s")
    public OperationFailedException failedToReadVertxOptions(String var1, @Cause Exception var2);

    @Message(id=3, value="Failed to start VertxProxyService")
    public StartException failedToStartVertxService(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=4, value="Error when closing the Vert.x instance")
    public void errorWhenClosingVertx(@Cause Exception var1);

    @Message(id=5, value="Deployment %s requires use of the '%s' capability but it is not currently registered")
    public DeploymentUnitProcessingException deploymentRequiresCapability(String var1, String var2);

    @Message(id=6, value="Path of the vertx-options-file %s must be specified")
    public OperationFailedException noOptionsFileSpecified(String var1);

    @Message(id=7, value="Absolute directory %s is not allowed for the VertxOptions file")
    public OperationFailedException absoluteDirectoryNotAllowed(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=8, value="Use Vertx instance from vertx subsystem")
    public void useVertxFromSubsystem();

    @Message(id=9, value="There is no vertx defined from vertx subsystem")
    public IllegalStateException noVertxDefined();
}

