/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.vertx.processors;

import io.smallrye.common.annotation.Identifier;
import io.vertx.core.Vertx;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanAttributes;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.InjectionTarget;
import jakarta.enterprise.inject.spi.InjectionTargetFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import org.wildfly.extension.vertx.VertxProxy;
import org.wildfly.extension.vertx.VertxProxyHolder;
import org.wildfly.extension.vertx.logging.VertxLogger;

public class CDIExtension
implements Extension {
    public void registerVertxBean(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        if (VertxProxyHolder.instance().getVertxProxy() != null) {
            Set<Identifier.Literal> qualifiers = Set.of(Any.Literal.INSTANCE, Identifier.Literal.of((String)"vertx"));
            AnnotatedType rawAnnotatedType = beanManager.createAnnotatedType(Vertx.class);
            BeanAttributesWrapper rawBeanAttributes = new BeanAttributesWrapper(beanManager.createBeanAttributes(rawAnnotatedType), qualifiers);
            afterBeanDiscovery.addBean(beanManager.createBean(rawBeanAttributes, Vertx.class, (InjectionTargetFactory)new AbstractVertxProducer<Vertx>(){

                @Override
                protected Vertx produceBeanObject(CreationalContext<Vertx> ctx) {
                    return CDIExtension.rawVertx();
                }
            }));
            AnnotatedType mutinyAnnotatedType = beanManager.createAnnotatedType(io.vertx.mutiny.core.Vertx.class);
            BeanAttributesWrapper mutinyBeanAttributes = new BeanAttributesWrapper(beanManager.createBeanAttributes(mutinyAnnotatedType), qualifiers);
            afterBeanDiscovery.addBean(beanManager.createBean(mutinyBeanAttributes, io.vertx.mutiny.core.Vertx.class, (InjectionTargetFactory)new AbstractVertxProducer<io.vertx.mutiny.core.Vertx>(){

                @Override
                protected io.vertx.mutiny.core.Vertx produceBeanObject(CreationalContext<io.vertx.mutiny.core.Vertx> ctx) {
                    return CDIExtension.mutinyVertx();
                }
            }));
        }
    }

    private static io.vertx.mutiny.core.Vertx mutinyVertx() {
        VertxProxy vertxProxy = VertxProxyHolder.instance().getVertxProxy();
        if (vertxProxy == null) {
            throw VertxLogger.VERTX_LOGGER.noVertxDefined();
        }
        VertxLogger.VERTX_LOGGER.useVertxFromSubsystem();
        return vertxProxy.getMutiyVertx();
    }

    private static Vertx rawVertx() {
        VertxProxy vertxProxy = VertxProxyHolder.instance().getVertxProxy();
        if (vertxProxy == null) {
            throw VertxLogger.VERTX_LOGGER.noVertxDefined();
        }
        VertxLogger.VERTX_LOGGER.useVertxFromSubsystem();
        return vertxProxy.getVertx();
    }

    private static class BeanAttributesWrapper<T>
    implements BeanAttributes<T> {
        private final BeanAttributes<T> delegate;
        private final Set<Annotation> qualifiers;

        BeanAttributesWrapper(BeanAttributes<T> delegate, Set<Annotation> qualifiers) {
            this.delegate = delegate;
            this.qualifiers = new HashSet<Annotation>(qualifiers);
        }

        public Set<Type> getTypes() {
            return this.delegate.getTypes();
        }

        public Set<Annotation> getQualifiers() {
            return this.qualifiers;
        }

        public Class<? extends Annotation> getScope() {
            return this.delegate.getScope();
        }

        public String getName() {
            return this.delegate.getName();
        }

        public Set<Class<? extends Annotation>> getStereotypes() {
            return this.delegate.getStereotypes();
        }

        public boolean isAlternative() {
            return this.delegate.isAlternative();
        }
    }

    private static abstract class AbstractVertxProducer<T>
    implements InjectionTargetFactory<T> {
        private AbstractVertxProducer() {
        }

        public InjectionTarget<T> createInjectionTarget(Bean<T> bean) {
            return new InjectionTarget<T>(){

                public T produce(CreationalContext<T> ctx) {
                    return this.produceBeanObject(ctx);
                }

                public void dispose(T instance) {
                }

                public Set<InjectionPoint> getInjectionPoints() {
                    return Set.of();
                }

                public void inject(T instance, CreationalContext<T> ctx) {
                }

                public void postConstruct(T instance) {
                }

                public void preDestroy(T instance) {
                }
            };
        }

        protected abstract T produceBeanObject(CreationalContext<T> var1);
    }
}

