/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.action.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.transformer.TransformException;
import org.eclipse.transformer.action.Action;
import org.eclipse.transformer.action.ActionType;
import org.eclipse.transformer.action.ContainerAction;
import org.eclipse.transformer.action.impl.ActionImpl;
import org.eclipse.transformer.action.impl.CompositeActionImpl;
import org.eclipse.transformer.action.impl.ContainerChangesImpl;
import org.eclipse.transformer.action.impl.InputBufferImpl;
import org.eclipse.transformer.action.impl.SelectionRuleImpl;
import org.eclipse.transformer.action.impl.SignatureRuleImpl;
import org.eclipse.transformer.util.ByteData;
import org.eclipse.transformer.util.FileUtils;
import org.eclipse.transformer.util.InputStreamData;
import org.slf4j.Logger;

public abstract class ContainerActionImpl
extends ActionImpl
implements ContainerAction {
    private final CompositeActionImpl compositeAction = this.createUsing(CompositeActionImpl::new);

    public <A extends ActionImpl> A addUsing(ActionImpl.ActionInit<A> init) {
        A action = this.createUsing(init);
        this.addAction((ActionImpl)action);
        return action;
    }

    public ContainerActionImpl(Logger logger, boolean isTerse, boolean isVerbose, InputBufferImpl buffer, SelectionRuleImpl selectionRule, SignatureRuleImpl signatureRule) {
        super(logger, isTerse, isVerbose, buffer, selectionRule, signatureRule);
    }

    @Override
    public CompositeActionImpl getAction() {
        return this.compositeAction;
    }

    public void addAction(ActionImpl action) {
        this.getAction().addAction(action);
    }

    public List<ActionImpl> getActions() {
        return this.getAction().getActions();
    }

    @Override
    public String getAcceptExtension() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ActionImpl acceptAction(String resourceName) {
        return this.acceptAction(resourceName, null);
    }

    @Override
    public ActionImpl acceptAction(String resourceName, File resourceFile) {
        return this.getAction().acceptAction(resourceName, resourceFile);
    }

    @Override
    public abstract String getName();

    @Override
    public abstract ActionType getActionType();

    @Override
    protected ContainerChangesImpl newChanges() {
        return new ContainerChangesImpl();
    }

    @Override
    public ContainerChangesImpl getLastActiveChanges() {
        return (ContainerChangesImpl)super.getLastActiveChanges();
    }

    @Override
    public ContainerChangesImpl getActiveChanges() {
        return (ContainerChangesImpl)super.getActiveChanges();
    }

    protected void recordUnaccepted(String resourceName) {
        this.debug("Resource [ {} ]: Not accepted", resourceName);
        this.getActiveChanges().record();
    }

    protected void recordUnselected(Action action, String resourceName) {
        this.debug("Resource [ {} ] Action [ {} ]: Accepted but not selected", resourceName, action.getName());
        this.getActiveChanges().record(action, false);
    }

    protected void recordTransform(Action action, String resourceName) {
        this.debug("Resource [ {} ] Action [ {} ]: Changes [ {} ]", resourceName, action.getName(), action.hadChanges());
        this.getActiveChanges().record(action);
    }

    @Override
    public boolean useStreams() {
        return true;
    }

    @Override
    public ByteData apply(String inputName, byte[] inputBytes, int inputLength) throws TransformException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(String inputPath, InputStream inputStream, long inputCount, OutputStream outputStream) throws TransformException {
        this.startRecording(inputPath);
        try {
            this.setResourceNames(inputPath, inputPath);
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
            try {
                this.apply(inputPath, zipInputStream, zipOutputStream);
            }
            finally {
                try {
                    zipOutputStream.finish();
                }
                catch (IOException e) {
                    throw new TransformException("Failed to complete output [ " + inputPath + " ]", e);
                }
            }
        }
        finally {
            this.stopRecording(inputPath);
        }
    }

    protected void apply(String inputPath, ZipInputStream zipInputStream, ZipOutputStream zipOutputStream) throws TransformException {
        String prevName = null;
        String inputName = null;
        try {
            ZipEntry inputEntry;
            byte[] buffer = new byte[65536];
            while ((inputEntry = zipInputStream.getNextEntry()) != null) {
                inputName = inputEntry.getName();
                long inputLength = inputEntry.getSize();
                this.debug("[ {}.{} ] [ {} ] Size [ {} ]", this.getClass().getSimpleName(), "apply", inputName, inputLength);
                boolean selected = this.select(inputName);
                ActionImpl acceptedAction = this.acceptAction(inputName);
                if (!selected || acceptedAction == null) {
                    if (acceptedAction == null) {
                        this.recordUnaccepted(inputName);
                    } else {
                        this.recordUnselected(acceptedAction, inputName);
                    }
                    ZipEntry outputEntry = new ZipEntry(inputName);
                    zipOutputStream.putNextEntry(outputEntry);
                    FileUtils.transfer(zipInputStream, zipOutputStream, buffer);
                    zipOutputStream.closeEntry();
                } else if (acceptedAction.useStreams()) {
                    ZipEntry outputEntry = new ZipEntry(inputName);
                    zipOutputStream.putNextEntry(outputEntry);
                    acceptedAction.apply(inputName, zipInputStream, inputLength, zipOutputStream);
                    this.recordTransform(acceptedAction, inputName);
                    zipOutputStream.closeEntry();
                } else {
                    int intInputLength = inputLength == -1L ? -1 : FileUtils.verifyArray(0, inputLength);
                    InputStreamData outputData = acceptedAction.apply(inputName, zipInputStream, intInputLength);
                    this.recordTransform(acceptedAction, inputName);
                    ZipEntry outputEntry = new ZipEntry(acceptedAction.getLastActiveChanges().getOutputResourceName());
                    zipOutputStream.putNextEntry(outputEntry);
                    FileUtils.transfer(outputData.stream, zipOutputStream, buffer);
                    zipOutputStream.closeEntry();
                }
                prevName = inputName;
                inputName = null;
            }
        }
        catch (IOException e) {
            String message = inputName != null ? "Failure while processing [ " + inputName + " ] from [ " + inputPath + " ]" : (prevName != null ? "Failure after processing [ " + prevName + " ] from [ " + inputPath + " ]" : "Failed to process first entry of [ " + inputPath + " ]");
            throw new TransformException(message, e);
        }
    }
}

