/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.transformer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.wildfly.extras.transformer.ResourceTransformer;

public abstract class ArchiveTransformer {
    protected final File configsDir;
    protected final boolean verbose;

    protected ArchiveTransformer(File configsDir, boolean verbose) {
        this.configsDir = configsDir;
        this.verbose = verbose;
    }

    public boolean transform(File inJarFile, File outJarFile) throws IOException {
        boolean transformed = false;
        File dir = outJarFile.getParentFile();
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Couldn't create directory: " + dir.getAbsolutePath());
        }
        if (outJarFile.exists() && !outJarFile.delete()) {
            throw new IOException("Couldn't delete file: " + outJarFile.getAbsolutePath());
        }
        if (!outJarFile.createNewFile()) {
            throw new IOException("Couldn't create file: " + outJarFile.getAbsolutePath());
        }
        ResourceTransformer t = this.newResourceTransformer();
        Calendar calendar = Calendar.getInstance();
        try (JarFile jar = new JarFile(inJarFile);
             JarOutputStream jarOutputStream = new JarOutputStream(new FileOutputStream(outJarFile));){
            Enumeration<JarEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                JarEntry inJarEntry = e.nextElement();
                if (inJarEntry.getSize() == 0L) continue;
                if (inJarEntry.getSize() < 0L) {
                    throw new UnsupportedOperationException("File size " + inJarEntry.getName() + " unknown! File size must be positive number");
                }
                if (inJarEntry.getSize() > Integer.MAX_VALUE) {
                    throw new UnsupportedOperationException("File " + inJarEntry.getName() + " too big! Maximum allowed file size is " + Integer.MAX_VALUE + " bytes");
                }
                byte[] buffer = new byte[(int)inJarEntry.getSize()];
                try (InputStream in = jar.getInputStream(inJarEntry);){
                    ArchiveTransformer.readBytes(in, buffer);
                }
                ResourceTransformer.Resource oldResource = new ResourceTransformer.Resource(inJarEntry.getName(), buffer);
                ResourceTransformer.Resource[] newResources = t.transform(oldResource);
                if (newResources.length == 0) {
                    newResources = new ResourceTransformer.Resource[]{oldResource};
                } else {
                    transformed = true;
                }
                for (ResourceTransformer.Resource newResource : newResources) {
                    JarEntry outJarEntry = new JarEntry(newResource.getName());
                    outJarEntry.setSize(newResource.getData().length);
                    outJarEntry.setTime(calendar.getTimeInMillis());
                    jarOutputStream.putNextEntry(outJarEntry);
                    ArchiveTransformer.writeBytes(jarOutputStream, newResource.getData());
                    jarOutputStream.closeEntry();
                }
            }
        }
        return transformed;
    }

    protected ResourceTransformer newResourceTransformer() throws IOException {
        throw new UnsupportedOperationException();
    }

    private static void readBytes(InputStream is, byte[] clazz) throws IOException {
        for (int offset = 0; offset < clazz.length; offset += is.read(clazz, offset, clazz.length - offset)) {
        }
    }

    private static void writeBytes(OutputStream os, byte[] clazz) throws IOException {
        os.write(clazz);
    }

    public boolean canTransformIndividualClassFile() {
        return false;
    }
}

