/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.config.generator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.plugin.ProvisionedConfigHandler;
import org.jboss.galleon.runtime.ProvisioningRuntime;
import org.jboss.galleon.state.ProvisionedConfig;
import org.wildfly.core.embedded.EmbeddedManagedProcess;
import org.wildfly.core.embedded.EmbeddedProcessFactory;
import org.wildfly.core.embedded.EmbeddedProcessStartException;
import org.wildfly.galleon.plugin.config.generator.WfProvisionedConfigHandler;

public class WfConfigGenerator {
    private Long bootTimeout = null;
    private String jbossHome;
    private EmbeddedManagedProcess embeddedProcess;
    private ModelControllerClient mcc;
    private boolean hc;
    private String[] args;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generate(ProvisioningRuntime runtime) throws ProvisioningException {
        ArrayList<String> toClear;
        this.jbossHome = runtime.getStagedDir().toString();
        MessageWriter messageWriter = runtime.getMessageWriter();
        WfProvisionedConfigHandler configHandler = new WfProvisionedConfigHandler(runtime, this);
        HashMap<Object, Object> originalProps = new HashMap<Object, Object>(System.getProperties());
        try {
            for (ProvisionedConfig config : runtime.getConfigs()) {
                if (runtime.getMessageWriter().isVerboseEnabled()) {
                    StringBuilder stringBuilder = new StringBuilder(64).append("Feature config");
                    if (config.getModel() != null) {
                        stringBuilder.append(" model=").append(config.getModel());
                    }
                    if (config.getName() != null) {
                        stringBuilder.append(" name=").append(config.getName());
                    }
                    messageWriter.verbose((CharSequence)stringBuilder);
                    if (config.hasProperties()) {
                        messageWriter.verbose((CharSequence)"  properties");
                        for (Map.Entry entry : config.getProperties().entrySet()) {
                            messageWriter.verbose("    %s=%s", new Object[]{entry.getKey(), entry.getValue()});
                        }
                    }
                }
                config.handle((ProvisionedConfigHandler)configHandler);
            }
        }
        catch (Throwable throwable) {
            try {
                if (this.embeddedProcess == null) throw throwable;
                this.stopEmbedded();
                throw throwable;
            }
            finally {
                ArrayList<String> toClear3 = new ArrayList<String>();
                for (Map.Entry<Object, Object> prop : System.getProperties().entrySet()) {
                    Object value = originalProps.get(prop.getKey());
                    if (value != null) {
                        System.setProperty(prop.getKey().toString(), value.toString());
                        continue;
                    }
                    toClear3.add(prop.getKey().toString());
                }
                if (!toClear3.isEmpty()) {
                    for (Map.Entry<Object, Object> prop : toClear3) {
                        System.clearProperty((String)((Object)prop));
                    }
                }
            }
        }
        try {
            if (this.embeddedProcess != null) {
                this.stopEmbedded();
            }
            toClear = new ArrayList<String>();
        }
        catch (Throwable throwable) {
            ArrayList<String> toClear2 = new ArrayList<String>();
            for (Map.Entry<Object, Object> prop : System.getProperties().entrySet()) {
                Object value = originalProps.get(prop.getKey());
                if (value != null) {
                    System.setProperty(prop.getKey().toString(), value.toString());
                    continue;
                }
                toClear2.add(prop.getKey().toString());
            }
            if (toClear2.isEmpty()) throw throwable;
            Iterator<Map.Entry<Object, Object>> iterator = toClear2.iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> prop;
                prop = (String)((Object)iterator.next());
                System.clearProperty((String)((Object)prop));
            }
            throw throwable;
        }
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            Object value = originalProps.get(entry.getKey());
            if (value != null) {
                System.setProperty(entry.getKey().toString(), value.toString());
                continue;
            }
            toClear.add(entry.getKey().toString());
        }
        if (toClear.isEmpty()) return;
        Iterator<Map.Entry<Object, Object>> iterator = toClear.iterator();
        while (iterator.hasNext()) {
            String string = (String)((Object)iterator.next());
            System.clearProperty(string);
        }
        return;
    }

    void startServer(String ... args) throws ProvisioningException {
        this.args = args;
        this.hc = false;
        this.embeddedProcess = EmbeddedProcessFactory.createStandaloneServer((String)this.jbossHome, null, null, (String[])args);
        try {
            this.embeddedProcess.start();
        }
        catch (EmbeddedProcessStartException e) {
            throw new ProvisioningException("Failed to start embedded server", (Throwable)e);
        }
        this.mcc = this.embeddedProcess.getModelControllerClient();
        this.waitForServer();
    }

    void startHc(String ... args) throws ProvisioningException {
        this.args = args;
        this.hc = true;
        this.embeddedProcess = EmbeddedProcessFactory.createHostController((String)this.jbossHome, null, null, (String[])args);
        try {
            this.embeddedProcess.start();
        }
        catch (EmbeddedProcessStartException e) {
            throw new ProvisioningException("Failed to start embedded hc", (Throwable)e);
        }
        this.mcc = this.embeddedProcess.getModelControllerClient();
    }

    void stopEmbedded() throws ProvisioningException {
        if (this.mcc != null) {
            try {
                this.mcc.close();
            }
            catch (IOException e) {
                throw new ProvisioningException("Failed to close ModelControllerClient", (Throwable)e);
            }
            this.mcc = null;
        }
        if (this.embeddedProcess != null) {
            this.embeddedProcess.stop();
            this.embeddedProcess = null;
        }
    }

    void execute(ModelNode op) throws ProvisioningException {
        try {
            ModelNode response = this.mcc.execute(op);
            if (Operations.isSuccessfulOutcome((ModelNode)response)) {
                return;
            }
            StringBuilder buf = new StringBuilder();
            buf.append("Failed to");
            if (this.hc) {
                String domainConfig = null;
                boolean emptyDomain = false;
                String hostConfig = null;
                boolean emptyHost = false;
                int i = 0;
                while (i < this.args.length) {
                    String arg;
                    if ((arg = this.args[i++]).startsWith("--domain-config")) {
                        if (arg.length() == "--domain-config".length()) {
                            domainConfig = this.args[i++];
                            continue;
                        }
                        domainConfig = arg.substring("--domain-config=".length());
                        continue;
                    }
                    if (arg.startsWith("--host-config")) {
                        if (arg.length() == "--host-config".length()) {
                            hostConfig = this.args[i++];
                            continue;
                        }
                        hostConfig = arg.substring("--host-config=".length());
                        continue;
                    }
                    if (arg.equals("--empty-host-config")) {
                        emptyHost = true;
                        continue;
                    }
                    if (!arg.equals("--empty-domain-config")) continue;
                    emptyDomain = true;
                }
                if (emptyDomain) {
                    buf.append(" generate ").append(domainConfig);
                    if (emptyHost) {
                        buf.append(" and ").append(hostConfig);
                    }
                } else if (emptyHost) {
                    buf.append(" generate ").append(hostConfig);
                } else {
                    buf.append(" execute script");
                }
            } else {
                String serverConfig = null;
                boolean emptyConfig = false;
                int i = 0;
                while (i < this.args.length) {
                    String arg;
                    if ((arg = this.args[i++]).equals("--server-config")) {
                        if (arg.length() == "--server-config".length()) {
                            serverConfig = this.args[i++];
                            continue;
                        }
                        serverConfig = arg.substring("--server-config=".length());
                        continue;
                    }
                    if (!arg.equals("--internal-empty-config")) continue;
                    emptyConfig = true;
                }
                if (emptyConfig) {
                    buf.append(" generate ").append(serverConfig);
                } else {
                    buf.append(" execute script");
                }
            }
            buf.append(" on ").append(op).append(": ").append(Operations.getFailureDescription((ModelNode)response));
            throw new ProvisioningException(buf.toString());
        }
        catch (IOException e) {
            throw new ProvisioningException("Failed to execute " + op);
        }
    }

    private void waitForServer() throws ProvisioningException {
        if (this.bootTimeout == null || this.bootTimeout > 0L) {
            long expired = this.bootTimeout == null ? Long.MAX_VALUE : System.nanoTime() + this.bootTimeout;
            String status = "starting";
            ModelNode getStateOp = new ModelNode();
            getStateOp.get("operation").set("read-attribute");
            getStateOp.get("name").set("server-state");
            do {
                try {
                    ModelNode response = this.mcc.execute(getStateOp);
                    if (Operations.isSuccessfulOutcome((ModelNode)response)) {
                        status = response.get("result").asString();
                    }
                }
                catch (Exception response) {
                    // empty catch block
                }
                if (!"starting".equals(status)) break;
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new ProvisioningException("Interrupted while waiting for embedded server to start");
                }
            } while (System.nanoTime() < expired);
            if ("starting".equals(status)) {
                assert (this.bootTimeout != null);
                this.stopEmbedded();
                throw new ProvisioningException("Embedded server did not exit 'starting' status within " + TimeUnit.NANOSECONDS.toSeconds(this.bootTimeout) + " seconds");
            }
        }
    }

    private void waitForHc() throws ProvisioningException {
        if (this.bootTimeout == null || this.bootTimeout > 0L) {
            long expired = this.bootTimeout == null ? Long.MAX_VALUE : System.nanoTime() + this.bootTimeout;
            String status = "starting";
            ModelNode getNameOp = new ModelNode();
            getNameOp.get("operation").set("read-attribute");
            getNameOp.get("name").set("local-host-name");
            ModelNode getStateOp = new ModelNode();
            getStateOp.get("operation").set("read-attribute");
            ModelNode address = getStateOp.get("address");
            getStateOp.get("name").set("host-state");
            do {
                try {
                    ModelNode nameResponse = this.mcc.execute(getNameOp);
                    if (Operations.isSuccessfulOutcome((ModelNode)nameResponse)) {
                        String localName = nameResponse.get("result").asString();
                        address.set("host", localName);
                        ModelNode stateResponse = this.mcc.execute(getStateOp);
                        if (Operations.isSuccessfulOutcome((ModelNode)stateResponse)) {
                            status = stateResponse.get("result").asString();
                        }
                    }
                }
                catch (Exception nameResponse) {
                    // empty catch block
                }
                if (!"starting".equals(status)) break;
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new ProvisioningException("Interrupted while waiting for embedded server to start");
                }
            } while (System.nanoTime() < expired);
            if ("starting".equals(status)) {
                assert (this.bootTimeout != null);
                this.stopEmbedded();
                throw new ProvisioningException("Embedded host controller did not exit 'starting' status within " + TimeUnit.NANOSECONDS.toSeconds(this.bootTimeout) + " seconds");
            }
        }
    }
}

