/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.config.generator;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.jboss.galleon.Errors;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.plugin.ProvisionedConfigHandler;
import org.jboss.galleon.runtime.ProvisioningRuntime;
import org.jboss.galleon.state.ProvisionedConfig;
import org.wildfly.core.embedded.EmbeddedManagedProcess;
import org.wildfly.core.embedded.EmbeddedProcessFactory;
import org.wildfly.core.embedded.EmbeddedProcessStartException;
import org.wildfly.galleon.plugin.config.generator.WfProvisionedConfigHandler;

public class WfConfigGenerator {
    private static final byte INITIAL = 0;
    private static final byte START_STANDALONE = 1;
    private static final byte START_HC = 2;
    private static final byte LOOKING_FOR_ARGS = 4;
    private static final byte EMBEDDED_STARTED = 8;
    private static final String BATCH = "batch";
    private static final String STOP = "stop";
    private static final String RUN_BATCH = "run-batch";
    private Long bootTimeout = null;
    private boolean forkEmbedded;
    private String jbossHome;
    private EmbeddedManagedProcess embeddedProcess;
    private ModelControllerClient mcc;
    private ModelNode composite;
    private boolean hc;
    private String[] args;
    private Path script;
    private PrintWriter scriptWriter;
    private StringBuilder scriptBuf;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(ProvisioningRuntime runtime, boolean forkEmbedded) throws ProvisioningException {
        this.forkEmbedded = forkEmbedded;
        this.jbossHome = runtime.getStagedDir().toString();
        HashMap<Object, Object> originalProps = forkEmbedded ? null : new HashMap<Object, Object>(System.getProperties());
        try {
            this.doGenerate(runtime);
        }
        finally {
            this.cleanup(originalProps);
        }
    }

    private void doGenerate(ProvisioningRuntime runtime) throws ProvisioningException {
        MessageWriter messageWriter = runtime.getMessageWriter();
        if (messageWriter.isVerboseEnabled()) {
            messageWriter.verbose("Generating WildFly-based configs forkEmbedded=%", new Object[]{this.forkEmbedded});
        }
        if (this.forkEmbedded) {
            this.initScriptWriter(runtime);
        }
        try (WfProvisionedConfigHandler configHandler = new WfProvisionedConfigHandler(runtime, this);){
            for (ProvisionedConfig config : runtime.getConfigs()) {
                if (runtime.getMessageWriter().isVerboseEnabled()) {
                    StringBuilder msg = new StringBuilder(64).append("Feature config");
                    if (config.getModel() != null) {
                        msg.append(" model=").append(config.getModel());
                    }
                    if (config.getName() != null) {
                        msg.append(" name=").append(config.getName());
                    }
                    messageWriter.verbose((CharSequence)msg);
                    if (config.hasProperties()) {
                        messageWriter.verbose((CharSequence)"  properties");
                        for (Map.Entry entry : config.getProperties().entrySet()) {
                            messageWriter.verbose("    %s=%s", new Object[]{entry.getKey(), entry.getValue()});
                        }
                    }
                }
                config.handle((ProvisionedConfigHandler)configHandler);
            }
        }
        if (this.forkEmbedded) {
            this.scriptWriter.close();
            this.scriptWriter = null;
            this.forkEmbedded(messageWriter);
        }
    }

    private void cleanup(Map<?, ?> originalProps) {
        if (this.embeddedProcess != null) {
            try {
                this.stopEmbedded();
            }
            catch (ProvisioningException e) {
                e.printStackTrace();
            }
        }
        if (this.scriptWriter != null) {
            this.scriptWriter.close();
        } else if (originalProps != null) {
            ArrayList<String> toClear = new ArrayList<String>();
            for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
                Object value = originalProps.get(entry.getKey());
                if (value != null) {
                    System.setProperty(entry.getKey().toString(), value.toString());
                    continue;
                }
                toClear.add(entry.getKey().toString());
            }
            if (!toClear.isEmpty()) {
                for (String string : toClear) {
                    System.clearProperty(string);
                }
            }
        }
    }

    private void initScriptWriter(ProvisioningRuntime runtime) throws ProvisioningException {
        this.scriptBuf = new StringBuilder();
        this.script = runtime.getTmpPath(new String[]{"forkedembedded.txt"});
        try {
            Files.createDirectories(this.script.getParent(), new FileAttribute[0]);
            this.scriptWriter = new PrintWriter(Files.newBufferedWriter(this.script, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.writeFile((Path)this.script), (Throwable)e);
        }
    }

    void startServer(String ... args) throws ProvisioningException {
        if (this.forkEmbedded) {
            this.writeScript("standalone");
            this.writeArgs(args);
        } else {
            this.doStartServer(args);
        }
    }

    private void doStartServer(String ... args) throws ProvisioningException {
        this.args = args;
        this.hc = false;
        this.embeddedProcess = EmbeddedProcessFactory.createStandaloneServer((String)this.jbossHome, null, null, (String[])args);
        try {
            this.embeddedProcess.start();
        }
        catch (EmbeddedProcessStartException e) {
            throw new ProvisioningException("Failed to start embedded server", (Throwable)e);
        }
        this.mcc = this.embeddedProcess.getModelControllerClient();
        this.waitForServer();
    }

    void startHc(String ... args) throws ProvisioningException {
        if (this.forkEmbedded) {
            this.writeScript("host");
            this.writeArgs(args);
        } else {
            this.doStartHc(args);
        }
    }

    private void writeArgs(String ... args) throws ProvisioningException {
        this.scriptBuf.setLength(0);
        this.scriptBuf.append(args[0]);
        for (int i = 1; i < args.length; ++i) {
            this.scriptBuf.append(',').append(args[i]);
        }
        this.writeScript(this.scriptBuf.toString());
    }

    private void doStartHc(String ... args) throws ProvisioningException {
        this.args = args;
        this.hc = true;
        this.embeddedProcess = EmbeddedProcessFactory.createHostController((String)this.jbossHome, null, null, (String[])args);
        try {
            this.embeddedProcess.start();
        }
        catch (EmbeddedProcessStartException e) {
            throw new ProvisioningException("Failed to start embedded hc", (Throwable)e);
        }
        this.mcc = this.embeddedProcess.getModelControllerClient();
    }

    void stopEmbedded() throws ProvisioningException {
        if (this.forkEmbedded) {
            this.writeScript(STOP);
        } else {
            this.doStopEmbedded();
        }
    }

    private void doStopEmbedded() throws ProvisioningException {
        if (this.mcc != null) {
            try {
                this.mcc.close();
            }
            catch (IOException e) {
                throw new ProvisioningException("Failed to close ModelControllerClient", (Throwable)e);
            }
            this.mcc = null;
        }
        if (this.embeddedProcess != null) {
            this.embeddedProcess.stop();
            this.embeddedProcess = null;
        }
    }

    void startBatch() throws ProvisioningException {
        if (this.forkEmbedded) {
            this.writeScript(BATCH);
        } else {
            this.composite = Operations.createCompositeOperation();
        }
    }

    void endBatch() throws ProvisioningException {
        if (this.forkEmbedded) {
            this.writeScript(RUN_BATCH);
        } else {
            this.doHandle(this.composite);
            this.composite = null;
        }
    }

    void handle(ModelNode op) throws ProvisioningException {
        if (this.forkEmbedded) {
            op.writeJSONString(this.scriptWriter, true);
            this.scriptWriter.println();
        } else if (this.composite != null) {
            this.composite.get("steps").add(op);
        } else {
            this.doHandle(op);
        }
    }

    private void doHandle(ModelNode op) throws ProvisioningException {
        try {
            ModelNode response = this.mcc.execute(op);
            if (Operations.isSuccessfulOutcome((ModelNode)response)) {
                return;
            }
            StringBuilder buf = new StringBuilder();
            buf.append("Failed to");
            if (this.hc) {
                String domainConfig = null;
                boolean emptyDomain = false;
                String hostConfig = null;
                boolean emptyHost = false;
                int i = 0;
                while (i < this.args.length) {
                    String arg;
                    if ((arg = this.args[i++]).startsWith("--domain-config")) {
                        if (arg.length() == "--domain-config".length()) {
                            domainConfig = this.args[i++];
                            continue;
                        }
                        domainConfig = arg.substring("--domain-config".length() + 1);
                        continue;
                    }
                    if (arg.startsWith("--host-config")) {
                        if (arg.length() == "--host-config".length()) {
                            hostConfig = this.args[i++];
                            continue;
                        }
                        hostConfig = arg.substring("--host-config".length() + 1);
                        continue;
                    }
                    if (arg.equals("--empty-host-config")) {
                        emptyHost = true;
                        continue;
                    }
                    if (!arg.equals("--empty-domain-config")) continue;
                    emptyDomain = true;
                }
                if (emptyDomain) {
                    buf.append(" generate ").append(domainConfig);
                    if (emptyHost && hostConfig != null) {
                        buf.append(" and ").append(hostConfig);
                    }
                } else if (emptyHost) {
                    buf.append(" generate ").append(hostConfig);
                } else {
                    buf.append(" execute script");
                }
            } else {
                String serverConfig = null;
                boolean emptyConfig = false;
                int i = 0;
                while (i < this.args.length) {
                    String arg;
                    if ((arg = this.args[i++]).equals("--server-config")) {
                        if (arg.length() == "--server-config".length()) {
                            serverConfig = this.args[i++];
                            continue;
                        }
                        serverConfig = arg.substring("--server-config".length() + 1);
                        continue;
                    }
                    if (!arg.equals("--internal-empty-config")) continue;
                    emptyConfig = true;
                }
                if (emptyConfig) {
                    buf.append(" generate ").append(serverConfig);
                } else {
                    buf.append(" execute script");
                }
            }
            buf.append(" on ").append(op).append(": ").append(Operations.getFailureDescription((ModelNode)response));
            throw new ProvisioningException(buf.toString());
        }
        catch (IOException e) {
            throw new ProvisioningException("Failed to execute " + op);
        }
    }

    private void waitForServer() throws ProvisioningException {
        if (this.bootTimeout == null || this.bootTimeout > 0L) {
            long expired = this.bootTimeout == null ? Long.MAX_VALUE : System.nanoTime() + this.bootTimeout;
            String status = "starting";
            ModelNode getStateOp = new ModelNode();
            getStateOp.get("operation").set("read-attribute");
            getStateOp.get("name").set("server-state");
            do {
                try {
                    ModelNode response = this.mcc.execute(getStateOp);
                    if (Operations.isSuccessfulOutcome((ModelNode)response)) {
                        status = response.get("result").asString();
                    }
                }
                catch (Exception response) {
                    // empty catch block
                }
                if (!"starting".equals(status)) break;
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new ProvisioningException("Interrupted while waiting for embedded server to start");
                }
            } while (System.nanoTime() < expired);
            if ("starting".equals(status)) {
                assert (this.bootTimeout != null);
                this.stopEmbedded();
                throw new ProvisioningException("Embedded server did not exit 'starting' status within " + TimeUnit.NANOSECONDS.toSeconds(this.bootTimeout) + " seconds");
            }
        }
    }

    private void waitForHc() throws ProvisioningException {
        if (this.bootTimeout == null || this.bootTimeout > 0L) {
            long expired = this.bootTimeout == null ? Long.MAX_VALUE : System.nanoTime() + this.bootTimeout;
            String status = "starting";
            ModelNode getNameOp = new ModelNode();
            getNameOp.get("operation").set("read-attribute");
            getNameOp.get("name").set("local-host-name");
            ModelNode getStateOp = new ModelNode();
            getStateOp.get("operation").set("read-attribute");
            ModelNode address = getStateOp.get("address");
            getStateOp.get("name").set("host-state");
            do {
                try {
                    ModelNode nameResponse = this.mcc.execute(getNameOp);
                    if (Operations.isSuccessfulOutcome((ModelNode)nameResponse)) {
                        String localName = nameResponse.get("result").asString();
                        address.set("host", localName);
                        ModelNode stateResponse = this.mcc.execute(getStateOp);
                        if (Operations.isSuccessfulOutcome((ModelNode)stateResponse)) {
                            status = stateResponse.get("result").asString();
                        }
                    }
                }
                catch (Exception nameResponse) {
                    // empty catch block
                }
                if (!"starting".equals(status)) break;
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new ProvisioningException("Interrupted while waiting for embedded server to start");
                }
            } while (System.nanoTime() < expired);
            if ("starting".equals(status)) {
                assert (this.bootTimeout != null);
                this.stopEmbedded();
                throw new ProvisioningException("Embedded host controller did not exit 'starting' status within " + TimeUnit.NANOSECONDS.toSeconds(this.bootTimeout) + " seconds");
            }
        }
    }

    private void writeScript(String line) throws ProvisioningException {
        this.scriptWriter.println(line);
    }

    private void forkEmbedded(MessageWriter messageWriter) throws ProvisioningException {
        Process p;
        StringBuilder cp = new StringBuilder();
        WfConfigGenerator.collectCpUrls(System.getProperty("java.home"), Thread.currentThread().getContextClassLoader(), cp);
        String[] commands = new String[]{"java", "-cp", cp.toString(), WfConfigGenerator.class.getName(), this.jbossHome, this.script.toString()};
        try {
            p = new ProcessBuilder(Arrays.asList(commands)).redirectErrorStream(true).start();
        }
        catch (IOException e) {
            throw new ProvisioningException("Failed to start a feature spec reading process", (Throwable)e);
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));){
            String line = reader.readLine();
            while (line != null) {
                messageWriter.verbose((CharSequence)line);
                line = reader.readLine();
            }
            if (p.isAlive()) {
                try {
                    p.waitFor();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (p.exitValue() != 0) {
                throw new RuntimeException("Process has failed");
            }
        }
        catch (IOException e) {
            throw new ProvisioningException("Process has failed", (Throwable)e);
        }
    }

    private static void collectCpUrls(String javaHome, ClassLoader cl, StringBuilder buf) {
        ClassLoader parentCl = cl.getParent();
        if (parentCl != null) {
            WfConfigGenerator.collectCpUrls(javaHome, cl.getParent(), buf);
        }
        if (cl instanceof URLClassLoader) {
            for (URL url : ((URLClassLoader)cl).getURLs()) {
                String file = url.getFile();
                if (file.startsWith(javaHome)) continue;
                if (buf.length() > 0) {
                    buf.append(File.pathSeparatorChar);
                }
                buf.append(file);
            }
        }
    }

    public static void main(String ... args) throws Exception {
        if (args.length != 2) {
            throw new IllegalArgumentException("Expected one argument but received " + Arrays.asList(args));
        }
        Path script = Paths.get(args[1], new String[0]);
        if (!Files.exists(script, new LinkOption[0])) {
            throw new ProvisioningException(Errors.pathDoesNotExist((Path)script));
        }
        try {
            WfConfigGenerator.executeScript(args[0], script);
        }
        catch (IOException e) {
            throw new ProvisioningException("Failed to execute configuration script", (Throwable)e);
        }
    }

    private static void executeScript(String jbossHome, Path script) throws IOException, ProvisioningException {
        WfConfigGenerator configGen = new WfConfigGenerator();
        configGen.jbossHome = jbossHome;
        int state = 0;
        try (BufferedReader reader = Files.newBufferedReader(script);){
            String line = reader.readLine();
            while (line != null) {
                if (state == 8) {
                    if (STOP.equals(line)) {
                        configGen.doStopEmbedded();
                        state = 0;
                    } else if (BATCH.equals(line)) {
                        configGen.startBatch();
                    } else if (RUN_BATCH.equals(line)) {
                        configGen.endBatch();
                    } else {
                        try {
                            configGen.handle(ModelNode.fromJSONString((String)line));
                        }
                        catch (RuntimeException t) {
                            System.out.println("Failed to parse '" + line + "'");
                            throw t;
                        }
                    }
                } else if ((state & 4) > 0) {
                    String[] args = line.split(",");
                    if ((state & 1) > 0) {
                        configGen.doStartServer(args);
                    } else if ((state & 2) > 0) {
                        configGen.doStartHc(args);
                    } else {
                        throw new IllegalStateException("Unexpected state " + state);
                    }
                    state = 8;
                } else {
                    if ("standalone".equals(line)) {
                        state = 1;
                    } else if ("host".equals(line)) {
                        state = 2;
                    } else {
                        throw new ProvisioningException("Unexpected controller type " + line);
                    }
                    state = (byte)(state | 4);
                }
                line = reader.readLine();
            }
        }
    }
}

