/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.config.generator;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.plugin.ProvisionedConfigHandler;
import org.jboss.galleon.runtime.ProvisioningRuntime;
import org.jboss.galleon.runtime.ResolvedFeatureSpec;
import org.jboss.galleon.state.ProvisionedConfig;
import org.jboss.galleon.state.ProvisionedFeature;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.CollectionUtils;

public class WfProvisionedStateDiff {
    private final FeatureSpecMapper fsMapper = new FeatureSpecMapper();

    public static List<ConfigModel> exportDiff(ProvisioningRuntime runtime, Map<FeaturePackLocation.FPID, ConfigId> includedConfigs, Path customizedInstallation, Path target) throws ProvisioningException {
        return new WfProvisionedStateDiff().diff(runtime);
    }

    private WfProvisionedStateDiff() {
    }

    private List<ConfigModel> diff(ProvisioningRuntime runtime) throws ProvisioningException {
        List configs = Collections.emptyList();
        for (ProvisionedConfig config : runtime.getConfigs()) {
            ConfigModel configDiff = this.diffConfig(config);
            if (configDiff == null) continue;
            configs = CollectionUtils.add(configs, (Object)configDiff);
        }
        return configs;
    }

    private ConfigModel diffConfig(ProvisionedConfig config) throws ProvisioningException {
        Map<String, List<ProvisionedFeature>> arrangedBySpec = this.fsMapper.arrangeBySpecName(config);
        return ConfigModel.builder().build();
    }

    public static class FeatureSpecMapper
    implements ProvisionedConfigHandler {
        private Map<String, List<ProvisionedFeature>> features;
        private String specName;
        private List<ProvisionedFeature> specFeatures;

        public Map<String, List<ProvisionedFeature>> arrangeBySpecName(ProvisionedConfig config) throws ProvisioningException {
            this.features = new HashMap<String, List<ProvisionedFeature>>(config.size());
            config.handle((ProvisionedConfigHandler)this);
            Map<String, List<ProvisionedFeature>> tmp = this.features;
            this.features = null;
            this.specName = null;
            this.specFeatures = null;
            return tmp;
        }

        public void nextSpec(ResolvedFeatureSpec spec) throws ProvisioningException {
            this.specName = spec.getName();
            this.specFeatures = this.features.get(this.specName);
            if (this.specFeatures == null) {
                this.specFeatures = new ArrayList<ProvisionedFeature>();
                this.features.put(this.specName, this.specFeatures);
            }
        }

        public void nextFeature(ProvisionedFeature feature) throws ProvisioningException {
            this.specFeatures.add(feature);
        }
    }
}

