/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.config.generator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.regex.Pattern;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.core.launcher.Launcher;
import org.wildfly.core.launcher.ProcessHelper;
import org.wildfly.core.launcher.StandaloneCommandBuilder;

public class CompleteServer {
    private Process process;
    private ServerOutputConsumer consumer;
    private final Path installDir;
    private final String serverConfig;

    public CompleteServer(Path installDir, String serverConfig) {
        this.installDir = installDir;
        this.serverConfig = serverConfig;
    }

    private Process launchServer(Path installDir, String serverConfig) throws IOException {
        Launcher launcher = new Launcher((CommandBuilder)StandaloneCommandBuilder.of((Path)installDir).setServerConfiguration(serverConfig)).setRedirectErrorStream(true).addEnvironmentVariable("JBOSS_HOME", installDir.toString());
        return launcher.launch();
    }

    public void startServer() throws IOException {
        this.process = this.launchServer(this.installDir, this.serverConfig);
        this.consumer = new ServerOutputConsumer(this.process.getInputStream());
        new Thread(this.consumer).start();
        this.waitUntilStarted();
    }

    public void stopServer() {
        try {
            ProcessHelper.destroyProcess((Process)this.process);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    private void waitUntilStarted() {
        while (!this.consumer.isStarted()) {
            try {
                Thread.sleep(100L);
                if (this.process.isAlive() || this.process.exitValue() == 0) continue;
                throw new IllegalStateException(String.format("Error executing synchronization. Couldn't start the installed server at %s", this.installDir.toAbsolutePath()));
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    private static class ServerOutputConsumer
    implements Runnable {
        private static final Pattern JBOSS_7_STARTED_ML = Pattern.compile(".*JBoss AS 7(\\..*)* \\d+ms .*");
        private static final Pattern WILDFLY_8_STARTED_ML = Pattern.compile(".*JBAS015874: WildFly 8(\\..*)* .* started in \\d+ms .*");
        private static final Pattern WILDFLY_9_STARTED_ML = Pattern.compile(".*WFLYSRV0050: WildFly Full \\d+(\\..*)* .* started in \\d+ms .*");
        private static final Pattern WILDFLY_10_STARTED_ML = Pattern.compile(".*WFLYSRV0025: WildFly .* \\d+(\\..*)* .* started in \\d+ms .*");
        private static final Pattern EAP6_STARTED_ML = Pattern.compile(".*JBAS015874: JBoss EAP 6\\.[0-9]?.[0-9]?\\.GA .* \\d+ms .*");
        private static final Pattern EAP7_STARTED_ML = Pattern.compile(".*WFLYSRV0025: JBoss EAP 7\\.[0-9]?.[0-9]?\\.GA .* \\d+ms .*");
        private final BufferedReader source;
        private volatile boolean started = false;

        private ServerOutputConsumer(InputStream source) {
            this.source = new BufferedReader(new InputStreamReader(source, StandardCharsets.UTF_8));
            this.started = false;
        }

        @Override
        public void run() {
            try (BufferedReader in = this.source;){
                String line;
                while ((line = in.readLine()) != null) {
                    if (this.started) continue;
                    this.started = this.isStarted(line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private boolean isStarted() {
            return this.started;
        }

        private boolean isStarted(String line) {
            return (line.contains("JBoss (MX MicroKernel)") || line.contains("JBoss (Microcontainer)") || line.contains("JBossAS") || line.contains("JBoss AS")) && line.contains("Started in") || line.contains("started in") || line.contains("started (with errors) in") || JBOSS_7_STARTED_ML.matcher(line).matches() || WILDFLY_8_STARTED_ML.matcher(line).matches() || WILDFLY_9_STARTED_ML.matcher(line).matches() || WILDFLY_10_STARTED_ML.matcher(line).matches() || EAP6_STARTED_ML.matcher(line).matches() || EAP7_STARTED_ML.matcher(line).matches();
        }
    }
}

