/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.config.generator;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import org.wildfly.galleon.plugin.config.generator.BaseConfigGenerator;
import org.wildfly.galleon.plugin.server.ConfigGeneratorException;
import org.wildfly.galleon.plugin.server.ForkCallback;

public class ForkedConfigGenerator
extends BaseConfigGenerator
implements ForkCallback {
    public void forkedForEmbedded(String ... args) throws ConfigGeneratorException {
        if (args.length != 2) {
            throw new IllegalArgumentException("Expected one argument but received " + Arrays.asList(args));
        }
        this.jbossHome = args[0];
        Path script = Paths.get(args[1], new String[0]);
        if (!Files.exists(script, new LinkOption[0])) {
            throw new ConfigGeneratorException("Failed to locate " + script.toAbsolutePath());
        }
        ForkedConfigGenerator.initializeEmbedded(Thread.currentThread().getContextClassLoader());
        try {
            this.executeScript(script);
        }
        catch (IOException e) {
            throw new ConfigGeneratorException("Failed to execute configuration script", (Throwable)e);
        }
    }

    private void executeScript(Path script) throws IOException, ConfigGeneratorException {
        byte state = 0;
        try (BufferedReader reader = Files.newBufferedReader(script);){
            String line = reader.readLine();
            while (line != null) {
                if (state == 8) {
                    if ("stop".equals(line)) {
                        this.doStopEmbedded();
                        state = 0;
                    } else if ("batch".equals(line)) {
                        this.startBatch();
                    } else if ("run-batch".equals(line)) {
                        this.endBatch();
                    } else {
                        try {
                            this.handle(line);
                        }
                        catch (RuntimeException t) {
                            System.out.println("Failed to parse '" + line + "'");
                            throw t;
                        }
                    }
                } else if ((state & 4) > 0) {
                    String[] args = line.split(",");
                    if ((state & 1) > 0) {
                        this.doStartServer(args);
                    } else if ((state & 2) > 0) {
                        this.doStartHc(args);
                    } else {
                        throw new IllegalStateException("Unexpected state " + state);
                    }
                    state = 8;
                } else {
                    if ("standalone".equals(line)) {
                        state = 1;
                    } else if ("host".equals(line)) {
                        state = 2;
                    } else {
                        throw new ConfigGeneratorException("Unexpected controller type " + line);
                    }
                    state = (byte)(state | 4);
                }
                line = reader.readLine();
            }
        }
    }
}

