/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.featurespec.generator;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.stream.XMLStreamException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.spec.FeatureAnnotation;
import org.jboss.galleon.spec.FeatureParameterSpec;
import org.jboss.galleon.spec.FeatureReferenceSpec;
import org.jboss.galleon.spec.FeatureSpec;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.xml.FeatureSpecXmlWriter;
import org.wildfly.galleon.plugin.featurespec.generator.FeatureSpecGenerator;

class FeatureSpecNode {
    static final int STANDALONE_MODEL = 1;
    static final int PROFILE_MODEL = 2;
    static final int DOMAIN_MODEL = 4;
    static final int HOST_MODEL = 8;
    private static final String DOMAIN_PREFIX = "domain.";
    private static final String HOST_PREFIX = "host.";
    private static final String PROFILE_PREFIX = "profile.";
    private static final String CORE_SERVICE_MANAGEMENT = "core-service.management";
    private static final String EXTENSION = "extension";
    private static final String SUBSYSTEM_PREFIX = "subsystem.";
    final FeatureSpecGenerator gen;
    String standaloneName;
    ModelNode standaloneDescr;
    private boolean generateStandalone;
    String profileName;
    ModelNode profileDescr;
    private boolean generateProfile;
    String domainName;
    ModelNode domainDescr;
    boolean generateDomain;
    String hostName;
    ModelNode hostDescr;
    private boolean generateHost;
    private int mergeCode;
    private int mergedModel;
    private ModelNode mergedDescr;
    private boolean generateMerged;
    private String mergedName;
    private Map<String, FeatureSpecNode> children = Collections.emptyMap();
    private Set<String> extendedIdParams = Collections.emptySet();

    private static boolean identicalInAllModels(String specName) {
        return specName.startsWith(SUBSYSTEM_PREFIX) || specName.startsWith(CORE_SERVICE_MANAGEMENT) && (specName.length() == CORE_SERVICE_MANAGEMENT.length() || specName.regionMatches(CORE_SERVICE_MANAGEMENT.length(), ".access", 0, ".access".length()) || specName.regionMatches(CORE_SERVICE_MANAGEMENT.length(), ".security-realm", 0, ".security-realm".length()) || specName.regionMatches(CORE_SERVICE_MANAGEMENT.length(), ".ldap-connection", 0, ".ldap-connection".length())) || specName.equals(EXTENSION);
    }

    private static boolean sameRequiredCapabilities(ModelNode standaloneDescr, ModelNode domainDescr, String optionalPrefix, boolean failIfDifferent) throws ProvisioningException {
        List capsDescr;
        Map<String, Boolean> standaloneCaps = Collections.emptyMap();
        if (standaloneDescr.hasDefined("requires")) {
            capsDescr = standaloneDescr.get("requires").asList();
            standaloneCaps = new HashMap(capsDescr.size());
            for (Object capability : capsDescr) {
                standaloneCaps.put(capability.get("name").asString(), capability.hasDefined("optional") && capability.get("optional").asBoolean());
            }
        }
        List list = capsDescr = domainDescr.hasDefined("requires") ? domainDescr.get("requires").asList() : Collections.emptyList();
        if (capsDescr.size() != standaloneCaps.size()) {
            if (failIfDifferent) {
                ArrayList<String> domainCaps = new ArrayList<String>(capsDescr.size());
                for (ModelNode capability : capsDescr) {
                    domainCaps.add(capability.get("name").asString());
                }
                throw new ProvisioningException("Required capabilities in standalone model " + standaloneCaps.keySet() + " do not match required capabilities in the domain model " + domainCaps);
            }
            return false;
        }
        for (Object capability : capsDescr) {
            boolean domainOptional;
            String domainName = capability.get("name").asString();
            if (optionalPrefix != null && domainName.charAt(0) == '$' && domainName.startsWith(optionalPrefix, 1)) {
                domainName = domainName.substring(optionalPrefix.length() + 1);
            }
            Boolean standaloneOptional = (Boolean)standaloneCaps.get(domainName);
            boolean bl = domainOptional = capability.hasDefined("optional") && capability.get("optional").asBoolean();
            if (domainOptional) {
                if (standaloneOptional != null && standaloneOptional.booleanValue()) continue;
                if (failIfDifferent) {
                    throw new ProvisioningException("Required capability " + capability.get("name").asString() + " is optional in the domain model spec unlike " + domainName + " in the standalone one");
                }
                return false;
            }
            if (standaloneOptional == null || !standaloneOptional.booleanValue()) continue;
            throw new ProvisioningException("Required capability " + domainName + " is optional in the standalone model spec unlike " + capability.get("name").asString() + " in the domain one");
        }
        return true;
    }

    private static boolean sameProvidedCapabilities(ModelNode standaloneDescr, ModelNode domainDescr, String optionalPrefix, boolean failIfDifferent) throws ProvisioningException {
        List capsDescr;
        Set standaloneCaps = Collections.emptySet();
        if (standaloneDescr.hasDefined("provides")) {
            capsDescr = standaloneDescr.get("provides").asList();
            standaloneCaps = new HashSet(capsDescr.size());
            for (ModelNode capability : capsDescr) {
                standaloneCaps.add(capability.asString());
            }
        }
        List list = capsDescr = domainDescr.hasDefined("provides") ? domainDescr.get("provides").asList() : Collections.emptyList();
        if (capsDescr.size() != standaloneCaps.size()) {
            if (failIfDifferent) {
                throw new ProvisioningException("Provided capabilities don't match");
            }
            return false;
        }
        for (ModelNode capability : capsDescr) {
            String domainName = capability.asString();
            if (optionalPrefix != null && domainName.charAt(0) == '$' && domainName.startsWith(optionalPrefix, 1)) {
                domainName = domainName.substring(optionalPrefix.length() + 1);
            }
            if (standaloneCaps.contains(domainName)) continue;
            if (failIfDifferent) {
                throw new ProvisioningException("Domain model spec provides capability " + capability.asString() + " with no equivalent in the standalone one");
            }
            return false;
        }
        return true;
    }

    private static boolean samePackages(ModelNode standaloneDescr, ModelNode domainDescr, boolean failIfDifferent) throws ProvisioningException {
        List packagesDescr;
        Set standalonePackages = Collections.emptySet();
        if (standaloneDescr.hasDefined("packages")) {
            packagesDescr = standaloneDescr.get("packages").asList();
            standalonePackages = new HashSet(packagesDescr.size());
            for (ModelNode packageDep : packagesDescr) {
                standalonePackages.add(packageDep.require("package").asString());
            }
        }
        List list = packagesDescr = domainDescr.hasDefined("packages") ? domainDescr.get("packages").asList() : Collections.emptyList();
        if (packagesDescr.size() != standalonePackages.size()) {
            if (failIfDifferent) {
                throw new ProvisioningException("Packages dependencies don't match");
            }
            return false;
        }
        for (ModelNode packageDep : packagesDescr) {
            if (standalonePackages.contains(packageDep.require("package").asString())) continue;
            if (failIfDifferent) {
                throw new ProvisioningException("Domain model feature requires package " + packageDep.require("package").asString() + " unlike the standalone one");
            }
            return false;
        }
        return true;
    }

    private static boolean sameAnnotations(ModelNode standaloneDescr, ModelNode domainDescr, String domainNode, boolean failIfDifferent) throws ProvisioningException {
        String standaloneOpParams;
        ModelNode domainAnnot;
        ModelNode standaloneAnnot = standaloneDescr.hasDefined("annotation") ? standaloneDescr.require("annotation") : null;
        ModelNode modelNode = domainAnnot = domainDescr.hasDefined("annotation") ? domainDescr.require("annotation") : null;
        if (standaloneAnnot == null) {
            if (domainAnnot == null) {
                return true;
            }
            if (failIfDifferent) {
                throw new ProvisioningException("Standalone model feature does not include annotation unlike the corresponding domain model one");
            }
            return false;
        }
        if (domainAnnot == null) {
            if (failIfDifferent) {
                throw new ProvisioningException("Domain model feature does not include annotation unlike the corresponding standalone model one");
            }
            return false;
        }
        if (!standaloneAnnot.require("name").asString().equals(domainAnnot.require("name").asString())) {
            if (failIfDifferent) {
                throw new ProvisioningException("Standalone model annotation is " + standaloneAnnot.get("name").asString() + " while the domain model one is " + domainAnnot.get("name").asString());
            }
            return false;
        }
        Set standaloneElems = standaloneAnnot.keys();
        Set domainElems = domainAnnot.keys();
        String domainOpParamsMapping = null;
        switch (domainElems.size() - standaloneElems.size()) {
            case 0: {
                break;
            }
            case 1: {
                if (domainAnnot.has("op-params-mapping") && !standaloneAnnot.has("op-params-mapping")) {
                    domainOpParamsMapping = domainAnnot.get("op-params-mapping").asString();
                    break;
                }
            }
            default: {
                if (!failIfDifferent) break;
                throw new ProvisioningException("Annotation elements in the standalone model spec " + standaloneAnnot.keys() + " don't match the corresponding annotation elements in the domain spec " + domainAnnot.keys());
            }
        }
        if (!domainAnnot.get("name").asString().equals(standaloneAnnot.get("name").asString())) {
            throw new ProvisioningException("Annotation element 'name' in set to " + domainAnnot.get("name").asString() + " in the domain model and to " + standaloneAnnot.get("name").asString() + " in standalone");
        }
        String domainAddrParams = domainAnnot.get("addr-params").asString();
        if (domainAddrParams.startsWith(domainNode)) {
            domainAddrParams = domainAddrParams.substring(domainNode.length() + 1);
        }
        if (!domainAddrParams.equals(standaloneAnnot.get("addr-params").asString())) {
            throw new ProvisioningException("Annotation element 'addr-params' in set to " + domainAddrParams + " in the domain model and to " + standaloneAnnot.get("addr-params").asString() + " in standalone");
        }
        String domainOpParams = domainAnnot.get("op-params").asString();
        if (domainOpParams.startsWith(domainNode)) {
            domainOpParams = domainOpParams.substring(domainNode.length() + 1);
        }
        if (!domainOpParams.equals(standaloneOpParams = standaloneAnnot.get("op-params").asString())) {
            if (domainOpParamsMapping != null) {
                if (!domainOpParamsMapping.equals(standaloneOpParams)) {
                    throw new ProvisioningException("Annotation element 'op-params' is set to " + domainOpParamsMapping + " in the domain model and to " + standaloneOpParams + " in standalone");
                }
            } else {
                throw new ProvisioningException("Annotation element 'name' is set to " + domainOpParams + " in the domain model and to " + standaloneOpParams + " in standalone");
            }
        }
        int checkedStandaloneElems = 3;
        if (standaloneAnnot.has("op-params-mapping") && domainOpParamsMapping == null) {
            ++checkedStandaloneElems;
            String standaloneOpParamsMapping = standaloneAnnot.get("op-params-mapping").asString();
            domainOpParamsMapping = domainAnnot.get("op-params-mapping").asString();
            if (!domainOpParamsMapping.equals(standaloneOpParamsMapping)) {
                throw new ProvisioningException("Annotation element 'op-params-mapping' in set to " + domainOpParamsMapping + " in the domain model and to " + standaloneOpParamsMapping + " in standalone");
            }
        }
        if (standaloneAnnot.has("complex-attribute")) {
            if (!domainAnnot.has("complex-attribute")) {
                if (failIfDifferent) {
                    throw new ProvisioningException("Domain annotation is missing complex-attribute element");
                }
                return false;
            }
            if (!domainAnnot.get("complex-attribute").equals(standaloneAnnot.get("complex-attribute"))) {
                if (failIfDifferent) {
                    throw new ProvisioningException("Annotation element 'complex-attribute' is set to " + standaloneAnnot.get("complex-attribute").asString() + " in the standalone feature spec and to " + domainAnnot.get("complex-attribute").asString() + " in the domain one");
                }
                return false;
            }
            ++checkedStandaloneElems;
        }
        if (standaloneElems.size() > checkedStandaloneElems) {
            throw new ProvisioningException("Expected " + checkedStandaloneElems + " annotation elements in the standalone model but got " + standaloneElems);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean sameFeatureRefs(ModelNode standaloneDescr, ModelNode domainDescr, String optionalPrefix, boolean failIfDifferent) throws ProvisioningException {
        List standaloneRefs = standaloneDescr.hasDefined("refs") ? standaloneDescr.get("refs").asList() : Collections.emptyList();
        List domainRefs = domainDescr.hasDefined("refs") ? domainDescr.get("refs").asList() : Collections.emptyList();
        HashSet<String> standaloneRefNames = new HashSet<String>(standaloneRefs.size());
        for (ModelNode ref : standaloneRefs) {
            standaloneRefNames.add(ref.get("feature").asString());
        }
        int skippedDomainRoot = 0;
        for (ModelNode ref : domainRefs) {
            String domainRefName;
            block10: {
                domainRefName = ref.get("feature").asString();
                if (optionalPrefix != null) {
                    if (domainRefName.regionMatches(0, optionalPrefix, 0, optionalPrefix.length() - 1)) {
                        if (domainRefName.startsWith(optionalPrefix)) {
                            domainRefName = domainRefName.substring(optionalPrefix.length());
                            break block10;
                        } else {
                            skippedDomainRoot = 1;
                            continue;
                        }
                    }
                    if (optionalPrefix.equals(PROFILE_PREFIX) && domainRefName.startsWith(DOMAIN_PREFIX)) {
                        domainRefName = domainRefName.substring(DOMAIN_PREFIX.length());
                    }
                }
            }
            if (standaloneRefNames.contains(domainRefName)) continue;
            if (failIfDifferent) {
                throw new ProvisioningException("Domain model spec includes reference " + ref.get("feature").asString() + " while the standalone one does not");
            }
            return false;
        }
        if (standaloneRefs.size() == domainRefs.size() - skippedDomainRoot) {
            return true;
        }
        if (failIfDifferent) {
            throw new ProvisioningException("The number of references is different in standalone and domain specs");
        }
        return false;
    }

    private static boolean areIdentical(ModelNode standaloneDescr, ModelNode domainDescr, String optionalPrefix, boolean failIfDifferent) throws ProvisioningException {
        return FeatureSpecNode.sameRequiredCapabilities(standaloneDescr, domainDescr, optionalPrefix, failIfDifferent) && FeatureSpecNode.sameProvidedCapabilities(standaloneDescr, domainDescr, optionalPrefix, failIfDifferent) && FeatureSpecNode.samePackages(standaloneDescr, domainDescr, failIfDifferent) && FeatureSpecNode.sameAnnotations(standaloneDescr, domainDescr, optionalPrefix == null ? null : optionalPrefix.substring(0, optionalPrefix.length() - 1), failIfDifferent) && FeatureSpecNode.sameFeatureRefs(standaloneDescr, domainDescr, optionalPrefix, failIfDifferent);
    }

    private static void assertIdenticalSpecs(String spec1, ModelNode descr1, String spec2, ModelNode descr2, String optionalPrefix) throws ProvisioningException {
        try {
            FeatureSpecNode.areIdentical(descr1, descr2, optionalPrefix, true);
        }
        catch (ProvisioningException e) {
            throw new ProvisioningException("Feature spec " + spec1 + " does not match the corresponding feature spec " + spec2, (Throwable)e);
        }
    }

    private static FeatureAnnotation getAnnotation(ModelNode descr) {
        if (!descr.hasDefined("annotation")) {
            return null;
        }
        ModelNode annotationNode = descr.require("annotation");
        FeatureAnnotation annotation = new FeatureAnnotation("jboss-op");
        for (Property property : annotationNode.asPropertyList()) {
            annotation.setElement(property.getName(), property.getValue().asString());
        }
        return annotation;
    }

    private static String convertToCli(String value) {
        if (!(value == null || value.isEmpty() || value.indexOf(44) < 0 || value.startsWith("\"") && value.endsWith("\"") || value.startsWith("[") && value.endsWith("]"))) {
            return '\"' + value + '\"';
        }
        return value;
    }

    private void persistSpec(String name, ModelNode descr, int model) throws ProvisioningException {
        FeatureSpec spec;
        Path specDir;
        String branchId;
        FeatureSpec.Builder builder = FeatureSpec.builder((String)name);
        FeatureAnnotation annotation = FeatureSpecNode.getAnnotation(descr);
        if (annotation != null) {
            builder.addAnnotation(annotation);
        }
        if ((branchId = this.gen.getBranchId(name, 1)) != null) {
            builder.addAnnotation(FeatureAnnotation.featureBranch((String)branchId));
        }
        if (descr.hasDefined("requires")) {
            for (Object capability : descr.require("requires").asList()) {
                builder.requiresCapability(capability.get("name").asString(), capability.hasDefined("optional") && capability.get("optional").asBoolean());
            }
        }
        if (descr.hasDefined("provides")) {
            for (Object capability : descr.require("provides").asList()) {
                builder.providesCapability(capability.asString());
            }
        }
        List paramsDescr = descr.require("params").asList();
        if (descr.hasDefined("refs")) {
            for (ModelNode ref : descr.get("refs").asList()) {
                FeatureSpec inheritedSpec;
                boolean isInclude = ref.hasDefined("include") && ref.get("include").asBoolean();
                String featureRefName = ref.get("feature").asString();
                FeatureReferenceSpec.Builder refBuilder = FeatureReferenceSpec.builder((String)featureRefName).setInclude(isInclude);
                boolean paramMapping = ref.hasDefined("mappings");
                FeatureSpecNode targetSpec = this.gen.getSpec(featureRefName);
                FeatureSpec featureSpec = inheritedSpec = targetSpec.isGenerate(model) ? null : this.gen.getInheritedSpec(featureRefName);
                if (inheritedSpec != null) {
                    for (FeatureParameterSpec refParam : inheritedSpec.getIdParams()) {
                        boolean present = false;
                        for (ModelNode param : paramsDescr) {
                            if (!param.get("name").asString().equals(refParam.getName())) continue;
                            present = true;
                            break;
                        }
                        if (present) continue;
                        this.gen.debug("Adding ID parameter %s to %s to satisfy reference %s parameter mapping ", refParam.getName(), name, featureRefName);
                        if (refParam.hasDefaultValue()) {
                            builder.addParam(refParam);
                        } else {
                            builder.addParam(FeatureParameterSpec.create((String)refParam.getName(), (boolean)true, (boolean)false, (String)"GLN_UNDEFINED"));
                        }
                        if (!paramMapping) continue;
                        refBuilder.mapParam(refParam.getName(), refParam.getName());
                    }
                }
                if (paramMapping) {
                    for (Property mapping : ref.require("mappings").asPropertyList()) {
                        refBuilder.mapParam(mapping.getName(), mapping.getValue().asString());
                    }
                }
                if (ref.hasDefined("nillable") && ref.get("nillable").asBoolean()) {
                    refBuilder.setNillable(true);
                }
                builder.addFeatureRef(refBuilder.build());
            }
        }
        if (descr.hasDefined("params")) {
            for (ModelNode param : paramsDescr) {
                FeatureParameterSpec.Builder featureParamSpecBuilder = FeatureParameterSpec.builder((String)param.get("name").asString());
                if (param.hasDefined("feature-id") && param.get("feature-id").asBoolean()) {
                    featureParamSpecBuilder.setFeatureId();
                }
                if (param.hasDefined("nillable") && param.get("nillable").asBoolean()) {
                    featureParamSpecBuilder.setNillable();
                }
                featureParamSpecBuilder.setDefaultValue(param.hasDefined("default") ? FeatureSpecNode.convertToCli(param.get("default").asString()) : null);
                if (param.hasDefined("type")) {
                    featureParamSpecBuilder.setType(param.get("type").asString());
                }
                builder.addParam(featureParamSpecBuilder.build());
            }
        }
        if (descr.hasDefined("packages")) {
            for (ModelNode packageDep : descr.get("packages").asList()) {
                if (!packageDep.hasDefined("package")) continue;
                builder.addPackageDep(packageDep.require("package").asString());
            }
        }
        if (Files.notExists(specDir = this.gen.outputDir.resolve((spec = builder.build()).getName()), new LinkOption[0])) {
            try {
                Files.createDirectories(specDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new ProvisioningException(Errors.mkdirs((Path)specDir), (Throwable)e);
            }
        }
        try {
            FeatureSpecXmlWriter.getInstance().write((Object)spec, specDir.resolve("spec.xml"));
        }
        catch (IOException | XMLStreamException e) {
            throw new ProvisioningException(Errors.writeFile((Path)specDir.resolve("spec.xml")), (Throwable)e);
        }
        this.gen.increaseSpecCount();
    }

    private void ensureIdParams(String specName, ModelNode descr, Map<String, ModelNode> descrParams, Set<String> extendedIdParams, boolean addAsIds) throws ProvisioningException {
        ModelNode params = descr.get("params");
        ModelNode annotation = null;
        ModelNode addrParams = null;
        if (descr.hasDefined("annotation")) {
            annotation = descr.get("annotation");
            addrParams = annotation.hasDefined("addr-params") ? annotation.get("addr-params") : null;
        }
        String newAddrParams = null;
        for (String param : extendedIdParams) {
            ModelNode paramDescr = descrParams.get(param);
            if (paramDescr != null) {
                ModelNode opParams;
                if (paramDescr.hasDefined("feature-id") && paramDescr.get("feature-id").asBoolean()) continue;
                paramDescr.get("name").set(param + "-feature");
                this.gen.debug("re-named param %s to %s-feature in spec %s", param, param, specName);
                if (addrParams == null) {
                    throw new ProvisioningException("The annotation has not been generated for " + descr);
                }
                ModelNode modelNode = opParams = annotation.hasDefined("op-params") ? annotation.get("op-params") : null;
                if (opParams != null) {
                    StringBuilder newOpParams = new StringBuilder();
                    StringTokenizer opParamsTokens = new StringTokenizer(opParams.asString(), ",");
                    String mappedParam = opParamsTokens.nextToken();
                    newOpParams.append(mappedParam);
                    if (mappedParam.equals(param)) {
                        newOpParams.append("-feature");
                    }
                    while (opParamsTokens.hasMoreTokens()) {
                        mappedParam = opParamsTokens.nextToken();
                        newOpParams.append(',');
                        newOpParams.append(mappedParam);
                        if (!mappedParam.equals(param)) continue;
                        newOpParams.append("-feature");
                    }
                    opParams.set(newOpParams.toString());
                }
            }
            ModelNode idParam = new ModelNode();
            idParam.get("name").set(param);
            if (addAsIds) {
                idParam.get("feature-id").set(true);
            }
            idParam.get("default").set("GLN_UNDEFINED");
            params.add(idParam);
            if (addrParams == null) continue;
            if (newAddrParams == null) {
                newAddrParams = param + ',' + addrParams.asString();
                continue;
            }
            newAddrParams = param + ',' + newAddrParams;
        }
        if (newAddrParams != null) {
            addrParams.set(newAddrParams);
        }
    }

    private void ensureCapPrefix(ModelNode descr, String prefix, int mergeCode) throws ProvisioningException {
        if (descr.hasDefined("requires")) {
            for (ModelNode capability : descr.require("requires").asList()) {
                String name = capability.get("name").asString();
                FeatureSpecNode capProvider = this.gen.getCapProvider(FeatureSpecNode.getCapId(name));
                if (capProvider == null) {
                    this.gen.warn("NO PROVIDER found for capability " + name);
                } else if ((capProvider.mergeCode & mergeCode) != mergeCode) continue;
                if (name.startsWith(prefix)) continue;
                capability.get("name").set(prefix + name);
            }
        }
        if (descr.hasDefined("provides")) {
            List caps = descr.require("provides").asList();
            for (int i = 0; i < caps.size(); ++i) {
                ModelNode capNode = (ModelNode)caps.get(i);
                if (capNode.asString().startsWith(prefix)) continue;
                capNode.set(prefix + capNode.asString());
            }
        }
    }

    private static String getCapId(String capName) {
        int i = capName.indexOf(36);
        if (i >= 0) {
            StringBuilder buf = new StringBuilder();
            int prevI = 0;
            while (i >= 0) {
                if (i >= prevI) {
                    buf.append(capName.substring(prevI, i + 1));
                    prevI = -1;
                }
                if ((i = capName.indexOf(46, i + 1)) <= 0) continue;
                prevI = i;
                i = capName.indexOf(36, prevI + 1);
            }
            if (prevI > 0 && prevI <= capName.length()) {
                buf.append(capName.substring(prevI));
            }
            capName = buf.toString();
        }
        return capName;
    }

    private void updateReferencingSpecs(String fromReferencedSpec, String toReferencedSpec) throws ProvisioningException {
        Map<String, FeatureSpecNode> referencingSpecs = this.gen.getReferencingSpecs(fromReferencedSpec);
        if (referencingSpecs.isEmpty()) {
            return;
        }
        this.gen.clearReferencingSpecs(fromReferencedSpec);
        for (Map.Entry<String, FeatureSpecNode> next : referencingSpecs.entrySet()) {
            Set<Object> extendedIdParams;
            ModelNode referencingDescr;
            String referencingSpecName = next.getKey();
            FeatureSpecNode referencingSpec = next.getValue();
            int referencingModel = referencingSpec.getModel(referencingSpecName);
            if ((referencingSpec.mergeCode & referencingModel) > 0) {
                referencingDescr = referencingSpec.mergedDescr;
                if (this.gen.isInherited(referencingSpec.mergedName)) continue;
                extendedIdParams = Collections.emptySet();
                for (String candidateParam : this.extendedIdParams) {
                    if (referencingSpec.extendedIdParams.contains(candidateParam)) continue;
                    extendedIdParams = CollectionUtils.add(extendedIdParams, (Object)candidateParam);
                }
            } else {
                if (this.gen.isInherited(referencingSpecName)) continue;
                referencingDescr = referencingSpec.getDescr(referencingModel);
                extendedIdParams = this.extendedIdParams;
                if (!fromReferencedSpec.equals(toReferencedSpec)) {
                    for (ModelNode ref : referencingDescr.get("refs").asList()) {
                        ModelNode featureNode = ref.get("feature");
                        if (!featureNode.asString().equals(fromReferencedSpec)) continue;
                        featureNode.set(toReferencedSpec);
                    }
                }
            }
            if (extendedIdParams.isEmpty()) continue;
            this.ensureParams(referencingSpecName, referencingDescr, toReferencedSpec, extendedIdParams);
        }
    }

    private void ensureRef(ModelNode descr, String featureSpec) throws ProvisioningException {
        ModelNode refsNode = descr.get("refs");
        if (refsNode.isDefined()) {
            for (ModelNode refNode : refsNode.asList()) {
                if (!refNode.get("feature").asString().equals(featureSpec)) continue;
                return;
            }
        }
        ModelNode refNode = new ModelNode();
        refNode.get("feature").set(featureSpec);
        refNode.get("nillable").set(true);
        refsNode.add(refNode);
    }

    private void ensureParams(String specName, ModelNode descr, String referencedSpecName, Set<String> expectedParams) {
        Set ownParams;
        ModelNode params = descr.require("params");
        List paramsList = params.asList();
        if (paramsList.isEmpty()) {
            ownParams = Collections.emptySet();
        } else {
            ownParams = new HashSet(paramsList.size());
            for (String param : paramsList) {
                ownParams.add(param.get("name").asString());
            }
        }
        for (String param : expectedParams) {
            if (ownParams.contains(param)) continue;
            ModelNode paramSpec = new ModelNode();
            paramSpec.get("name").set(param);
            paramSpec.get("default").set("GLN_UNDEFINED");
            params.add(paramSpec);
            this.gen.debug("WARN: added extra parameter %s to feature spec %s as a consequnce of merging feature spec %s from multiple models", param, specName, referencedSpecName);
        }
    }

    FeatureSpecNode(FeatureSpecGenerator gen, int type, String name, ModelNode descr) throws ProvisioningException {
        this.gen = gen;
        switch (type) {
            case 1: {
                this.standaloneName = name;
                this.standaloneDescr = descr;
                this.generateStandalone = !gen.isInherited(name);
                gen.addSpec(name, this);
                break;
            }
            case 2: {
                this.setProfileDescr(name, descr);
                break;
            }
            case 4: {
                this.setDomainDescr(name, descr);
                break;
            }
            case 8: {
                this.setHostDescr(name, descr);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected node type " + type);
            }
        }
        gen.addSpec(name, this);
    }

    String getName(int model) {
        switch (model) {
            case 1: {
                return this.standaloneName;
            }
            case 2: {
                return this.profileName;
            }
            case 4: {
                return this.domainName;
            }
            case 8: {
                return this.hostName;
            }
        }
        throw new IllegalStateException("Unexpected node type " + model);
    }

    ModelNode getDescr(int model) {
        switch (model) {
            case 1: {
                return this.standaloneDescr;
            }
            case 2: {
                return this.profileDescr;
            }
            case 4: {
                return this.domainDescr;
            }
            case 8: {
                return this.hostDescr;
            }
        }
        throw new IllegalStateException("Unexpected node type " + model);
    }

    boolean isGenerate(int model) {
        switch (model) {
            case 1: {
                return this.generateStandalone;
            }
            case 2: {
                return this.generateProfile;
            }
            case 4: {
                return this.generateDomain;
            }
            case 8: {
                return this.generateHost;
            }
        }
        throw new IllegalStateException("Unexpected node type " + model);
    }

    int getModel(String name) {
        if (name.equals(this.standaloneName)) {
            return 1;
        }
        if (name.equals(this.profileName)) {
            return 2;
        }
        if (name.equals(this.domainName)) {
            return 4;
        }
        if (name.equals(this.hostName)) {
            return 8;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("Couldn't match '").append(name).append("' to the expected spec names ");
        if (this.standaloneName != null) {
            buf.append(this.standaloneName);
        }
        if (this.profileName != null) {
            buf.append(this.profileName);
        }
        if (this.domainName != null) {
            buf.append(this.domainName);
        }
        if (this.hostName != null) {
            buf.append(this.hostName);
        }
        throw new IllegalArgumentException(buf.toString());
    }

    void setProfileDescr(String name, ModelNode descr) throws ProvisioningException {
        this.profileName = name;
        this.profileDescr = descr;
        this.gen.addSpec(name, this);
        boolean bl = this.generateProfile = !this.gen.isInherited(name);
        if (this.standaloneName != null && FeatureSpecNode.identicalInAllModels(this.standaloneName)) {
            try {
                FeatureSpecNode.assertIdenticalSpecs(this.standaloneName, this.standaloneDescr, this.profileName, this.profileDescr, PROFILE_PREFIX);
            }
            catch (ProvisioningException e) {
                if ("Feature spec subsystem.remoting does not match the corresponding feature spec profile.subsystem.remoting".equals(e.getMessage())) {
                    this.gen.warn(e.getLocalizedMessage() + ": " + e.getCause().getLocalizedMessage());
                }
                throw e;
            }
            this.extendedIdParams = Collections.singleton("profile");
            this.mergeCode |= 3;
            this.mergedModel = 1;
            this.generateMerged = this.generateStandalone;
            this.mergedDescr = this.standaloneDescr;
            this.mergedName = this.standaloneName;
        }
    }

    void setDomainDescr(String name, ModelNode descr) throws ProvisioningException {
        this.domainName = name;
        this.domainDescr = descr;
        this.gen.addSpec(name, this);
        boolean bl = this.generateDomain = !this.gen.isInherited(name);
        if (this.standaloneName != null && FeatureSpecNode.identicalInAllModels(this.standaloneName)) {
            FeatureSpecNode.assertIdenticalSpecs(this.standaloneName, this.standaloneDescr, this.domainName, this.domainDescr, DOMAIN_PREFIX);
            this.mergeCode |= 5;
            this.mergedModel = 1;
            this.generateMerged = this.generateStandalone;
            this.mergedDescr = this.standaloneDescr;
            this.mergedName = this.standaloneName;
        }
    }

    void setHostDescr(String name, ModelNode descr) throws ProvisioningException {
        this.hostName = name;
        this.hostDescr = descr;
        this.gen.addSpec(name, this);
        boolean bl = this.generateHost = !this.gen.isInherited(name);
        if (this.standaloneName != null && FeatureSpecNode.identicalInAllModels(this.standaloneName)) {
            FeatureSpecNode.assertIdenticalSpecs(this.standaloneName, this.standaloneDescr, this.hostName, this.hostDescr, HOST_PREFIX);
            this.extendedIdParams = CollectionUtils.add(this.extendedIdParams, (Object)"host");
            this.mergeCode |= 9;
            this.mergedModel = 1;
            this.generateMerged = this.generateStandalone;
            this.mergedDescr = this.standaloneDescr;
            this.mergedName = this.standaloneName;
        }
    }

    void processChildren(int type) throws ProvisioningException {
        ModelNode descr;
        switch (type) {
            case 1: {
                descr = this.standaloneDescr;
                break;
            }
            case 4: {
                descr = this.domainDescr;
                break;
            }
            case 2: {
                descr = this.profileDescr;
                break;
            }
            case 8: {
                descr = this.hostDescr;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected node type " + type);
            }
        }
        if (!descr.hasDefined("children")) {
            return;
        }
        for (Property childFeature : descr.get("children").asPropertyList()) {
            this.processChild(type, childFeature);
        }
    }

    void processChild(int type, Property child) throws ProvisioningException {
        FeatureSpecNode childNode = null;
        String childName = child.getName();
        ModelNode descr = child.getValue();
        switch (type) {
            case 1: {
                break;
            }
            case 2: {
                if (!childName.startsWith(PROFILE_PREFIX) || (childNode = this.children.get(childName.substring(PROFILE_PREFIX.length()))) == null) break;
                childNode.setProfileDescr(childName, descr);
                break;
            }
            case 4: {
                if (!childName.startsWith(DOMAIN_PREFIX) || (childNode = this.children.get(childName.substring(DOMAIN_PREFIX.length()))) == null) break;
                childNode.setDomainDescr(childName, descr);
                break;
            }
            case 8: {
                childNode = this.children.get(childName.substring(HOST_PREFIX.length()));
                if (childNode == null) break;
                childNode.setHostDescr(childName, descr);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected node type " + type);
            }
        }
        if (childNode == null) {
            childNode = new FeatureSpecNode(this.gen, type, childName, descr);
            this.children = CollectionUtils.put(this.children, (Object)childName, (Object)childNode);
        }
        this.gen.addSpec(childName, childNode);
        if (descr.hasDefined("refs")) {
            for (ModelNode ref : descr.get("refs").asList()) {
                String featureRefName = ref.get("feature").asString();
                this.gen.addReferencedSpec(featureRefName, childName, childNode);
            }
        }
        if (descr.hasDefined("provides")) {
            for (ModelNode capability : descr.require("provides").asList()) {
                this.gen.addCapProvider(FeatureSpecNode.getCapId(capability.asString()), childNode);
            }
        }
        childNode.processChildren(type);
    }

    void buildSpecs() throws ProvisioningException {
        this.mergeSpecs();
        this.buildSpec(0);
        this.buildChildSpecs(1);
    }

    private void mergeSpecs() throws ProvisioningException {
        this.mergeSpecs(0);
        this.mergeChildSpecs(1);
    }

    private void mergeSpecs(int level) throws ProvisioningException {
        if (this.mergeCode == 0) {
            return;
        }
        if ((this.mergeCode & 1) > 0) {
            this.updateReferencingSpecs(this.standaloneName, this.mergedName);
        }
        if ((this.mergeCode & 2) > 0) {
            if (this.mergedModel != 2) {
                if (this.generateMerged) {
                    this.ensureCapPrefix(this.mergedDescr, "$profile.", 3);
                    this.ensureRef(this.mergedDescr, "profile");
                }
                this.updateReferencingSpecs(this.profileName, this.mergedName);
                this.profileDescr = null;
            }
        } else if ((this.mergeCode & 4) > 0 && this.mergedModel != 4) {
            this.updateReferencingSpecs(this.domainName, this.mergedName);
            this.domainDescr = null;
        }
        if ((this.mergeCode & 8) > 0) {
            if (this.mergedModel == 8) {
                throw new IllegalStateException("The target spec is wrong");
            }
            if (this.generateMerged) {
                this.ensureRef(this.mergedDescr, "host");
            }
            this.updateReferencingSpecs(this.hostName, this.mergedName);
            this.hostDescr = null;
        }
        if (this.generateMerged) {
            boolean hasIdParams = false;
            Map<String, ModelNode> mergedParams = Collections.emptyMap();
            if (this.mergedDescr.hasDefined("params")) {
                mergedParams = new HashMap();
                for (ModelNode param : this.mergedDescr.get("params").asList()) {
                    mergedParams.put(param.get("name").asString(), param);
                    if (hasIdParams || !param.has("feature-id") || !param.get("feature-id").asBoolean()) continue;
                    hasIdParams = true;
                }
            }
            this.ensureIdParams(this.mergedName, this.mergedDescr, mergedParams, this.extendedIdParams, hasIdParams);
        }
    }

    private void mergeChildSpecs(int level) throws ProvisioningException {
        if (this.children.isEmpty()) {
            return;
        }
        for (FeatureSpecNode child : this.children.values()) {
            child.mergeSpecs(level);
            child.mergeChildSpecs(level + 1);
        }
    }

    private void buildChildSpecs(int level) throws ProvisioningException {
        if (this.children.isEmpty()) {
            return;
        }
        for (FeatureSpecNode child : this.children.values()) {
            child.buildSpec(level);
            child.buildChildSpecs(level + 1);
        }
    }

    private void buildSpec(int level) throws ProvisioningException {
        if (this.standaloneDescr != null && this.generateStandalone) {
            this.persistSpec(this.standaloneName, this.standaloneDescr, 1);
        }
        if (this.profileDescr != null && this.generateProfile) {
            this.persistSpec(this.profileName, this.profileDescr, 2);
        }
        if (this.domainDescr != null && this.generateDomain) {
            this.persistSpec(this.domainName, this.domainDescr, 4);
        }
        if (this.hostDescr != null && this.generateHost) {
            this.persistSpec(this.hostName, this.hostDescr, 8);
        }
    }
}

