/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.maven;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.config.ConfigCustomizationsBuilder;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.galleon1.LegacyGalleon1Universe;
import org.jboss.galleon.util.ParsingUtils;
import org.jboss.galleon.xml.ConfigXml;
import org.jboss.galleon.xml.FeaturePackPackagesConfigParser10;
import org.jboss.galleon.xml.ProvisioningXmlParser10;
import org.jboss.galleon.xml.XmlNameProvider;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.galleon.maven.FeaturePackDependencySpec;
import org.wildfly.galleon.maven.WildFlyFeaturePackBuild;
import org.wildfly.galleon.maven.build.tasks.CopyResourcesTask;
import org.wildfly.galleon.plugin.ArtifactCoords;

class FeaturePackBuildModelParser30
implements XMLElementReader<WildFlyFeaturePackBuild.Builder> {
    public static final String NAMESPACE_3_0 = "urn:wildfly:feature-pack-build:3.0";

    FeaturePackBuildModelParser30() {
    }

    public void readElement(XMLExtendedStreamReader reader, WildFlyFeaturePackBuild.Builder builder) throws XMLStreamException {
        FeaturePackLocation fpl = null;
        int count = reader.getAttributeCount();
        block19: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case PRODUCER: {
                    fpl = FeaturePackLocation.fromString((String)reader.getAttributeValue(i));
                    continue block19;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (fpl == null) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), Collections.singleton(Attribute.PRODUCER));
        }
        builder.setProducer(fpl);
        block20: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case DEPENDENCIES: {
                            FeaturePackBuildModelParser30.parseDependencies(reader, builder);
                            continue block20;
                        }
                        case DEFAULT_PACKAGES: {
                            FeaturePackBuildModelParser30.parseDefaultPackages((XMLStreamReader)reader, builder);
                            continue block20;
                        }
                        case PACKAGE_SCHEMAS: {
                            FeaturePackBuildModelParser30.parsePackageSchemas((XMLStreamReader)reader, builder);
                            continue block20;
                        }
                        case CONFIG: {
                            ConfigModel.Builder config = ConfigModel.builder();
                            ConfigXml.readConfig((XMLExtendedStreamReader)reader, (ConfigModel.Builder)config);
                            try {
                                builder.addConfig(config.build());
                                continue block20;
                            }
                            catch (ProvisioningDescriptionException e) {
                                throw new XMLStreamException("Failed to create a config model instance", e);
                            }
                        }
                        case TRANSITIVE: {
                            FeaturePackBuildModelParser30.parseTransitive(reader, builder);
                            continue block20;
                        }
                        case PLUGINS: {
                            FeaturePackBuildModelParser30.parsePlugins(reader, builder);
                            continue block20;
                        }
                        case RESOURCES: {
                            FeaturePackBuildModelParser30.parseResources(reader, builder);
                            continue block20;
                        }
                        case GENERATE_FEATURE_SPECS: {
                            FeaturePackBuildModelParser30.parseGenerateFeatureSpecs(reader, builder);
                            continue block20;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private static void parseDefaultPackages(XMLStreamReader reader, WildFlyFeaturePackBuild.Builder builder) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case PACKAGE: {
                            builder.addDefaultPackage(FeaturePackBuildModelParser30.parseName(reader));
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private static void parseDependencies(XMLExtendedStreamReader reader, WildFlyFeaturePackBuild.Builder builder) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case DEPENDENCY: {
                            FeaturePackBuildModelParser30.parseDependency(reader, builder, false);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private static void parseDependency(XMLExtendedStreamReader reader, WildFlyFeaturePackBuild.Builder builder, boolean transitive) throws XMLStreamException {
        FeaturePackConfig.Builder depBuilder;
        String groupId = null;
        String artifactId = null;
        String version = null;
        int count = reader.getAttributeCount();
        EnumSet<Attribute> required = EnumSet.of(Attribute.GROUP_ID, Attribute.ARTIFACT_ID);
        block19: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case GROUP_ID: {
                    groupId = reader.getAttributeValue(i);
                    continue block19;
                }
                case ARTIFACT_ID: {
                    artifactId = reader.getAttributeValue(i);
                    continue block19;
                }
                case VERSION: {
                    version = reader.getAttributeValue(i);
                    continue block19;
                }
                default: {
                    throw ParsingUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), required);
        }
        FeaturePackLocation fpl = LegacyGalleon1Universe.toFpl(groupId, artifactId, version);
        String depName = null;
        FeaturePackConfig.Builder builder2 = depBuilder = transitive ? FeaturePackConfig.transitiveBuilder((FeaturePackLocation)fpl) : FeaturePackConfig.builder((FeaturePackLocation)fpl);
        block20: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    builder.addDependency(ArtifactCoords.newGav((String)groupId, (String)artifactId, (String)version), FeaturePackDependencySpec.create(depName, depBuilder.build()));
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case NAME: {
                            depName = reader.getElementText().trim();
                            continue block20;
                        }
                        case DEFAULT_CONFIGS: {
                            ProvisioningXmlParser10.parseDefaultConfigs((XMLExtendedStreamReader)reader, (ConfigCustomizationsBuilder)depBuilder);
                            continue block20;
                        }
                        case CONFIG: {
                            ConfigModel.Builder configBuilder = ConfigModel.builder();
                            ConfigXml.readConfig((XMLExtendedStreamReader)reader, (ConfigModel.Builder)configBuilder);
                            try {
                                depBuilder.addConfig(configBuilder.build());
                                continue block20;
                            }
                            catch (ProvisioningDescriptionException e) {
                                throw new XMLStreamException(e);
                            }
                        }
                        case PACKAGES: {
                            try {
                                FeaturePackPackagesConfigParser10.readPackages((XMLStreamReader)reader, (FeaturePackConfig.Builder)depBuilder);
                                continue block20;
                            }
                            catch (ProvisioningDescriptionException e) {
                                throw new XMLStreamException(e);
                            }
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
    }

    private static void parseTransitive(XMLExtendedStreamReader reader, WildFlyFeaturePackBuild.Builder builder) throws XMLStreamException {
        ParsingUtils.parseNoAttributes((XMLStreamReader)reader);
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case DEPENDENCY: {
                            FeaturePackBuildModelParser30.parseDependency(reader, builder, true);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private static String parseName(XMLStreamReader reader) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), required);
        }
        ParsingUtils.parseNoContent((XMLStreamReader)reader);
        return name;
    }

    private static void parsePackageSchemas(XMLStreamReader reader, WildFlyFeaturePackBuild.Builder builder) throws XMLStreamException {
        ParsingUtils.parseNoAttributes((XMLStreamReader)reader);
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case GROUP: {
                            builder.addSchemaGroup(FeaturePackBuildModelParser30.parseName(reader));
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private static void parsePlugins(XMLExtendedStreamReader reader, WildFlyFeaturePackBuild.Builder builder) throws XMLStreamException {
        ParsingUtils.parseNoAttributes((XMLStreamReader)reader);
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case PLUGIN: {
                            builder.addPlugin(FeaturePackBuildModelParser30.parsePlugin(reader));
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private static String parsePlugin(XMLExtendedStreamReader reader) throws XMLStreamException {
        String artifact = null;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case ARTIFACT: {
                    artifact = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        ParsingUtils.parseNoContent((XMLStreamReader)reader);
        if (artifact == null) {
            throw new XMLStreamException(ParsingUtils.missingAttributes((Location)reader.getLocation(), Collections.singleton(Attribute.ARTIFACT)));
        }
        return artifact;
    }

    private static void parseResources(XMLExtendedStreamReader reader, WildFlyFeaturePackBuild.Builder builder) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case COPY: {
                            builder.addResourcesTask(FeaturePackBuildModelParser30.parseCopy((XMLStreamReader)reader));
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private static CopyResourcesTask parseCopy(XMLStreamReader reader) throws XMLStreamException {
        CopyResourcesTask copy = new CopyResourcesTask();
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case ARTIFACT: {
                    copy.setArtifact(reader.getAttributeValue(i));
                    continue block4;
                }
                case TO: {
                    copy.setTo(reader.getAttributeValue(i));
                    continue block4;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        String error = copy.getValidationErrors();
        if (error != null) {
            throw new XMLStreamException(ParsingUtils.error((String)error, (Location)reader.getLocation()));
        }
        ParsingUtils.parseNoContent((XMLStreamReader)reader);
        return copy;
    }

    private static void parseGenerateFeatureSpecs(XMLExtendedStreamReader reader, WildFlyFeaturePackBuild.Builder builder) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case EXTENSIONS: {
                            FeaturePackBuildModelParser30.parseExtensions(reader, builder);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private static void parseExtensions(XMLExtendedStreamReader reader, WildFlyFeaturePackBuild.Builder builder) throws XMLStreamException {
        block9: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case STANDALONE: {
                            FeaturePackBuildModelParser30.parseExtensions(reader, builder, Element.STANDALONE);
                            continue block9;
                        }
                        case DOMAIN: {
                            FeaturePackBuildModelParser30.parseExtensions(reader, builder, Element.DOMAIN);
                            continue block9;
                        }
                        case HOST: {
                            FeaturePackBuildModelParser30.parseExtensions(reader, builder, Element.HOST);
                            continue block9;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private static void parseExtensions(XMLExtendedStreamReader reader, WildFlyFeaturePackBuild.Builder builder, Element e) throws XMLStreamException {
        ParsingUtils.parseNoAttributes((XMLStreamReader)reader);
        block12: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case EXTENSION: {
                            switch (e) {
                                case STANDALONE: {
                                    builder.addStandaloneExtension(reader.getElementText().trim());
                                    continue block12;
                                }
                                case DOMAIN: {
                                    builder.addDomainExtension(reader.getElementText().trim());
                                    continue block12;
                                }
                                case HOST: {
                                    builder.addHostExtension(reader.getElementText().trim());
                                    continue block12;
                                }
                            }
                            throw new XMLStreamException("Unexpected extension target " + (Object)((Object)e), reader.getLocation());
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    static enum Attribute implements XmlNameProvider
    {
        ARTIFACT("artifact"),
        ARTIFACT_ID("artifact-id"),
        GROUP_ID("group-id"),
        NAME("name"),
        PRODUCER("producer"),
        TO("to"),
        VERSION("version"),
        UNKNOWN(null);

        private static final Map<QName, Attribute> attributes;
        private final String name;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public String getNamespace() {
            return null;
        }

        static {
            HashMap<QName, Attribute> attributesMap = new HashMap<QName, Attribute>(7);
            attributesMap.put(new QName(ARTIFACT.getLocalName()), ARTIFACT);
            attributesMap.put(new QName(ARTIFACT_ID.getLocalName()), ARTIFACT_ID);
            attributesMap.put(new QName(GROUP_ID.getLocalName()), GROUP_ID);
            attributesMap.put(new QName(NAME.getLocalName()), NAME);
            attributesMap.put(new QName(PRODUCER.getLocalName()), PRODUCER);
            attributesMap.put(new QName(TO.getLocalName()), TO);
            attributesMap.put(new QName(VERSION.getLocalName()), VERSION);
            attributes = attributesMap;
        }
    }

    static enum Element {
        BUILD("build"),
        CONFIG("config"),
        COPY("copy"),
        DEFAULT_CONFIGS("default-configs"),
        DEFAULT_PACKAGES("default-packages"),
        DEPENDENCIES("dependencies"),
        DEPENDENCY("dependency"),
        DOMAIN("domain"),
        EXTENSION("extension"),
        EXTENSIONS("extensions"),
        GENERATE_FEATURE_SPECS("generate-feature-specs"),
        GROUP("group"),
        HOST("host"),
        NAME("name"),
        PACKAGE("package"),
        PACKAGES("packages"),
        PACKAGE_SCHEMAS("package-schemas"),
        PLUGIN("plugin"),
        PLUGINS("plugins"),
        PRODUCER("producer"),
        RESOURCES("resources"),
        STANDALONE("standalone"),
        TRANSITIVE("transitive"),
        UNKNOWN(null);

        private static final Map<QName, Element> elements;
        private final String name;

        static Element of(QName qName) {
            QName name = qName.getNamespaceURI().equals("") ? new QName(FeaturePackBuildModelParser30.NAMESPACE_3_0, qName.getLocalPart()) : qName;
            Element element = elements.get(name);
            return element == null ? UNKNOWN : element;
        }

        private Element(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        static {
            HashMap<QName, Element> elementsMap = new HashMap<QName, Element>(23);
            elementsMap.put(new QName(FeaturePackBuildModelParser30.NAMESPACE_3_0, BUILD.getLocalName()), BUILD);
            elementsMap.put(new QName(FeaturePackBuildModelParser30.NAMESPACE_3_0, CONFIG.getLocalName()), CONFIG);
            elementsMap.put(new QName(FeaturePackBuildModelParser30.NAMESPACE_3_0, COPY.getLocalName()), COPY);
            elementsMap.put(new QName(FeaturePackBuildModelParser30.NAMESPACE_3_0, DEFAULT_CONFIGS.getLocalName()), DEFAULT_CONFIGS);
            elementsMap.put(new QName(FeaturePackBuildModelParser30.NAMESPACE_3_0, DEFAULT_PACKAGES.getLocalName()), DEFAULT_PACKAGES);
            elementsMap.put(new QName(FeaturePackBuildModelParser30.NAMESPACE_3_0, DEPENDENCIES.getLocalName()), DEPENDENCIES);
            elementsMap.put(new QName(FeaturePackBuildModelParser30.NAMESPACE_3_0, DEPENDENCY.getLocalName()), DEPENDENCY);
            elementsMap.put(new QName(FeaturePackBuildModelParser30.NAMESPACE_3_0, DOMAIN.getLocalName()), DOMAIN);
            elementsMap.put(new QName(FeaturePackBuildModelParser30.NAMESPACE_3_0, EXTENSION.getLocalName()), EXTENSION);
            elementsMap.put(new QName(FeaturePackBuildModelParser30.NAMESPACE_3_0, EXTENSIONS.getLocalName()), EXTENSIONS);
            elementsMap.put(new QName(FeaturePackBuildModelParser30.NAMESPACE_3_0, GENERATE_FEATURE_SPECS.getLocalName()), GENERATE_FEATURE_SPECS);
            elementsMap.put(new QName(FeaturePackBuildModelParser30.NAMESPACE_3_0, GROUP.getLocalName()), GROUP);
            elementsMap.put(new QName(FeaturePackBuildModelParser30.NAMESPACE_3_0, HOST.getLocalName()), HOST);
            elementsMap.put(new QName(FeaturePackBuildModelParser30.NAMESPACE_3_0, NAME.getLocalName()), NAME);
            elementsMap.put(new QName(FeaturePackBuildModelParser30.NAMESPACE_3_0, PACKAGE.getLocalName()), PACKAGE);
            elementsMap.put(new QName(FeaturePackBuildModelParser30.NAMESPACE_3_0, PACKAGES.getLocalName()), PACKAGES);
            elementsMap.put(new QName(FeaturePackBuildModelParser30.NAMESPACE_3_0, PACKAGE_SCHEMAS.getLocalName()), PACKAGE_SCHEMAS);
            elementsMap.put(new QName(FeaturePackBuildModelParser30.NAMESPACE_3_0, PLUGIN.getLocalName()), PLUGIN);
            elementsMap.put(new QName(FeaturePackBuildModelParser30.NAMESPACE_3_0, PLUGINS.getLocalName()), PLUGINS);
            elementsMap.put(new QName(FeaturePackBuildModelParser30.NAMESPACE_3_0, PRODUCER.getLocalName()), PRODUCER);
            elementsMap.put(new QName(FeaturePackBuildModelParser30.NAMESPACE_3_0, RESOURCES.getLocalName()), RESOURCES);
            elementsMap.put(new QName(FeaturePackBuildModelParser30.NAMESPACE_3_0, STANDALONE.getLocalName()), STANDALONE);
            elementsMap.put(new QName(FeaturePackBuildModelParser30.NAMESPACE_3_0, TRANSITIVE.getLocalName()), TRANSITIVE);
            elements = elementsMap;
        }
    }
}

