/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.maven;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;

class MavenProjectArtifactVersions {
    private static final String TEST_JAR = "test-jar";
    private final Map<String, String> versions = new TreeMap<String, String>();

    static MavenProjectArtifactVersions getInstance(MavenProject project) {
        return new MavenProjectArtifactVersions(project);
    }

    private MavenProjectArtifactVersions(MavenProject project) {
        for (Artifact artifact : project.getArtifacts()) {
            if (TEST_JAR.equals(artifact.getType())) continue;
            this.put(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getVersion(), artifact.getType());
        }
        if (project.getDependencyManagement() != null) {
            for (Dependency dependency : project.getDependencyManagement().getDependencies()) {
                String gac;
                if (TEST_JAR.equals(dependency.getType()) || !this.versions.containsKey(gac = MavenProjectArtifactVersions.gac(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier()))) continue;
                this.put(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), dependency.getVersion(), dependency.getType());
            }
        }
    }

    private static String gac(String groupId, String artifactId, String classifier) {
        StringBuilder buf = new StringBuilder(groupId).append(':').append(artifactId);
        if (classifier != null && !classifier.isEmpty()) {
            buf.append("::").append(classifier);
        }
        return buf.toString();
    }

    String getVersion(String gac) {
        return this.versions.get(gac);
    }

    private void put(String groupId, String artifactId, String classifier, String version, String type) {
        StringBuilder buf = new StringBuilder(groupId).append(':').append(artifactId);
        StringBuilder versionClassifier = new StringBuilder(buf);
        versionClassifier.append(':').append(version).append(':');
        if (classifier != null && !classifier.isEmpty()) {
            buf.append("::").append(classifier);
            versionClassifier.append(classifier);
        }
        this.versions.put(buf.toString(), versionClassifier.append(':').append(type).toString());
    }

    void remove(String groupId, String artifactId) {
        this.versions.remove(groupId + ':' + artifactId);
    }

    void store(Path target) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(target, StandardOpenOption.CREATE);){
            for (Map.Entry<String, String> entry : this.versions.entrySet()) {
                writer.write(entry.getKey());
                writer.write(61);
                writer.write(entry.getValue());
                writer.newLine();
            }
        }
    }
}

