/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.maven;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.plugin.MojoExecutionException;
import org.jboss.galleon.Errors;
import org.wildfly.galleon.maven.FeaturePackBuildModelParser;
import org.wildfly.galleon.maven.WildFlyFeaturePackBuild;

class Util {
    Util() {
    }

    static WildFlyFeaturePackBuild loadFeaturePackBuildConfig(File configDir, String configFile) throws MojoExecutionException {
        Path path = Paths.get(configDir.getAbsolutePath(), configFile);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new MojoExecutionException(Errors.pathDoesNotExist((Path)path));
        }
        return Util.loadFeaturePackBuildConfig(path);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static WildFlyFeaturePackBuild loadFeaturePackBuildConfig(Path configFile) throws MojoExecutionException {
        try (InputStream configStream = Files.newInputStream(configFile, new OpenOption[0]);){
            WildFlyFeaturePackBuild wildFlyFeaturePackBuild = new FeaturePackBuildModelParser().parse(configStream);
            return wildFlyFeaturePackBuild;
        }
        catch (XMLStreamException e) {
            throw new MojoExecutionException(Errors.parseXml((Path)configFile), (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException(Errors.openFile((Path)configFile), (Exception)e);
        }
    }
}

