/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.maven.build.tasks;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.maven.plugin.MojoExecutionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.util.IoUtils;
import org.wildfly.galleon.maven.ArtifactCoordsUtil;
import org.wildfly.galleon.maven.WfFeaturePackBuildMojo;
import org.wildfly.galleon.maven.build.tasks.ResourcesTask;
import org.wildfly.galleon.plugin.ArtifactCoords;

public class CopyResourcesTask
implements ResourcesTask {
    private String path;
    private String artifact;
    private String to;

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getArtifact() {
        return this.artifact;
    }

    public void setArtifact(String artifact) {
        this.artifact = artifact;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    @Override
    public void execute(WfFeaturePackBuildMojo builder, Path resourcesDir) throws MojoExecutionException {
        Path src;
        String error = this.getValidationErrors();
        if (error != null) {
            throw new MojoExecutionException(error);
        }
        Path target = resourcesDir.resolve(this.to);
        if (this.artifact == null) {
            src = Paths.get(this.path, new String[0]);
            if (!Files.exists(src, new LinkOption[0])) {
                throw new MojoExecutionException("Copy task source " + src + " does not exist");
            }
            if (!Files.isDirectory(src, new LinkOption[0])) {
                if (this.to.charAt(this.to.length() - 1) == '/') {
                    target = target.resolve(src.getFileName());
                }
                this.mkdirs(target.getParent());
            } else {
                this.mkdirs(target);
            }
        } else {
            ArtifactCoords coords = ArtifactCoordsUtil.fromJBossModules(this.artifact, "jar");
            if (coords.getVersion() == null) {
                coords = ArtifactCoordsUtil.fromJBossModules(builder.resolveVersion(this.artifact), "jar");
            }
            try {
                src = builder.resolveArtifact(coords);
            }
            catch (ProvisioningException e) {
                throw new MojoExecutionException("Failed to resolve " + coords, (Exception)((Object)e));
            }
            if (this.to.charAt(this.to.length() - 1) == '/') {
                target = target.resolve(coords.getArtifactId() + '-' + coords.getVersion() + '.' + coords.getExtension());
            }
            this.mkdirs(target.getParent());
        }
        try {
            IoUtils.copy((Path)src, (Path)target);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to copy " + src + " to " + target, (Exception)e);
        }
    }

    private void mkdirs(Path p) throws MojoExecutionException {
        try {
            Files.createDirectories(p, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create directory " + p, (Exception)e);
        }
    }

    public String getValidationErrors() {
        String error = this.assertTargetSet();
        if (error == null) {
            error = this.assertSourceSet();
        }
        return error;
    }

    private String assertTargetSet() {
        if (this.to == null) {
            return "The copy task target has not been configured";
        }
        return null;
    }

    private String assertSourceSet() {
        if (this.path == null && this.artifact == null || this.path != null && this.artifact != null) {
            return "Either path or artifact has to be configured as the copy task source";
        }
        return null;
    }
}

