/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.maven;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.config.ConfigCustomizationsBuilder;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.galleon1.LegacyGalleon1Universe;
import org.jboss.galleon.util.ParsingUtils;
import org.jboss.galleon.xml.ConfigXml;
import org.jboss.galleon.xml.FeaturePackPackagesConfigParser10;
import org.jboss.galleon.xml.ProvisioningXmlParser30;
import org.jboss.galleon.xml.XmlNameProvider;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.galleon.maven.ArtifactCoordsUtil;
import org.wildfly.galleon.maven.FeaturePackDependencySpec;
import org.wildfly.galleon.maven.WildFlyFeaturePackBuild;
import org.wildfly.galleon.maven.build.tasks.CopyResourcesTask;
import org.wildfly.galleon.plugin.ArtifactCoords;

class FeaturePackBuildModelParser32
implements XMLElementReader<WildFlyFeaturePackBuild.Builder> {
    public static final String NAMESPACE = "urn:wildfly:feature-pack-build:3.2";

    FeaturePackBuildModelParser32() {
    }

    public void readElement(XMLExtendedStreamReader reader, WildFlyFeaturePackBuild.Builder builder) throws XMLStreamException {
        FeaturePackLocation fpl = null;
        int count = reader.getAttributeCount();
        block19: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case PRODUCER: {
                    fpl = FeaturePackLocation.fromString((String)reader.getAttributeValue(i));
                    continue block19;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (fpl == null) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), Collections.singleton(Attribute.PRODUCER));
        }
        builder.setProducer(fpl);
        block20: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case DEPENDENCIES: {
                            FeaturePackBuildModelParser32.parseDependencies(reader, builder);
                            continue block20;
                        }
                        case DEFAULT_PACKAGES: {
                            FeaturePackBuildModelParser32.parseDefaultPackages((XMLStreamReader)reader, builder);
                            continue block20;
                        }
                        case PACKAGE_SCHEMAS: {
                            FeaturePackBuildModelParser32.parsePackageSchemas((XMLStreamReader)reader, builder);
                            continue block20;
                        }
                        case CONFIG: {
                            ConfigModel.Builder config = ConfigModel.builder();
                            ConfigXml.readConfig((XMLExtendedStreamReader)reader, (ConfigModel.Builder)config);
                            try {
                                builder.addConfig(config.build());
                                continue block20;
                            }
                            catch (ProvisioningDescriptionException e) {
                                throw new XMLStreamException("Failed to create a config model instance", e);
                            }
                        }
                        case TRANSITIVE: {
                            FeaturePackBuildModelParser32.parseTransitive(reader, builder);
                            continue block20;
                        }
                        case PLUGINS: {
                            FeaturePackBuildModelParser32.parsePlugins(reader, builder);
                            continue block20;
                        }
                        case RESOURCES: {
                            FeaturePackBuildModelParser32.parseResources(reader, builder);
                            continue block20;
                        }
                        case GENERATE_FEATURE_SPECS: {
                            FeaturePackBuildModelParser32.parseGenerateFeatureSpecs(reader, builder);
                            continue block20;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private static void parseDefaultPackages(XMLStreamReader reader, WildFlyFeaturePackBuild.Builder builder) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case PACKAGE: {
                            builder.addDefaultPackage(FeaturePackBuildModelParser32.parseName(reader));
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private static void parseDependencies(XMLExtendedStreamReader reader, WildFlyFeaturePackBuild.Builder builder) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case DEPENDENCY: {
                            FeaturePackBuildModelParser32.parseDependency(reader, builder, false);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private static void parseDependency(XMLExtendedStreamReader reader, WildFlyFeaturePackBuild.Builder builder, boolean transitive) throws XMLStreamException {
        FeaturePackConfig.Builder depBuilder;
        String groupId = null;
        String artifactId = null;
        String version = null;
        boolean translateToFpl = false;
        int count = reader.getAttributeCount();
        EnumSet<Attribute> required = EnumSet.of(Attribute.GROUP_ID, Attribute.ARTIFACT_ID);
        block21: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case GROUP_ID: {
                    groupId = reader.getAttributeValue(i);
                    continue block21;
                }
                case ARTIFACT_ID: {
                    artifactId = reader.getAttributeValue(i);
                    continue block21;
                }
                case VERSION: {
                    version = reader.getAttributeValue(i);
                    continue block21;
                }
                case TRANSLATE_TO_FPL: {
                    translateToFpl = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block21;
                }
                default: {
                    throw ParsingUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), required);
        }
        FeaturePackLocation fpl = translateToFpl ? LegacyGalleon1Universe.toFpl(groupId, artifactId, version) : FeaturePackLocation.fromString((String)(groupId + ":" + artifactId + ":" + (String)StringUtils.defaultIfEmpty((CharSequence)version, (CharSequence)"")));
        String depName = null;
        FeaturePackConfig.Builder builder2 = depBuilder = transitive ? FeaturePackConfig.transitiveBuilder((FeaturePackLocation)fpl) : FeaturePackConfig.builder((FeaturePackLocation)fpl);
        block22: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    builder.addDependency(ArtifactCoords.newGav((String)groupId, (String)artifactId, (String)version), FeaturePackDependencySpec.create(depName, depBuilder.build()));
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case NAME: {
                            depName = reader.getElementText().trim();
                            continue block22;
                        }
                        case DEFAULT_CONFIGS: {
                            ProvisioningXmlParser30.parseDefaultConfigs((XMLExtendedStreamReader)reader, (ConfigCustomizationsBuilder)depBuilder);
                            continue block22;
                        }
                        case CONFIG: {
                            ConfigModel.Builder configBuilder = ConfigModel.builder();
                            ConfigXml.readConfig((XMLExtendedStreamReader)reader, (ConfigModel.Builder)configBuilder);
                            try {
                                depBuilder.addConfig(configBuilder.build());
                                continue block22;
                            }
                            catch (ProvisioningDescriptionException e) {
                                throw new XMLStreamException(e);
                            }
                        }
                        case PACKAGES: {
                            try {
                                FeaturePackPackagesConfigParser10.readPackages((XMLStreamReader)reader, (FeaturePackConfig.Builder)depBuilder);
                                continue block22;
                            }
                            catch (ProvisioningDescriptionException e) {
                                throw new XMLStreamException(e);
                            }
                        }
                        case PATCHES: {
                            FeaturePackBuildModelParser32.parsePatches(reader, depBuilder);
                            continue block22;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
    }

    private static void parseTransitive(XMLExtendedStreamReader reader, WildFlyFeaturePackBuild.Builder builder) throws XMLStreamException {
        ParsingUtils.parseNoAttributes((XMLStreamReader)reader);
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case DEPENDENCY: {
                            FeaturePackBuildModelParser32.parseDependency(reader, builder, true);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private static String parseName(XMLStreamReader reader) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), required);
        }
        ParsingUtils.parseNoContent((XMLStreamReader)reader);
        return name;
    }

    private static void parsePackageSchemas(XMLStreamReader reader, WildFlyFeaturePackBuild.Builder builder) throws XMLStreamException {
        ParsingUtils.parseNoAttributes((XMLStreamReader)reader);
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case GROUP: {
                            builder.addSchemaGroup(FeaturePackBuildModelParser32.parseName(reader));
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private static void parsePlugins(XMLExtendedStreamReader reader, WildFlyFeaturePackBuild.Builder builder) throws XMLStreamException {
        ParsingUtils.parseNoAttributes((XMLStreamReader)reader);
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case PLUGIN: {
                            FeaturePackBuildModelParser32.parsePlugin(reader, builder);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private static void parsePlugin(XMLExtendedStreamReader reader, WildFlyFeaturePackBuild.Builder builder) throws XMLStreamException {
        String id = null;
        ArtifactCoords coords = null;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case ID: {
                    id = reader.getAttributeValue(i);
                    continue block4;
                }
                case ARTIFACT: {
                    coords = ArtifactCoordsUtil.fromJBossModules(reader.getAttributeValue(i), "jar");
                    continue block4;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        ParsingUtils.parseNoContent((XMLStreamReader)reader);
        if (coords == null) {
            throw new XMLStreamException(ParsingUtils.missingAttributes((Location)reader.getLocation(), Collections.singleton(Attribute.ARTIFACT)));
        }
        if (id == null) {
            id = coords.getArtifactId();
        }
        builder.addPlugin(id, coords);
    }

    private static void parseResources(XMLExtendedStreamReader reader, WildFlyFeaturePackBuild.Builder builder) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case COPY: {
                            builder.addResourcesTask(FeaturePackBuildModelParser32.parseCopy((XMLStreamReader)reader));
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private static CopyResourcesTask parseCopy(XMLStreamReader reader) throws XMLStreamException {
        CopyResourcesTask copy = new CopyResourcesTask();
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case ARTIFACT: {
                    copy.setArtifact(reader.getAttributeValue(i));
                    continue block4;
                }
                case TO: {
                    copy.setTo(reader.getAttributeValue(i));
                    continue block4;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        String error = copy.getValidationErrors();
        if (error != null) {
            throw new XMLStreamException(ParsingUtils.error((String)error, (Location)reader.getLocation()));
        }
        ParsingUtils.parseNoContent((XMLStreamReader)reader);
        return copy;
    }

    private static void parseGenerateFeatureSpecs(XMLExtendedStreamReader reader, WildFlyFeaturePackBuild.Builder builder) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case EXTENSIONS: {
                            FeaturePackBuildModelParser32.parseExtensions(reader, builder);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private static void parseExtensions(XMLExtendedStreamReader reader, WildFlyFeaturePackBuild.Builder builder) throws XMLStreamException {
        block9: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case STANDALONE: {
                            FeaturePackBuildModelParser32.parseExtensions(reader, builder, Element.STANDALONE);
                            continue block9;
                        }
                        case DOMAIN: {
                            FeaturePackBuildModelParser32.parseExtensions(reader, builder, Element.DOMAIN);
                            continue block9;
                        }
                        case HOST: {
                            FeaturePackBuildModelParser32.parseExtensions(reader, builder, Element.HOST);
                            continue block9;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private static void parseExtensions(XMLExtendedStreamReader reader, WildFlyFeaturePackBuild.Builder builder, Element e) throws XMLStreamException {
        ParsingUtils.parseNoAttributes((XMLStreamReader)reader);
        block12: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case EXTENSION: {
                            switch (e) {
                                case STANDALONE: {
                                    builder.addStandaloneExtension(reader.getElementText().trim());
                                    continue block12;
                                }
                                case DOMAIN: {
                                    builder.addDomainExtension(reader.getElementText().trim());
                                    continue block12;
                                }
                                case HOST: {
                                    builder.addHostExtension(reader.getElementText().trim());
                                    continue block12;
                                }
                            }
                            throw new XMLStreamException("Unexpected extension target " + (Object)((Object)e), reader.getLocation());
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private static void parsePatches(XMLExtendedStreamReader reader, FeaturePackConfig.Builder fpConfigBuilder) throws XMLStreamException {
        ParsingUtils.parseNoAttributes((XMLStreamReader)reader);
        block9: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(new QName(reader.getLocalName()));
                    switch (element) {
                        case PATCH: {
                            FeaturePackLocation.FPID patchId = FeaturePackBuildModelParser32.readPatch(reader);
                            try {
                                fpConfigBuilder.addPatch(patchId);
                                continue block9;
                            }
                            catch (ProvisioningDescriptionException e) {
                                throw new XMLStreamException("Failed to add patch " + patchId + " to config", e);
                            }
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private static FeaturePackLocation.FPID readPatch(XMLExtendedStreamReader reader) throws XMLStreamException {
        FeaturePackLocation fpl = null;
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attribute = Attribute.of(new QName(reader.getAttributeName(i).getLocalPart()));
            switch (attribute) {
                case ID: {
                    fpl = FeaturePackLocation.fromString((String)reader.getAttributeValue(i));
                    continue block3;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (fpl == null) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), Collections.singleton(Attribute.ID));
        }
        ParsingUtils.parseNoContent((XMLStreamReader)reader);
        return fpl.getFPID();
    }

    static enum Attribute implements XmlNameProvider
    {
        ARTIFACT("artifact"),
        ARTIFACT_ID("artifact-id"),
        GROUP_ID("group-id"),
        ID("id"),
        NAME("name"),
        PRODUCER("producer"),
        TO("to"),
        TRANSLATE_TO_FPL("translate-to-fpl"),
        VERSION("version"),
        UNKNOWN(null);

        private static final Map<QName, Attribute> attributes;
        private final String name;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public String getNamespace() {
            return null;
        }

        static {
            HashMap<QName, Attribute> attributesMap = new HashMap<QName, Attribute>(9);
            attributesMap.put(new QName(ARTIFACT.getLocalName()), ARTIFACT);
            attributesMap.put(new QName(ARTIFACT_ID.getLocalName()), ARTIFACT_ID);
            attributesMap.put(new QName(GROUP_ID.getLocalName()), GROUP_ID);
            attributesMap.put(new QName(ID.getLocalName()), ID);
            attributesMap.put(new QName(NAME.getLocalName()), NAME);
            attributesMap.put(new QName(PRODUCER.getLocalName()), PRODUCER);
            attributesMap.put(new QName(TO.getLocalName()), TO);
            attributesMap.put(new QName(TRANSLATE_TO_FPL.getLocalName()), TRANSLATE_TO_FPL);
            attributesMap.put(new QName(VERSION.getLocalName()), VERSION);
            attributes = attributesMap;
        }
    }

    static enum Element {
        BUILD("build"),
        CONFIG("config"),
        COPY("copy"),
        DEFAULT_CONFIGS("default-configs"),
        DEFAULT_PACKAGES("default-packages"),
        DEPENDENCIES("dependencies"),
        DEPENDENCY("dependency"),
        DOMAIN("domain"),
        EXTENSION("extension"),
        EXTENSIONS("extensions"),
        GENERATE_FEATURE_SPECS("generate-feature-specs"),
        GROUP("group"),
        HOST("host"),
        NAME("name"),
        PACKAGE("package"),
        PACKAGES("packages"),
        PACKAGE_SCHEMAS("package-schemas"),
        PATCH("patch"),
        PATCHES("patches"),
        PLUGIN("plugin"),
        PLUGINS("plugins"),
        PRODUCER("producer"),
        RESOURCES("resources"),
        STANDALONE("standalone"),
        TRANSITIVE("transitive"),
        UNKNOWN(null);

        private static final Map<QName, Element> elements;
        private final String name;

        static Element of(QName qName) {
            QName name = qName.getNamespaceURI().equals("") ? new QName(FeaturePackBuildModelParser32.NAMESPACE, qName.getLocalPart()) : qName;
            Element element = elements.get(name);
            return element == null ? UNKNOWN : element;
        }

        private Element(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        static {
            HashMap<QName, Element> elementsMap = new HashMap<QName, Element>(23);
            elementsMap.put(new QName(FeaturePackBuildModelParser32.NAMESPACE, BUILD.getLocalName()), BUILD);
            elementsMap.put(new QName(FeaturePackBuildModelParser32.NAMESPACE, CONFIG.getLocalName()), CONFIG);
            elementsMap.put(new QName(FeaturePackBuildModelParser32.NAMESPACE, COPY.getLocalName()), COPY);
            elementsMap.put(new QName(FeaturePackBuildModelParser32.NAMESPACE, DEFAULT_CONFIGS.getLocalName()), DEFAULT_CONFIGS);
            elementsMap.put(new QName(FeaturePackBuildModelParser32.NAMESPACE, DEFAULT_PACKAGES.getLocalName()), DEFAULT_PACKAGES);
            elementsMap.put(new QName(FeaturePackBuildModelParser32.NAMESPACE, DEPENDENCIES.getLocalName()), DEPENDENCIES);
            elementsMap.put(new QName(FeaturePackBuildModelParser32.NAMESPACE, DEPENDENCY.getLocalName()), DEPENDENCY);
            elementsMap.put(new QName(FeaturePackBuildModelParser32.NAMESPACE, DOMAIN.getLocalName()), DOMAIN);
            elementsMap.put(new QName(FeaturePackBuildModelParser32.NAMESPACE, EXTENSION.getLocalName()), EXTENSION);
            elementsMap.put(new QName(FeaturePackBuildModelParser32.NAMESPACE, EXTENSIONS.getLocalName()), EXTENSIONS);
            elementsMap.put(new QName(FeaturePackBuildModelParser32.NAMESPACE, GENERATE_FEATURE_SPECS.getLocalName()), GENERATE_FEATURE_SPECS);
            elementsMap.put(new QName(FeaturePackBuildModelParser32.NAMESPACE, GROUP.getLocalName()), GROUP);
            elementsMap.put(new QName(FeaturePackBuildModelParser32.NAMESPACE, HOST.getLocalName()), HOST);
            elementsMap.put(new QName(FeaturePackBuildModelParser32.NAMESPACE, NAME.getLocalName()), NAME);
            elementsMap.put(new QName(FeaturePackBuildModelParser32.NAMESPACE, PACKAGE.getLocalName()), PACKAGE);
            elementsMap.put(new QName(FeaturePackBuildModelParser32.NAMESPACE, PACKAGES.getLocalName()), PACKAGES);
            elementsMap.put(new QName(FeaturePackBuildModelParser32.NAMESPACE, PACKAGE_SCHEMAS.getLocalName()), PACKAGE_SCHEMAS);
            elementsMap.put(new QName(FeaturePackBuildModelParser32.NAMESPACE, PATCH.getLocalName()), PATCH);
            elementsMap.put(new QName(FeaturePackBuildModelParser32.NAMESPACE, PATCHES.getLocalName()), PATCHES);
            elementsMap.put(new QName(FeaturePackBuildModelParser32.NAMESPACE, PLUGIN.getLocalName()), PLUGIN);
            elementsMap.put(new QName(FeaturePackBuildModelParser32.NAMESPACE, PLUGINS.getLocalName()), PLUGINS);
            elementsMap.put(new QName(FeaturePackBuildModelParser32.NAMESPACE, PRODUCER.getLocalName()), PRODUCER);
            elementsMap.put(new QName(FeaturePackBuildModelParser32.NAMESPACE, RESOURCES.getLocalName()), RESOURCES);
            elementsMap.put(new QName(FeaturePackBuildModelParser32.NAMESPACE, STANDALONE.getLocalName()), STANDALONE);
            elementsMap.put(new QName(FeaturePackBuildModelParser32.NAMESPACE, TRANSITIVE.getLocalName()), TRANSITIVE);
            elements = elementsMap;
        }
    }
}

