/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.maven;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.jboss.galleon.ProvisioningException;
import org.wildfly.galleon.plugin.Utils;

class MavenProjectArtifactVersions {
    private static final String TEST_JAR = "test-jar";
    private static final String SYSTEM = "system";
    private final Map<String, String> versions = new TreeMap<String, String>();

    static MavenProjectArtifactVersions getInstance(MavenProject project) {
        return new MavenProjectArtifactVersions(project);
    }

    private MavenProjectArtifactVersions(MavenProject project) {
        for (Artifact artifact : project.getArtifacts()) {
            if (TEST_JAR.equals(artifact.getType()) || SYSTEM.equals(artifact.getScope())) continue;
            this.put(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getVersion(), artifact.getType());
        }
    }

    String getVersion(String gac) {
        return this.versions.get(gac);
    }

    Map<String, String> getArtifacts() {
        return Collections.unmodifiableMap(this.versions);
    }

    private void put(String groupId, String artifactId, String classifier, String version, String type) {
        StringBuilder buf = new StringBuilder(groupId).append(':').append(artifactId);
        StringBuilder versionClassifier = new StringBuilder(buf);
        versionClassifier.append(':').append(version).append(':');
        if (classifier != null && !classifier.isEmpty()) {
            buf.append("::").append(classifier);
            versionClassifier.append(classifier);
        }
        this.versions.put(buf.toString(), versionClassifier.append(':').append(type).toString());
    }

    void remove(String groupId, String artifactId) {
        this.versions.remove(groupId + ':' + artifactId);
    }

    void store(Path target) throws IOException, ProvisioningException {
        MavenProjectArtifactVersions.store(this.versions, target);
    }

    static void store(Map<String, String> map, Path target) throws IOException, ProvisioningException {
        Map existingProperties = new HashMap();
        if (Files.exists(target, new LinkOption[0])) {
            existingProperties = Utils.readProperties((Path)target);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(target, StandardOpenOption.CREATE, StandardOpenOption.APPEND);){
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (existingProperties.containsKey(entry.getKey())) continue;
                writer.write(entry.getKey());
                writer.write(61);
                writer.write(entry.getValue());
                writer.newLine();
            }
        }
    }
}

