/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.maven;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.plugin.MojoExecutionException;
import org.jboss.galleon.Errors;
import org.jboss.galleon.util.IoUtils;
import org.wildfly.galleon.maven.FeaturePackBuildModelParser;
import org.wildfly.galleon.maven.WildFlyFeaturePackBuild;

class Util {
    Util() {
    }

    static WildFlyFeaturePackBuild loadFeaturePackBuildConfig(File configDir, String configFile) throws MojoExecutionException {
        Path path = Paths.get(configDir.getAbsolutePath(), configFile);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new MojoExecutionException(Errors.pathDoesNotExist((Path)path));
        }
        return Util.loadFeaturePackBuildConfig(path);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static WildFlyFeaturePackBuild loadFeaturePackBuildConfig(Path configFile) throws MojoExecutionException {
        try (InputStream configStream = Files.newInputStream(configFile, new OpenOption[0]);){
            WildFlyFeaturePackBuild wildFlyFeaturePackBuild = new FeaturePackBuildModelParser().parse(configStream);
            return wildFlyFeaturePackBuild;
        }
        catch (XMLStreamException e) {
            throw new MojoExecutionException(Errors.parseXml((Path)configFile), (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException(Errors.openFile((Path)configFile), (Exception)e);
        }
    }

    static void mkdirs(Path dir) throws MojoExecutionException {
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException(Errors.mkdirs((Path)dir), (Exception)e);
        }
    }

    static void copyIfExists(Path resources, Path fpDir, String resourceName) throws MojoExecutionException {
        Path res = resources.resolve(resourceName);
        if (Files.exists(res, new LinkOption[0])) {
            try {
                IoUtils.copy((Path)res, (Path)fpDir.resolve(resourceName));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to copy " + resourceName + " to the feature-pack", (Exception)e);
            }
        }
    }

    static void copyDirIfExists(Path srcDir, Path targetDir) throws MojoExecutionException {
        if (Files.exists(srcDir, new LinkOption[0])) {
            try {
                IoUtils.copy((Path)srcDir, (Path)targetDir);
            }
            catch (IOException e) {
                throw new MojoExecutionException(Errors.copyFile((Path)srcDir, (Path)targetDir), (Exception)e);
            }
        }
    }

    static void findModules(final Path modulesDir, final Map<String, Path> moduleXmlByPkgName) throws IOException {
        Files.walkFileTree(modulesDir, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (dir.getFileName().toString().equals("system") && dir.getParent().equals(modulesDir)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                Path moduleXml = dir.resolve("module.xml");
                if (!Files.exists(moduleXml, new LinkOption[0])) {
                    return FileVisitResult.CONTINUE;
                }
                String packageName = moduleXml.getParent().getFileName().toString().equals("main") ? modulesDir.relativize(moduleXml.getParent().getParent()).toString() : modulesDir.relativize(moduleXml.getParent()).toString();
                packageName = packageName.replace(File.separatorChar, '.');
                moduleXmlByPkgName.put(packageName, moduleXml);
                return FileVisitResult.SKIP_SUBTREE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.TERMINATE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

