/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.artifact.ArtifactCoordinate;
import org.apache.maven.shared.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.artifact.resolve.ArtifactResult;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.repository.RemoteRepository;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.layout.FeaturePackLayout;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.layout.ProvisioningLayoutFactory;
import org.jboss.galleon.maven.plugin.util.MavenArtifactRepositoryManager;
import org.jboss.galleon.repo.RepositoryArtifactResolver;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseFactoryLoader;
import org.jboss.galleon.universe.UniverseResolver;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.IoUtils;
import org.wildfly.galleon.maven.ArtifactCoordsUtil;
import org.wildfly.galleon.maven.ArtifactItem;
import org.wildfly.galleon.maven.FeaturePackDependencySpec;
import org.wildfly.galleon.maven.JakartaTransformation;
import org.wildfly.galleon.maven.MavenProjectArtifactVersions;
import org.wildfly.galleon.maven.ModuleXmlVersionResolver;
import org.wildfly.galleon.maven.WfFeaturePackBuildMojo;
import org.wildfly.galleon.maven.WildFlyFeaturePackBuild;
import org.wildfly.galleon.plugin.ArtifactCoords;
import org.wildfly.galleon.plugin.Utils;
import org.wildfly.galleon.plugin.WildFlyPackageTask;
import org.wildfly.galleon.plugin.WildFlyPackageTasks;
import org.wildfly.galleon.plugin.config.CopyArtifact;
import org.wildfly.galleon.plugin.config.WildFlyPackageTasksParser;

public class FeatureSpecGeneratorInvoker {
    private static final String MAVEN_REPO_LOCAL = "maven.repo.local";
    private static final String MODULES = "modules";
    public static final String MODULE_PATH_SEGMENT;
    private static final String TASKS_XML_PATH_END;
    private MavenProject project;
    private MavenSession session;
    private List<RemoteRepository> repositories;
    private RepositorySystem repoSystem;
    private ArtifactResolver artifactResolver;
    private WildFlyFeaturePackBuild buildConfig;
    private Log log;
    private File featureSpecsOutput;
    private boolean forkEmbedded;
    private Path wildflyHome;
    private Path moduleTemplatesDir;
    private Map<String, Artifact> mergedArtifacts = new HashMap<String, Artifact>();
    private Map<String, Map<String, Artifact>> moduleTemplates = new HashMap<String, Map<String, Artifact>>();
    private Map<String, Path> inheritedFeatureSpecs = Collections.emptyMap();
    private Set<String> standaloneExtensions = Collections.emptySet();
    private Set<String> domainExtensions = Collections.emptySet();
    private Set<String> hostExtensions = Collections.emptySet();
    private List<Path> layersConfs = Collections.emptyList();
    private WildFlyPackageTasksParser tasksParser;
    private ProvisioningLayoutFactory layoutFactory;
    private ProvisioningLayout<FeaturePackLayout> configLayout;
    private final JakartaTransformation jakartaTransformation;

    FeatureSpecGeneratorInvoker(WfFeaturePackBuildMojo mojo) throws MojoExecutionException {
        this.project = mojo.project;
        this.session = mojo.session;
        this.repositories = mojo.repositories;
        this.repoSystem = mojo.repoSystem;
        this.artifactResolver = mojo.artifactResolver;
        this.buildConfig = mojo.getBuildConfig();
        this.featureSpecsOutput = mojo.featureSpecsOutput;
        this.forkEmbedded = mojo.forkEmbedded;
        this.wildflyHome = mojo.wildflyHome.toPath();
        this.moduleTemplatesDir = mojo.moduleTemplatesDir.toPath();
        this.log = mojo.getLog();
        this.jakartaTransformation = mojo.getJakartaTransformation();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        long startTime = System.currentTimeMillis();
        int specsTotal = -1;
        try {
            IoUtils.recursiveDelete((Path)this.moduleTemplatesDir);
            Files.createDirectories(this.moduleTemplatesDir, new FileAttribute[0]);
            IoUtils.recursiveDelete((Path)this.wildflyHome);
            Files.createDirectories(this.wildflyHome, new FileAttribute[0]);
            specsTotal = this.doExecute();
        }
        catch (Error | RuntimeException | MojoExecutionException | MojoFailureException e) {
            throw e;
        }
        catch (IOException | MavenFilteringException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
        finally {
            if (this.configLayout != null) {
                this.configLayout.close();
            }
            if (this.layoutFactory != null) {
                this.layoutFactory.close();
            }
            if (this.log.isDebugEnabled() && specsTotal >= 0) {
                long totalTime = System.currentTimeMillis() - startTime;
                long secs = totalTime / 1000L;
                this.debug("Generated " + specsTotal + " feature specs in " + secs + "." + (totalTime - secs * 1000L) + " secs", new Object[0]);
            }
        }
    }

    private int doExecute() throws MojoExecutionException, MojoFailureException, MavenFilteringException, IOException {
        Path projectModules;
        Files.createDirectories(this.wildflyHome.resolve("bin"), new FileAttribute[0]);
        Files.createFile(this.wildflyHome.resolve("bin").resolve("jboss-cli-logging.properties"), new FileAttribute[0]);
        if (this.buildConfig.hasStandaloneExtensions()) {
            Files.createDirectories(this.wildflyHome.resolve("standalone").resolve("configuration"), new FileAttribute[0]);
            this.standaloneExtensions = new HashSet<String>(this.buildConfig.getStandaloneExtensions());
        }
        if (this.buildConfig.hasDomainExtensions() || this.buildConfig.hasHostExtensions()) {
            Files.createDirectories(this.wildflyHome.resolve("domain").resolve("configuration"), new FileAttribute[0]);
            this.domainExtensions = new HashSet<String>(this.buildConfig.getDomainExtensions());
            this.hostExtensions = new HashSet<String>(this.buildConfig.getHostExtensions());
        }
        this.processFeaturePackDeps(this.buildConfig);
        for (Artifact artifact : MavenProjectArtifactVersions.getFilteredArtifacts(this.project, this.buildConfig)) {
            this.registerArtifact(artifact, null);
        }
        Path projectResources = Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve("resources");
        Path packagesDir = projectResources.resolve("packages");
        if (Files.exists(packagesDir, new LinkOption[0])) {
            this.findAndCopyModules(packagesDir, this.mergedArtifacts);
            Path fpLayersConf = packagesDir.resolve("layers.conf");
            if (Files.exists(fpLayersConf, new LinkOption[0])) {
                if (!Files.exists(fpLayersConf = fpLayersConf.resolve("content").resolve(MODULES).resolve("layers.conf"), new LinkOption[0])) {
                    throw new MojoExecutionException("Package layers.conf is expected to contain modules/layers.conf but it does not");
                }
                this.layersConfs = CollectionUtils.add(this.layersConfs, (Object)fpLayersConf);
            }
            if (!this.layersConfs.isEmpty()) {
                try {
                    Utils.mergeLayersConfs(this.layersConfs, (Path)this.wildflyHome);
                }
                catch (ProvisioningException e) {
                    throw new MojoExecutionException("Failed to install layers.conf", (Exception)((Object)e));
                }
            }
        }
        if (Files.exists(projectModules = projectResources.resolve(MODULES), new LinkOption[0])) {
            this.copyModules(projectModules, this.mergedArtifacts);
        }
        if (!this.moduleTemplates.isEmpty()) {
            ArrayList<Artifact> hardcodedArtifacts = new ArrayList<Artifact>();
            Path targetModules = this.wildflyHome.resolve(MODULES);
            for (Map.Entry<String, Map<String, Artifact>> entry : this.moduleTemplates.entrySet()) {
                try {
                    ModuleXmlVersionResolver.convertModule(this.moduleTemplatesDir.resolve(entry.getKey()), targetModules.resolve(entry.getKey()), entry.getValue(), hardcodedArtifacts, this.log);
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Failed to process " + this.moduleTemplatesDir.resolve(entry.getKey()), e);
                }
                if (!this.jakartaTransformation.isJakartaTransformEnabled()) continue;
                for (Artifact toTransform : entry.getValue().values()) {
                    if (!toTransform.isResolved()) {
                        toTransform = this.findArtifact(new ArtifactItem(toTransform));
                    }
                    this.jakartaTransformation.transform(toTransform);
                }
            }
            for (Artifact art : hardcodedArtifacts) {
                this.findArtifact(art);
            }
        }
        this.addBasicConfigs();
        String originalMavenRepoLocal = System.getProperty(MAVEN_REPO_LOCAL);
        System.setProperty(MAVEN_REPO_LOCAL, this.jakartaTransformation.isJakartaTransformEnabled() ? this.jakartaTransformation.getJakartaTransformMavenRepo().toAbsolutePath().toString() : this.session.getSettings().getLocalRepository());
        this.debug("Generating feature specs using local maven repo %s", System.getProperty(MAVEN_REPO_LOCAL));
        ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
        URLClassLoader newCl = null;
        try {
            if (!this.forkEmbedded) {
                if (originalCl instanceof URLClassLoader) {
                    newCl = new URLClassLoader(((URLClassLoader)originalCl).getURLs(), originalCl.getParent());
                    Thread.currentThread().setContextClassLoader(newCl);
                } else {
                    this.log.warn((CharSequence)"Embedded server will be launched using the context classloader. Subsequent attempts to launch it using the same classloader may fail.");
                }
            }
            Class<?> specGenCls = (newCl == null ? originalCl : newCl).loadClass("org.wildfly.galleon.plugin.featurespec.generator.FeatureSpecGenerator");
            Method specGenMethod = specGenCls.getMethod("generateSpecs", new Class[0]);
            int n = (Integer)specGenMethod.invoke(specGenCls.getConstructor(String.class, Path.class, Map.class, Boolean.TYPE, Boolean.TYPE).newInstance(this.wildflyHome.toString(), this.featureSpecsOutput.toPath(), this.inheritedFeatureSpecs, this.forkEmbedded, this.log.isDebugEnabled()), new Object[0]);
            return n;
        }
        catch (InvocationTargetException e) {
            throw new MojoExecutionException("Feature spec generator failed", e.getCause());
        }
        catch (Throwable e) {
            throw new MojoExecutionException("Feature spec generator failed", e);
        }
        finally {
            if (newCl != null) {
                Thread.currentThread().setContextClassLoader(originalCl);
                try {
                    newCl.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (originalMavenRepoLocal == null) {
                System.clearProperty(MAVEN_REPO_LOCAL);
            } else {
                System.setProperty(MAVEN_REPO_LOCAL, originalMavenRepoLocal);
            }
        }
    }

    private void addBasicConfigs() throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        if (!this.standaloneExtensions.isEmpty()) {
            lines.add("<?xml version='1.0' encoding='UTF-8'?>");
            lines.add("<server xmlns=\"urn:jboss:domain:6.0\">");
            lines.add("<extensions>");
            for (String extension : this.standaloneExtensions) {
                lines.add(String.format("<extension module=\"%s\"/>", extension));
            }
            lines.add("</extensions>");
            lines.add("</server>");
            Files.write(this.wildflyHome.resolve("standalone").resolve("configuration").resolve("standalone.xml"), lines, new OpenOption[0]);
        }
        if (!this.domainExtensions.isEmpty()) {
            lines.clear();
            lines.add("<?xml version='1.0' encoding='UTF-8'?>");
            lines.add("<domain xmlns=\"urn:jboss:domain:6.0\">");
            lines.add("<extensions>");
            for (String extension : this.domainExtensions) {
                lines.add(String.format("<extension module=\"%s\"/>", extension));
            }
            lines.add("</extensions>");
            lines.add("</domain>");
            Files.write(this.wildflyHome.resolve("domain").resolve("configuration").resolve("domain.xml"), lines, new OpenOption[0]);
        }
        if (!this.hostExtensions.isEmpty()) {
            lines.clear();
            lines.add("<?xml version='1.0' encoding='UTF-8'?>");
            lines.add("<host xmlns=\"urn:jboss:domain:6.0\" name=\"master\">");
            lines.add("<extensions>");
            for (String extension : this.hostExtensions) {
                lines.add(String.format("<extension module=\"%s\"/>", extension));
            }
            lines.add("</extensions>");
            lines.add("<management>");
            lines.add("<management-interfaces>");
            lines.add("<http-interface>");
            lines.add("<http-upgrade enabled=\"true\"/>");
            lines.add("<socket interface=\"management\" port=\"${jboss.management.http.port:9990}\"/>");
            lines.add("</http-interface>");
            lines.add("</management-interfaces>");
            lines.add("</management>");
            lines.add("<domain-controller>");
            lines.add("<local />");
            lines.add("</domain-controller>");
            lines.add("<interfaces>");
            lines.add("<interface name=\"management\">");
            lines.add("<inet-address value=\"127.0.0.1\"/>");
            lines.add("</interface>");
            lines.add("</interfaces>");
            lines.add("</host>");
            Files.write(this.wildflyHome.resolve("domain").resolve("configuration").resolve("host.xml"), lines, new OpenOption[0]);
        }
    }

    private void copyArtifact(CopyArtifact task, Map<String, Artifact> artifacts) throws IOException {
        String location;
        String artifactCoords = task.getArtifact();
        ArtifactCoords coords = ArtifactCoordsUtil.fromJBossModules(artifactCoords, "jar");
        Artifact artifact = null;
        if (coords.getVersion() == null) {
            artifact = artifacts.get(artifactCoords);
        }
        if (artifact == null) {
            String key = coords.getGroupId() + ":" + coords.getArtifactId();
            artifact = coords.getClassifier() == null || coords.getClassifier().isEmpty() ? artifacts.get(key) : artifacts.get(key + "::" + coords.getClassifier());
        }
        if (artifact == null) {
            ArtifactItem item = new ArtifactItem();
            item.setGroupId(coords.getGroupId());
            item.setArtifactId(coords.getArtifactId());
            item.setVersion(coords.getVersion());
            item.setClassifier(coords.getClassifier());
            item.setType(coords.getExtension());
            try {
                artifact = this.findArtifact(item);
            }
            catch (MojoExecutionException e) {
                if (task.isOptional()) {
                    return;
                }
                throw new IOException("Failed to resolve " + coords, e);
            }
            if (artifact == null) {
                if (task.isOptional()) {
                    return;
                }
                throw new IOException("Failed to resolve " + coords);
            }
        }
        if (!(location = task.getToLocation()).isEmpty() && location.charAt(location.length() - 1) == '/') {
            location = location + artifact.getFile().getName();
        }
        Path target = this.wildflyHome.resolve(location);
        Path src = artifact.getFile().toPath();
        this.debug("Copying artifact %s to %s", src, target);
        if (task.isExtract()) {
            Utils.extractArtifact((Path)src, (Path)target, (CopyArtifact)task);
        } else {
            IoUtils.copy((Path)src, (Path)target);
        }
    }

    private void registerArtifact(Artifact artifact, Map<String, Artifact> artifacts) {
        String key = this.getArtifactKey(artifact);
        this.debug("Registering %s for key %s", artifact.toString(), key);
        if (artifacts != null) {
            artifacts.put(key, artifact);
        }
        this.mergedArtifacts.put(key, artifact);
    }

    private void initConfigLayout(WildFlyFeaturePackBuild buildConfig, MavenProjectArtifactVersions artifactVersions) throws MojoExecutionException {
        MavenArtifactRepositoryManager mvnRepo = new MavenArtifactRepositoryManager(this.repoSystem, this.session.getRepositorySession(), this.repositories);
        UniverseFactoryLoader ufl = UniverseFactoryLoader.getInstance().addArtifactResolver((RepositoryArtifactResolver)mvnRepo);
        try {
            this.layoutFactory = ProvisioningLayoutFactory.getInstance((UniverseResolver)UniverseResolver.builder((UniverseFactoryLoader)ufl).build());
            ProvisioningConfig.Builder configBuilder = ProvisioningConfig.builder();
            for (Map.Entry<ArtifactCoords.Gav, FeaturePackDependencySpec> entry : buildConfig.getDependencies().entrySet()) {
                ArtifactCoords depCoords = entry.getKey().toArtifactCoords();
                String ext = "zip";
                if (depCoords.getVersion() == null) {
                    String coordsStr = artifactVersions.getVersion(depCoords.getGroupId() + ':' + depCoords.getArtifactId());
                    if (coordsStr == null) {
                        throw new MojoExecutionException("Failed resolve artifact version for " + depCoords);
                    }
                    depCoords = ArtifactCoordsUtil.fromJBossModules(coordsStr, ext);
                    if (!depCoords.getExtension().equals("pom")) {
                        ext = depCoords.getExtension();
                    }
                }
                ArtifactItem artifact = new ArtifactItem();
                artifact.setGroupId(depCoords.getGroupId());
                artifact.setArtifactId(depCoords.getArtifactId());
                artifact.setVersion(depCoords.getVersion());
                artifact.setType(ext);
                Artifact resolved = this.findArtifact(artifact);
                if (resolved == null) {
                    throw new MojoExecutionException("Failed to resolve feature-pack artifact " + artifact);
                }
                Path p = resolved.getFile().toPath();
                if (p == null) {
                    throw new MojoExecutionException("Failed to resolve feature-pack artifact path " + artifact);
                }
                FeaturePackLocation fpl = this.layoutFactory.addLocal(p, false);
                FeaturePackConfig depConfig = entry.getValue().getTarget();
                configBuilder.addFeaturePackDep(depConfig.isTransitive() ? FeaturePackConfig.transitiveBuilder((FeaturePackLocation)fpl).init(depConfig).build() : FeaturePackConfig.builder((FeaturePackLocation)fpl).init(depConfig).build());
            }
            this.configLayout = this.layoutFactory.newConfigLayout(configBuilder.build());
        }
        catch (ProvisioningException e) {
            throw new MojoExecutionException("Failed to initialize provisioning layout for the feature-pack dependencies", (Exception)((Object)e));
        }
    }

    private void processFeaturePackDeps(WildFlyFeaturePackBuild buildConfig) throws MojoExecutionException, IOException {
        Map<ArtifactCoords.Gav, FeaturePackDependencySpec> fpDeps = buildConfig.getDependencies();
        if (fpDeps.isEmpty()) {
            return;
        }
        MavenProjectArtifactVersions artifactVersions = MavenProjectArtifactVersions.getInstance(this.project);
        this.initConfigLayout(buildConfig, artifactVersions);
        for (FeaturePackLayout fp : this.configLayout.getOrderedFeaturePacks()) {
            this.processFeaturePackDep(artifactVersions, fp);
        }
        try {
            this.layersConfs = Utils.collectLayersConf(this.configLayout);
        }
        catch (ProvisioningException e1) {
            throw new MojoExecutionException("Failed to collect layyers.conf files from feature-pack dependencies", (Exception)((Object)e1));
        }
    }

    private void processFeaturePackDep(MavenProjectArtifactVersions artifactVersions, FeaturePackLayout fp) throws MojoExecutionException, IOException {
        String line2;
        BufferedReader reader;
        Throwable throwable;
        Path fpDir = fp.getDir();
        Path p = fpDir.resolve("features");
        if (Files.exists(p, new LinkOption[0])) {
            if (this.inheritedFeatureSpecs.isEmpty()) {
                this.inheritedFeatureSpecs = new HashMap<String, Path>(500);
            }
            throwable = null;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(p);){
                for (Path path : stream) {
                    String specName = path.getFileName().toString();
                    if (specName.charAt(specName.length() - 1) == '/') {
                        specName = specName.substring(0, specName.length() - 1);
                    }
                    if (!Files.exists(path = path.resolve("spec.xml"), new LinkOption[0])) continue;
                    this.inheritedFeatureSpecs.put(specName, path);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        if (Files.exists(p = fpDir.resolve("packages"), new LinkOption[0])) {
            Map<String, Artifact> fpArtifacts = Collections.emptyMap();
            Path versionProps = fpDir.resolve("resources/wildfly/artifact-versions.properties");
            if (Files.exists(versionProps, new LinkOption[0])) {
                Map props;
                try {
                    props = Utils.readProperties((Path)versionProps);
                }
                catch (ProvisioningException e) {
                    throw new MojoExecutionException("Failed to read artifact versions file " + versionProps + " from " + fp.getFPID(), (Exception)((Object)e));
                }
                fpArtifacts = new HashMap<String, Artifact>(props.size());
                for (String v : props.values()) {
                    ArtifactCoords coords = ArtifactCoordsUtil.fromJBossModules(v, "jar");
                    ArtifactItem item = new ArtifactItem();
                    item.setGroupId(coords.getGroupId());
                    item.setArtifactId(coords.getArtifactId());
                    item.setVersion(coords.getVersion());
                    item.setClassifier(coords.getClassifier());
                    item.setType(coords.getExtension());
                    try {
                        this.registerArtifact(this.findArtifact(item), fpArtifacts);
                    }
                    catch (MojoExecutionException e) {
                        throw new MojoExecutionException("Failed to resolve artifact " + coords + " as a dependency of " + fp.getFPID() + " (persisted as " + v + ")", (Exception)((Object)e));
                    }
                }
            }
            this.findAndCopyModules(p, fpArtifacts);
        }
        if (!this.standaloneExtensions.isEmpty()) {
            try {
                p = fp.getResource(new String[]{"wildfly", "extensions-standalone"});
            }
            catch (ProvisioningDescriptionException e) {
                throw new MojoExecutionException("Failed to resolve extensions", (Exception)((Object)e));
            }
            if (Files.exists(p, new LinkOption[0])) {
                reader = Files.newBufferedReader(p);
                throwable = null;
                try {
                    line2 = reader.readLine();
                    while (line2 != null) {
                        this.standaloneExtensions.add(line2);
                        line2 = reader.readLine();
                    }
                }
                catch (Throwable line2) {
                    throwable = line2;
                    throw line2;
                }
                finally {
                    if (reader != null) {
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable line2) {
                                throwable.addSuppressed(line2);
                            }
                        } else {
                            reader.close();
                        }
                    }
                }
            }
        }
        if (!this.domainExtensions.isEmpty() || !this.hostExtensions.isEmpty()) {
            try {
                p = fp.getResource(new String[]{"wildfly", "extensions-domain"});
            }
            catch (ProvisioningDescriptionException e) {
                throw new MojoExecutionException("Failed to resolve extensions", (Exception)((Object)e));
            }
            if (Files.exists(p, new LinkOption[0])) {
                reader = Files.newBufferedReader(p);
                throwable = null;
                try {
                    line2 = reader.readLine();
                    while (line2 != null) {
                        this.domainExtensions.add(line2);
                        line2 = reader.readLine();
                    }
                }
                catch (Throwable line3) {
                    throwable = line3;
                    throw line3;
                }
                finally {
                    if (reader != null) {
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable line3) {
                                throwable.addSuppressed(line3);
                            }
                        } else {
                            reader.close();
                        }
                    }
                }
            }
            try {
                p = fp.getResource(new String[]{"wildfly", "extensions-host"});
            }
            catch (ProvisioningDescriptionException e) {
                throw new MojoExecutionException("Failed to resolve extensions", (Exception)((Object)e));
            }
            if (Files.exists(p, new LinkOption[0])) {
                reader = Files.newBufferedReader(p);
                throwable = null;
                try {
                    line2 = reader.readLine();
                    while (line2 != null) {
                        this.hostExtensions.add(line2);
                        line2 = reader.readLine();
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (reader != null) {
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            reader.close();
                        }
                    }
                }
            }
        }
    }

    private void findAndCopyModules(Path fpDirectory, final Map<String, Artifact> fpArtifacts) throws IOException {
        Files.walkFileTree(fpDirectory, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (dir.endsWith(MODULE_PATH_SEGMENT)) {
                    FeatureSpecGeneratorInvoker.this.debug("Copying %s to %s", new Object[]{dir, FeatureSpecGeneratorInvoker.this.moduleTemplatesDir});
                    FeatureSpecGeneratorInvoker.this.copyModules(dir, fpArtifacts);
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.endsWith(TASKS_XML_PATH_END)) {
                    FeatureSpecGeneratorInvoker.this.processPackageTasks(file, fpArtifacts);
                } else if (file.endsWith("layers.conf")) {
                    FeatureSpecGeneratorInvoker.this.layersConfs = CollectionUtils.add((List)FeatureSpecGeneratorInvoker.this.layersConfs, (Object)file);
                    try {
                        Utils.mergeLayersConfs((List)FeatureSpecGeneratorInvoker.this.layersConfs, (Path)FeatureSpecGeneratorInvoker.this.wildflyHome);
                    }
                    catch (ProvisioningException e) {
                        throw new RuntimeException("Failed to install layers.conf", e);
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void copyModules(final Path source, final Map<String, Artifact> fpArtifacts) throws IOException {
        Files.walkFileTree(source, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                block2: {
                    String relativePath = source.relativize(dir).toString();
                    Path targetDir = FeatureSpecGeneratorInvoker.this.moduleTemplatesDir.resolve(relativePath);
                    Files.createDirectories(targetDir.getParent(), new FileAttribute[0]);
                    try {
                        Files.copy(dir, targetDir, new CopyOption[0]);
                    }
                    catch (FileAlreadyExistsException e) {
                        if (Files.isDirectory(targetDir, new LinkOption[0])) break block2;
                        throw e;
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if ("module.xml".equals(file.getFileName().toString())) {
                    String relativePath = source.relativize(file).toString();
                    FeatureSpecGeneratorInvoker.this.moduleTemplates.put(relativePath, fpArtifacts);
                    Files.copy(file, FeatureSpecGeneratorInvoker.this.moduleTemplatesDir.resolve(relativePath), StandardCopyOption.REPLACE_EXISTING);
                } else {
                    Path target = FeatureSpecGeneratorInvoker.this.wildflyHome.resolve(FeatureSpecGeneratorInvoker.MODULES).resolve(source.relativize(file).toString());
                    Files.createDirectories(target.getParent(), new FileAttribute[0]);
                    Files.copy(file, target, new CopyOption[0]);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void processPackageTasks(Path file, Map<String, Artifact> artifacts) throws IOException {
        WildFlyPackageTasks tasks;
        if (this.tasksParser == null) {
            this.tasksParser = new WildFlyPackageTasksParser();
        }
        try (InputStream input = Files.newInputStream(file, new OpenOption[0]);){
            tasks = this.tasksParser.parse(input);
        }
        catch (XMLStreamException e) {
            throw new IOException("Failed to parse " + file, e);
        }
        for (WildFlyPackageTask task : tasks.getTasks()) {
            if (!task.getClass().equals(CopyArtifact.class)) continue;
            this.copyArtifact((CopyArtifact)task, artifacts);
        }
    }

    private Artifact findArtifact(ArtifactItem artifact) throws MojoExecutionException {
        this.resolveVersion(artifact);
        try {
            DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
            buildingRequest.setLocalRepository(this.session.getLocalRepository());
            buildingRequest.setRemoteRepositories(this.project.getRemoteArtifactRepositories());
            this.debug("Resolving artifact %s:%s:%s", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
            ArtifactResult result = this.artifactResolver.resolveArtifact((ProjectBuildingRequest)buildingRequest, (ArtifactCoordinate)artifact);
            return result == null ? null : result.getArtifact();
        }
        catch (ArtifactResolverException e) {
            throw new MojoExecutionException("Couldn't resolve artifact: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    private Artifact findArtifact(Artifact artifact) throws MojoExecutionException {
        try {
            Artifact retVal;
            DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
            buildingRequest.setLocalRepository(this.session.getLocalRepository());
            buildingRequest.setRemoteRepositories(this.project.getRemoteArtifactRepositories());
            this.debug("Resolving artifact %s:%s:%s", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
            ArtifactResult result = this.artifactResolver.resolveArtifact((ProjectBuildingRequest)buildingRequest, artifact);
            Artifact artifact2 = retVal = result != null ? result.getArtifact() : artifact;
            if (this.jakartaTransformation.isJakartaTransformEnabled()) {
                this.jakartaTransformation.transform(retVal);
            }
            return retVal;
        }
        catch (IOException | ArtifactResolverException e) {
            throw new MojoExecutionException("Couldn't resolve artifact: " + e.getMessage(), (Exception)e);
        }
    }

    private String getArtifactKey(Artifact artifact) {
        StringBuilder buf = new StringBuilder(artifact.getGroupId()).append(':').append(artifact.getArtifactId());
        String classifier = artifact.getClassifier();
        if (classifier != null && !classifier.isEmpty()) {
            buf.append("::").append(classifier);
        }
        return buf.toString();
    }

    private void resolveVersion(ArtifactItem artifact) {
        Artifact managedArtifact;
        if (artifact.getVersion() == null && (managedArtifact = (Artifact)this.project.getManagedVersionMap().get(artifact.getGroupId() + ':' + artifact.getArtifactId() + ':' + artifact.getType())) != null) {
            artifact.setVersion(managedArtifact.getVersion());
        }
    }

    private void debug(String format, Object ... args) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)String.format(format, args));
        }
    }

    static {
        String pmWf = "pm" + File.separator + "wildfly";
        MODULE_PATH_SEGMENT = pmWf + File.separator + "module" + File.separator + MODULES;
        TASKS_XML_PATH_END = pmWf + File.separator + "tasks.xml";
    }
}

