/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.License;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.layout.FeaturePackDescriber;
import org.jboss.galleon.maven.plugin.util.MavenArtifactRepositoryManager;
import org.jboss.galleon.repo.RepositoryArtifactResolver;
import org.jboss.galleon.spec.FeaturePackSpec;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.Universe;
import org.jboss.galleon.universe.UniverseFactoryLoader;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenChannel;
import org.jboss.galleon.universe.maven.MavenProducer;
import org.jboss.galleon.universe.maven.MavenUniverse;
import org.wildfly.galleon.maven.ArtifactCoordsUtil;
import org.wildfly.galleon.maven.ArtifactItem;
import org.wildfly.galleon.maven.ArtifactListBuilder;
import org.wildfly.galleon.maven.ArtifactListMerger;
import org.wildfly.galleon.maven.MavenProjectArtifactVersions;
import org.wildfly.galleon.plugin.ArtifactCoords;
import org.wildfly.maven.plugins.licenses.LicensesFileWriter;
import org.wildfly.maven.plugins.licenses.model.ProjectLicenseInfo;

@Mojo(name="generate-all-artifacts-list", requiresDependencyResolution=ResolutionScope.RUNTIME, defaultPhase=LifecyclePhase.COMPILE)
public class AllArtifactListGeneratorMojo
extends AbstractMojo {
    @Component
    private ProjectBuilder mavenProjectBuilder;
    @Component
    private MavenProjectHelper projectHelper;
    @Component
    protected RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    protected RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    protected List<RemoteRepository> repositories;
    @Parameter(alias="feature-pack-group-id", required=true)
    private String fpGroupId;
    @Parameter(alias="feature-pack-artifact-id", required=true)
    private String fpArtifactId;
    @Parameter(alias="feature-pack-version", required=false)
    private String fpVersion;
    @Parameter(alias="offline", defaultValue="false")
    private boolean offline;
    @Parameter(alias="extra-artifacts", readonly=false, required=false)
    private List<ArtifactItem> extraArtifacts = Collections.emptyList();
    @Parameter(alias="output-licenses-file", readonly=false, required=false)
    private String licensesFile;
    @Parameter(alias="excluded-licenses-versions", readonly=false, required=false)
    private String excludedVersions;

    public void execute() throws MojoExecutionException, MojoFailureException {
        MavenProjectArtifactVersions projectArtifacts = MavenProjectArtifactVersions.getInstance(this.project);
        DefaultRepositorySystemSession noWorkspaceSession = new DefaultRepositorySystemSession(this.repoSession);
        noWorkspaceSession.setWorkspaceReader(null);
        MavenArtifactRepositoryManager artifactResolver = this.offline ? new MavenArtifactRepositoryManager(this.repoSystem, (RepositorySystemSession)noWorkspaceSession) : new MavenArtifactRepositoryManager(this.repoSystem, (RepositorySystemSession)noWorkspaceSession, this.repositories);
        ArtifactListMerger builder = new ArtifactListMerger(artifactResolver, this.repoSession.getLocalRepository().getBasedir().toPath(), this.getLog());
        UniverseFactoryLoader ufl = UniverseFactoryLoader.getInstance().addArtifactResolver((RepositoryArtifactResolver)artifactResolver);
        try {
            ArtifactCoords c;
            String coords;
            if (this.fpVersion == null && (coords = projectArtifacts.getVersion(this.fpGroupId + ":" + this.fpArtifactId)) != null && (c = ArtifactCoordsUtil.fromJBossModules(coords, null)) != null) {
                this.fpVersion = c.getVersion();
            }
            if (this.fpVersion == null) {
                throw new MojoExecutionException("Version for feature-pack has not been found.");
            }
            coords = new ArtifactCoords(this.fpGroupId, this.fpArtifactId, this.fpVersion, null, "zip");
            Path path = builder.add((ArtifactCoords)coords);
            this.addExtraArtifacts(builder, projectArtifacts);
            FeaturePackLocation fpl = FeaturePackLocation.fromString((String)(this.fpGroupId + ":" + this.fpArtifactId + ":" + this.fpVersion));
            FeaturePackSpec spec = FeaturePackDescriber.readSpec((Path)path);
            for (FeaturePackConfig cfg : spec.getTransitiveDeps()) {
                this.addFeaturePackContent(cfg.getLocation(), ufl, builder);
            }
            for (FeaturePackConfig cfg : spec.getFeaturePackDeps()) {
                this.addFeaturePackContent(cfg.getLocation(), ufl, builder);
            }
            this.addFeaturePackContent(fpl, ufl, builder);
            Path targetDir = Paths.get(this.project.getBuild().getDirectory(), new String[0]);
            if (!Files.exists(targetDir, new LinkOption[0])) {
                Files.createDirectories(targetDir, new FileAttribute[0]);
            }
            Path target = targetDir.resolve(this.fpArtifactId + '-' + this.fpVersion + "-all-artifacts-list." + "txt");
            Files.write(target, builder.build().getBytes(), new OpenOption[0]);
            this.generateLicenses(builder);
            this.projectHelper.attachArtifact(this.project, "txt", "artifact-list", target.toFile());
        }
        catch (IOException | ArtifactDescriptorException | ProvisioningException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
    }

    private void generateLicenses(ArtifactListBuilder builder) throws MojoExecutionException, ProvisioningException {
        if (this.licensesFile == null) {
            return;
        }
        ArrayList<ProjectLicenseInfo> dependencies = new ArrayList<ProjectLicenseInfo>();
        for (String p : builder.getMap().keySet()) {
            ProjectBuildingResult res;
            if (!p.endsWith(".pom")) continue;
            ArtifactCoords coords = AllArtifactListGeneratorMojo.toCoords(Paths.get(p, new String[0]), "pom");
            if (this.excludedVersions != null && coords.getVersion().matches(this.excludedVersions)) continue;
            ProjectBuildingRequest req = this.session.getProjectBuildingRequest();
            Path resolvedPath = builder.resolveArtifact(coords);
            try {
                res = this.mavenProjectBuilder.build(resolvedPath.toFile(), req);
            }
            catch (ProjectBuildingException ex) {
                this.getLog().warn((CharSequence)("Exception building project for " + p + ", skipping license generation"), (Throwable)ex);
                continue;
            }
            dependencies.add(this.createDependencyProject(res.getProject()));
        }
        LicensesFileWriter fw = new LicensesFileWriter();
        try {
            fw.writeLicenseSummary(dependencies, new File(this.licensesFile));
        }
        catch (ParserConfigurationException | TransformerException ex) {
            throw new MojoExecutionException(ex.getMessage(), ex);
        }
    }

    private static ArtifactCoords toCoords(Path path, String extension) {
        Path version = path.getParent();
        Path artifactId = version.getParent();
        Path groupId = artifactId.getParent();
        String grpId = groupId.toString().startsWith("/") ? groupId.toString().substring(1) : groupId.toString();
        ArtifactCoords coords = new ArtifactCoords(grpId.replaceAll("/", "."), artifactId.getFileName().toString(), version.getFileName().toString(), null, extension);
        return coords;
    }

    private ProjectLicenseInfo createDependencyProject(MavenProject depMavenProject) {
        ProjectLicenseInfo dependencyProject = new ProjectLicenseInfo(depMavenProject.getGroupId(), depMavenProject.getArtifactId(), depMavenProject.getVersion());
        List licenses = depMavenProject.getLicenses();
        this.getLog().debug((CharSequence)("Adding licenses for " + depMavenProject.getGroupId() + ":" + depMavenProject.getArtifactId() + ":" + depMavenProject.getVersion()));
        for (Object license : licenses) {
            dependencyProject.addLicense((License)license);
        }
        return dependencyProject;
    }

    private void addExtraArtifacts(ArtifactListMerger builder, MavenProjectArtifactVersions projectArtifacts) throws MojoExecutionException {
        for (ArtifactItem art : this.extraArtifacts) {
            ArtifactCoords c;
            String coords;
            if (art.getGroupId() == null) {
                throw new MojoExecutionException("GroupId can't be null");
            }
            if (art.getArtifactId() == null) {
                throw new MojoExecutionException("ArtifactId can't be null");
            }
            String ext = art.getType() == null ? "jar" : art.getType();
            String version = art.getVersion();
            if (version == null && (coords = projectArtifacts.getVersion(art.getGroupId() + ":" + art.getArtifactId())) != null && (c = ArtifactCoordsUtil.fromJBossModules(coords, null)) != null) {
                version = c.getVersion();
            }
            if (version == null) {
                throw new MojoExecutionException("Version for " + art.getGroupId() + ":" + art.getArtifactId() + " has not been found.");
            }
            try {
                this.addArtifact(builder, new ArtifactCoords(art.getGroupId(), art.getArtifactId(), version, art.getClassifier(), ext));
            }
            catch (Exception ex) {
                throw new MojoExecutionException(ex.getMessage(), ex);
            }
        }
    }

    private void addArtifact(ArtifactListMerger builder, ArtifactCoords coords) throws ProvisioningException, ArtifactDescriptorException, IOException, DependencyCollectionException {
        CollectRequest request = new CollectRequest();
        request.setRoot(new Dependency((Artifact)new DefaultArtifact(coords.getGroupId(), coords.getArtifactId(), coords.getClassifier(), coords.getExtension(), coords.getVersion()), "runtime"));
        CollectResult res = this.repoSystem.collectDependencies(this.repoSession, request);
        this.addDepNode(builder, res.getRoot());
    }

    private void addDepNode(ArtifactListMerger builder, DependencyNode n) throws ProvisioningException, ArtifactDescriptorException, IOException {
        Dependency d = n.getDependency();
        Artifact a = d.getArtifact();
        if (!("provided".equals(d.getScope()) || "test".equals(d.getScope()) || "system".equals(d.getScope()))) {
            builder.add(new ArtifactCoords(a.getGroupId(), a.getArtifactId(), a.getVersion(), a.getClassifier(), a.getExtension()));
            for (DependencyNode dn : n.getChildren()) {
                this.addDepNode(builder, dn);
            }
        }
    }

    private void addFeaturePackContent(FeaturePackLocation fpl, UniverseFactoryLoader ufl, ArtifactListMerger builder) throws ProvisioningException, ArtifactDescriptorException, IOException {
        this.addUniverseArtifacts(fpl, ufl, builder);
        this.addOffliner(fpl, ufl, builder);
    }

    private void addOffliner(FeaturePackLocation fpl, UniverseFactoryLoader ufl, ArtifactListMerger builder) throws ProvisioningException, IOException {
        ArtifactCoords coords = null;
        if (fpl.isMavenCoordinates()) {
            String producer = fpl.getProducerName();
            ArtifactCoords fpCoords = ArtifactCoords.fromString((String)producer, (String)"zip");
            coords = new ArtifactCoords(fpCoords.getGroupId(), fpCoords.getArtifactId(), fpl.getBuild(), "artifact-list", "txt");
        } else {
            Universe u = ufl.getUniverse(fpl.getUniverse());
            if (u instanceof MavenUniverse) {
                MavenUniverse mu = (MavenUniverse)u;
                MavenChannel channel = mu.getProducer(fpl.getProducerName()).getChannel(fpl.getChannelName());
                coords = new ArtifactCoords(channel.getFeaturePackGroupId(), channel.getFeaturePackArtifactId(), fpl.getBuild(), "artifact-list", "txt");
            }
        }
        if (coords != null) {
            builder.addOffliner(coords);
        }
    }

    private void addUniverseArtifacts(FeaturePackLocation fpl, UniverseFactoryLoader ufl, ArtifactListMerger builder) throws ProvisioningException, ArtifactDescriptorException, IOException {
        Universe u;
        if (fpl.hasUniverse() && (u = ufl.getUniverse(fpl.getUniverse())) instanceof MavenUniverse) {
            MavenUniverse mu = (MavenUniverse)u;
            MavenArtifact universeArtifact = mu.getArtifact();
            builder.add(new ArtifactCoords(universeArtifact.getGroupId(), universeArtifact.getArtifactId(), universeArtifact.getVersion(), universeArtifact.getClassifier(), universeArtifact.getExtension()));
            for (MavenProducer mp : mu.getProducers()) {
                MavenArtifact producerArt = mp.getArtifact();
                builder.add(new ArtifactCoords(producerArt.getGroupId(), producerArt.getArtifactId(), producerArt.getVersion(), producerArt.getClassifier(), producerArt.getExtension()));
            }
        }
    }
}

