/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.maven;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.wildfly.core.embedded.EmbeddedProcessFactory;
import org.wildfly.core.embedded.EmbeddedProcessStartException;
import org.wildfly.core.embedded.HostController;
import org.wildfly.core.embedded.StandaloneServer;
import org.wildfly.galleon.maven.FeatureSpecExporter;

public class EmbeddedScriptRunner {
    public static void exportStandalone(Path wildfly, Path outputDir, Map<String, String> inheritedFeatures, Properties props) throws IOException, ProvisioningException {
        StandaloneServer server = EmbeddedProcessFactory.createStandaloneServer((String)wildfly.toAbsolutePath().toString(), null, null, (String[])new String[]{"--admin-only"});
        try {
            server.start();
            try (ModelControllerClient client = server.getModelControllerClient();){
                EmbeddedScriptRunner.exportFeatures(client, outputDir, inheritedFeatures);
            }
            catch (XMLStreamException | ProvisioningDescriptionException ex) {
                throw new ProvisioningException(ex.getMessage(), ex);
            }
        }
        catch (EmbeddedProcessStartException ex) {
            throw new IOException(ex.getMessage(), ex);
        }
        finally {
            server.stop();
            EmbeddedScriptRunner.clearXMLConfiguration(props);
        }
    }

    public static void exportDomain(Path wildfly, Path outputDir, Map<String, String> inheritedFeatures, Properties props) throws IOException, ProvisioningException {
        HostController host = EmbeddedProcessFactory.createHostController((String)wildfly.toAbsolutePath().toString(), null, null, (String[])new String[]{"--admin-only"});
        try {
            host.start();
            try (ModelControllerClient client = host.getModelControllerClient();){
                EmbeddedScriptRunner.exportFeatures(client, outputDir, inheritedFeatures);
            }
            catch (XMLStreamException | ProvisioningDescriptionException ex) {
                throw new ProvisioningException(ex.getMessage(), ex);
            }
        }
        catch (EmbeddedProcessStartException ex) {
            throw new IOException(ex.getMessage(), ex);
        }
        finally {
            host.stop();
            EmbeddedScriptRunner.clearXMLConfiguration(props);
        }
    }

    private static void exportFeatures(ModelControllerClient client, Path outputDir, Map<String, String> inheritedFeatures) throws IOException, ProvisioningDescriptionException, XMLStreamException {
        ModelNode address = new ModelNode().setEmptyList();
        ModelNode op = Operations.createOperation((String)"read-feature", (ModelNode)address);
        op.get("recursive").set(true);
        ModelNode result = client.execute(op);
        FeatureSpecExporter.export(result, outputDir, inheritedFeatures);
    }

    public static ModelNode readStandaloneFeatures(Path wildfly, Properties props) throws IOException, ProvisioningException {
        StandaloneServer server = EmbeddedProcessFactory.createStandaloneServer((String)wildfly.toAbsolutePath().toString(), null, null, (String[])new String[]{"--admin-only"});
        try {
            ModelNode modelNode;
            block14: {
                server.start();
                ModelControllerClient client = server.getModelControllerClient();
                try {
                    modelNode = EmbeddedScriptRunner.readFeatures(client);
                    if (client == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (client != null) {
                                try {
                                    client.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (XMLStreamException | ProvisioningDescriptionException ex) {
                            throw new ProvisioningException(ex.getMessage(), ex);
                        }
                    }
                    catch (EmbeddedProcessStartException ex) {
                        throw new IOException(ex.getMessage(), ex);
                    }
                }
                client.close();
            }
            return modelNode;
        }
        finally {
            server.stop();
            EmbeddedScriptRunner.clearXMLConfiguration(props);
        }
    }

    public static ModelNode readDomainFeatures(Path wildfly, Properties props) throws IOException, ProvisioningException {
        HostController host = EmbeddedProcessFactory.createHostController((String)wildfly.toAbsolutePath().toString(), null, null, (String[])new String[]{"--admin-only"});
        try {
            ModelNode modelNode;
            block14: {
                host.start();
                ModelControllerClient client = host.getModelControllerClient();
                try {
                    modelNode = EmbeddedScriptRunner.readFeatures(client);
                    if (client == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (client != null) {
                                try {
                                    client.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (XMLStreamException | ProvisioningDescriptionException ex) {
                            throw new ProvisioningException(ex.getMessage(), ex);
                        }
                    }
                    catch (EmbeddedProcessStartException ex) {
                        throw new IOException(ex.getMessage(), ex);
                    }
                }
                client.close();
            }
            return modelNode;
        }
        finally {
            host.stop();
            EmbeddedScriptRunner.clearXMLConfiguration(props);
        }
    }

    private static ModelNode readFeatures(ModelControllerClient client) throws IOException, ProvisioningDescriptionException, XMLStreamException {
        ModelNode address = new ModelNode().setEmptyList();
        ModelNode op = Operations.createOperation((String)"read-feature", (ModelNode)address);
        op.get("recursive").set(true);
        ModelNode result = client.execute(op);
        EmbeddedScriptRunner.checkOutcome(result);
        if (result.hasDefined("result")) {
            return result.require("result");
        }
        return result;
    }

    private static void checkOutcome(ModelNode result) throws ProvisioningDescriptionException {
        if (!result.get("outcome").asString().equals("success")) {
            if (result.hasDefined("failure-description")) {
                throw new ProvisioningDescriptionException(result.get("failure-description").asString());
            }
            throw new ProvisioningDescriptionException("Error executing operation " + result.asString());
        }
    }

    private static void clearXMLConfiguration(Properties props) {
        EmbeddedScriptRunner.clearProperty(props, "javax.xml.parsers.DocumentBuilderFactory");
        EmbeddedScriptRunner.clearProperty(props, "javax.xml.parsers.SAXParserFactory");
        EmbeddedScriptRunner.clearProperty(props, "javax.xml.transform.TransformerFactory");
        EmbeddedScriptRunner.clearProperty(props, "javax.xml.xpath.XPathFactory");
        EmbeddedScriptRunner.clearProperty(props, "javax.xml.stream.XMLEventFactory");
        EmbeddedScriptRunner.clearProperty(props, "javax.xml.stream.XMLInputFactory");
        EmbeddedScriptRunner.clearProperty(props, "javax.xml.stream.XMLOutputFactory");
        EmbeddedScriptRunner.clearProperty(props, "javax.xml.datatype.DatatypeFactory");
        EmbeddedScriptRunner.clearProperty(props, "javax.xml.validation.SchemaFactory");
        EmbeddedScriptRunner.clearProperty(props, "org.xml.sax.driver");
    }

    private static void clearProperty(Properties props, String name) {
        if (props.containsKey(name)) {
            System.setProperty(name, props.getProperty(name));
        } else {
            System.clearProperty(name);
        }
    }
}

