/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.maven;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.spec.CapabilitySpec;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.CollectionUtils;
import org.wildfly.galleon.maven.FeaturePackDependencySpec;
import org.wildfly.galleon.maven.build.tasks.ResourcesTask;
import org.wildfly.galleon.plugin.ArtifactCoords;

public class WildFlyFeaturePackBuild {
    private final FeaturePackLocation producer;
    private final Map<ArtifactCoords.Gav, FeaturePackDependencySpec> dependencies;
    private final Set<String> schemaGroups;
    private final Set<String> defaultPackages;
    private final List<ConfigModel> configs;
    private final boolean includePlugin;
    private final Map<String, ArtifactCoords> plugins;
    private final List<ResourcesTask> resourcesTasks;
    private final List<String> standaloneExtensions;
    private final List<String> domainExtensions;
    private final List<String> hostExtensions;
    private final Set<String> systemPaths;

    public static Builder builder() {
        return new Builder();
    }

    private WildFlyFeaturePackBuild(Builder builder) {
        this.producer = builder.producer;
        this.dependencies = CollectionUtils.unmodifiable(builder.dependencies);
        this.schemaGroups = CollectionUtils.unmodifiable(builder.schemaGroups);
        this.defaultPackages = CollectionUtils.unmodifiable(builder.defaultPackages);
        this.configs = CollectionUtils.unmodifiable(builder.configs);
        this.includePlugin = builder.includePlugin;
        this.plugins = CollectionUtils.unmodifiable(builder.plugins);
        this.resourcesTasks = CollectionUtils.unmodifiable(builder.resourcesTasks);
        this.standaloneExtensions = CollectionUtils.unmodifiable(builder.standaloneExtensions);
        this.domainExtensions = CollectionUtils.unmodifiable(builder.domainExtensions);
        this.hostExtensions = CollectionUtils.unmodifiable(builder.hostExtensions);
        this.systemPaths = CollectionUtils.unmodifiable(builder.systemPaths);
    }

    public FeaturePackLocation getProducer() {
        return this.producer;
    }

    public Collection<String> getDefaultPackages() {
        return this.defaultPackages;
    }

    public Map<ArtifactCoords.Gav, FeaturePackDependencySpec> getDependencies() {
        return this.dependencies;
    }

    public boolean hasSchemaGroups() {
        return !this.schemaGroups.isEmpty();
    }

    public boolean isSchemaGroup(String groupId) {
        return this.schemaGroups.contains(groupId);
    }

    public Set<String> getSchemaGroups() {
        return this.schemaGroups;
    }

    public boolean hasConfigs() {
        return !this.configs.isEmpty();
    }

    public List<ConfigModel> getConfigs() {
        return this.configs;
    }

    public boolean isIncludePlugin() {
        return this.includePlugin;
    }

    public boolean hasPlugins() {
        return !this.plugins.isEmpty();
    }

    public Map<String, ArtifactCoords> getPlugins() {
        return this.plugins;
    }

    public boolean hasResourcesTasks() {
        return !this.resourcesTasks.isEmpty();
    }

    public List<ResourcesTask> getResourcesTasks() {
        return this.resourcesTasks;
    }

    public boolean hasStandaloneExtensions() {
        return !this.standaloneExtensions.isEmpty();
    }

    public List<String> getStandaloneExtensions() {
        return this.standaloneExtensions;
    }

    public boolean hasDomainExtensions() {
        return !this.domainExtensions.isEmpty();
    }

    public List<String> getDomainExtensions() {
        return this.domainExtensions;
    }

    public boolean hasHostExtensions() {
        return !this.hostExtensions.isEmpty();
    }

    public List<String> getHostExtensions() {
        return this.hostExtensions;
    }

    public boolean hasSystemPaths() {
        return !this.systemPaths.isEmpty();
    }

    public Set<String> getSystemPaths() {
        return this.systemPaths;
    }

    public static class Builder {
        private FeaturePackLocation producer;
        private Map<ArtifactCoords.Gav, FeaturePackDependencySpec> dependencies = Collections.emptyMap();
        private Set<String> schemaGroups = Collections.emptySet();
        private Set<String> defaultPackages = Collections.emptySet();
        private List<ConfigModel> configs = Collections.emptyList();
        private boolean includePlugin = true;
        private Map<String, ArtifactCoords> plugins = Collections.emptyMap();
        private List<ResourcesTask> resourcesTasks = Collections.emptyList();
        private List<String> standaloneExtensions = Collections.emptyList();
        private List<String> domainExtensions = Collections.emptyList();
        private List<String> hostExtensions = Collections.emptyList();
        private Set<String> systemPaths = Collections.emptySet();

        private Builder() {
        }

        public Builder setProducer(FeaturePackLocation producer) {
            this.producer = producer;
            return this;
        }

        public Builder addDefaultPackage(String packageName) {
            this.defaultPackages = CollectionUtils.add(this.defaultPackages, (Object)packageName);
            return this;
        }

        public Builder addDependency(ArtifactCoords.Gav gav, FeaturePackDependencySpec dependency) {
            this.dependencies = CollectionUtils.putLinked(this.dependencies, (Object)gav, (Object)dependency);
            return this;
        }

        public Builder addSchemaGroup(String groupId) {
            this.schemaGroups = CollectionUtils.add(this.schemaGroups, (Object)groupId);
            return this;
        }

        public Builder addConfig(ConfigModel config) {
            this.configs = CollectionUtils.add(this.configs, (Object)config);
            return this;
        }

        public Builder setIncludePlugin(boolean includePlugin) {
            this.includePlugin = includePlugin;
            return this;
        }

        public Builder addPlugin(String id, ArtifactCoords coords) {
            this.plugins = CollectionUtils.put(this.plugins, (Object)id, (Object)coords);
            return this;
        }

        public Builder addResourcesTask(ResourcesTask task) {
            this.resourcesTasks = CollectionUtils.add(this.resourcesTasks, (Object)task);
            return this;
        }

        public Builder addStandaloneExtension(String extension) {
            this.standaloneExtensions = CollectionUtils.add(this.standaloneExtensions, (Object)extension);
            return this;
        }

        public Builder addDomainExtension(String extension) {
            this.domainExtensions = CollectionUtils.add(this.domainExtensions, (Object)extension);
            return this;
        }

        public Builder addHostExtension(String extension) {
            this.hostExtensions = CollectionUtils.add(this.hostExtensions, (Object)extension);
            return this;
        }

        public Builder addSystemPath(String systemPath) {
            this.systemPaths = CollectionUtils.add(this.systemPaths, (Object)systemPath);
            return this;
        }

        public WildFlyFeaturePackBuild build() {
            return new WildFlyFeaturePackBuild(this);
        }

        void providesCapability(CapabilitySpec cap) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

