/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import nu.xom.ParsingException;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.artifact.resolve.ArtifactResult;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.Stability;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.layout.FeaturePackDescriber;
import org.jboss.galleon.layout.FeaturePackDescription;
import org.jboss.galleon.maven.plugin.FpMavenErrors;
import org.jboss.galleon.maven.plugin.util.MavenArtifactRepositoryManager;
import org.jboss.galleon.spec.ConfigLayerSpec;
import org.jboss.galleon.spec.FeaturePackPlugin;
import org.jboss.galleon.spec.FeaturePackSpec;
import org.jboss.galleon.spec.FeatureSpec;
import org.jboss.galleon.spec.PackageDependencySpec;
import org.jboss.galleon.spec.PackageSpec;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.ZipUtils;
import org.jboss.galleon.xml.FeaturePackXmlWriter;
import org.jboss.galleon.xml.FeatureSpecXmlParser;
import org.jboss.galleon.xml.PackageXmlParser;
import org.jboss.galleon.xml.PackageXmlWriter;
import org.wildfly.channel.ChannelManifest;
import org.wildfly.channel.ChannelManifestMapper;
import org.wildfly.channel.ManifestRequirement;
import org.wildfly.channel.MavenCoordinate;
import org.wildfly.galleon.maven.ArtifactCoordsUtil;
import org.wildfly.galleon.maven.ArtifactListBuilder;
import org.wildfly.galleon.maven.FeaturePackDependencySpec;
import org.wildfly.galleon.maven.FeatureSpecGeneratorInvoker;
import org.wildfly.galleon.maven.MavenProjectArtifactVersions;
import org.wildfly.galleon.maven.ModuleIdentifier;
import org.wildfly.galleon.maven.ModuleParseResult;
import org.wildfly.galleon.maven.ModuleXmlParser;
import org.wildfly.galleon.maven.ModuleXmlVersionResolver;
import org.wildfly.galleon.maven.Util;
import org.wildfly.galleon.maven.WildFlyFeaturePackBuild;
import org.wildfly.galleon.maven.build.tasks.ResourcesTask;
import org.wildfly.galleon.plugin.ArtifactCoords;
import org.wildfly.galleon.plugin.WildFlyChannelResolutionMode;

public abstract class AbstractFeaturePackBuildMojo
extends AbstractMojo {
    private static final String MSG_PACKAGE_NOT_INCLUDED = " This package has not been included in the feature-pack due to its stability level being lower than the feature-pack minimum stability level.";
    private static final String MSG_PACKAGE_IGNORED = " This package dependency will be ignored at provisioning time.";
    private static final String MSG_PACKAGE_ERROR = " This package dependency will fail at provisioning time. You should remove this package dependency or add the 'valid-for-stability' attribute to this package dependency.";
    private static final String PACKAGE = "package";
    private static final String FEATURE = "feature";
    private static final String LAYER = "layer";
    private static final String CONFIG = "config";
    static final String ARTIFACT_LIST_CLASSIFIER = "artifact-list";
    static final String ARTIFACT_LIST_EXTENSION = "txt";
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    protected RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    protected List<RemoteRepository> repositories;
    @Parameter(alias="release-name", defaultValue="${product.release.name}")
    private String releaseName;
    @Parameter(alias="task-properties-file", required=false)
    private File taskPropsFile;
    @Parameter(alias="task-properties", required=false)
    protected Map<String, String> taskProps = Collections.emptyMap();
    @Parameter(alias="generate-channel-manifest", required=false, defaultValue="false", property="wildfly.feature.pack.generate-channel-manifest")
    protected boolean generateChannelManifest;
    @Parameter(alias="add-feature-packs-as-required-manifests", required=false, defaultValue="true")
    protected boolean addFeaturePacksAsRequiredManifests;
    @Parameter(alias="wildfly-channel-resolution-mode", required=false, defaultValue="NOT_REQUIRED", property="wildfly.feature.pack.require.channel.resolution")
    protected WildFlyChannelResolutionMode wildflyChannelResolutionMode;
    @Parameter(alias="deploy-channel-manifest", required=false, defaultValue="true", property="wildfly.feature.pack.deploy-channel-manifest")
    protected boolean deployChannelManifest;
    @Component
    protected RepositorySystem repoSystem;
    @Component
    protected ArtifactResolver artifactResolver;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(alias="minimum-stability-level", required=false)
    protected String minimumStabilityLevel;
    @Parameter(alias="stability-level", required=false)
    protected String stabilityLevel;
    @Parameter(alias="config-stability-level", required=false)
    protected String configStabilityLevel;
    @Parameter(alias="forbid-lower-stability-level-package-reference", required=false, defaultValue="false")
    protected boolean forbidLowerStatibilityLevelPackageReference;
    @Parameter(alias="package-stability-level", required=false)
    protected String packageStabilityLevel;
    private MavenProjectArtifactVersions artifactVersions;
    private Map<String, FeaturePackDescription> fpDependencies = Collections.emptyMap();
    private Path workDir;
    private Path fpDir;
    private Path fpPackagesDir;
    private Path resourcesWildFly;
    private Path fpResourcesDir;
    private Path resourcesDir;
    private Stability buildTimestabilityLevel;
    private Stability defaultConfigStabilityLevel;
    private Stability defaultPackageStabilityLevel;
    private final Set<String> lowerStabilityPackages = new HashSet<String>();

    static boolean isProvided(String module) {
        return module.startsWith("java.") || module.startsWith("jdk.") || module.equals("org.jboss.modules");
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.artifactVersions = MavenProjectArtifactVersions.getInstance(this.project);
        this.doExecute();
    }

    protected void setStability(WildFlyFeaturePackBuild buildConfig) throws MojoExecutionException {
        if (this.minimumStabilityLevel == null) {
            this.minimumStabilityLevel = buildConfig.getMinimumStabilityLevel();
        }
        Stability stability = this.buildTimestabilityLevel = this.minimumStabilityLevel == null ? null : Stability.fromString((String)this.minimumStabilityLevel);
        if (this.stabilityLevel == null) {
            this.stabilityLevel = buildConfig.getStabilityLevel();
        }
        if (this.configStabilityLevel == null) {
            this.configStabilityLevel = buildConfig.getConfigStabilityLevel();
        }
        if (this.packageStabilityLevel == null) {
            this.packageStabilityLevel = buildConfig.getPackageStabilityLevel();
        }
        if (this.stabilityLevel == null) {
            this.defaultConfigStabilityLevel = this.configStabilityLevel == null ? null : Stability.fromString((String)this.configStabilityLevel);
            this.defaultPackageStabilityLevel = this.packageStabilityLevel == null ? null : Stability.fromString((String)this.packageStabilityLevel);
        } else {
            if (this.configStabilityLevel != null) {
                throw new MojoExecutionException("stability option can't be set when config-stability-level option is set");
            }
            if (this.packageStabilityLevel != null) {
                throw new MojoExecutionException("stability option can't be set when package-stability-level option is set");
            }
            this.defaultConfigStabilityLevel = Stability.fromString((String)this.stabilityLevel);
            this.defaultPackageStabilityLevel = Stability.fromString((String)this.stabilityLevel);
        }
        AbstractFeaturePackBuildMojo.checkStabilityLevels(this.buildTimestabilityLevel, this.defaultConfigStabilityLevel, this.defaultPackageStabilityLevel);
    }

    protected Stability getMinimumStabilityLevel() {
        return this.buildTimestabilityLevel;
    }

    protected Stability getPackageStabilityLevel() {
        return this.defaultPackageStabilityLevel;
    }

    protected Stability getConfigStabilityLevel() {
        return this.defaultConfigStabilityLevel;
    }

    private static void checkStabilityLevels(Stability min, Stability config, Stability pkg) throws MojoExecutionException {
        min = min == null ? Stability.DEFAULT : min;
        config = config == null ? Stability.DEFAULT : config;
        Stability stability = pkg = pkg == null ? Stability.DEFAULT : pkg;
        if (!min.enables(config)) {
            throw new MojoExecutionException("The minimum stability " + min + " doesn't enable the config stability " + config);
        }
        if (!min.enables(pkg)) {
            throw new MojoExecutionException("The minimum stability " + min + " doesn't enable the package stability " + pkg);
        }
        if (!pkg.enables(config)) {
            throw new MojoExecutionException("The package stability " + pkg + " doesn't enable the config stability " + config);
        }
    }

    protected Map<String, FeaturePackDescription> getFpDependencies() {
        return this.fpDependencies;
    }

    protected MavenProjectArtifactVersions getArtifactVersions() {
        return this.artifactVersions;
    }

    protected abstract void doExecute() throws MojoExecutionException, MojoFailureException;

    protected void setupDirs(String buildName, String fpArtifactId, String layoutDir, Path resourcesDir) {
        if (this.workDir == null) {
            this.workDir = Paths.get(buildName, layoutDir);
            IoUtils.recursiveDelete((Path)this.workDir);
            this.fpDir = this.workDir.resolve(this.project.getGroupId()).resolve(fpArtifactId).resolve(this.project.getVersion());
            this.fpPackagesDir = this.fpDir.resolve("packages");
            this.fpResourcesDir = this.fpDir.resolve("resources");
            this.resourcesWildFly = this.fpResourcesDir.resolve("wildfly");
            this.resourcesDir = resourcesDir;
        }
    }

    protected Path getWorkDir() {
        Objects.requireNonNull(this.workDir);
        return this.workDir;
    }

    protected Path getWildFlyResourcesDir() {
        return this.resourcesWildFly;
    }

    protected Path getFpDir() {
        Objects.requireNonNull(this.fpDir);
        return this.fpDir;
    }

    protected Path getPackagesDir() {
        Objects.requireNonNull(this.fpPackagesDir);
        return this.fpPackagesDir;
    }

    public String resolveVersion(String coordsWoVersion) throws MojoExecutionException {
        String resolved = this.artifactVersions.getVersion(coordsWoVersion);
        if (resolved == null) {
            throw new MojoExecutionException("The project is missing dependency on " + coordsWoVersion);
        }
        return resolved;
    }

    protected void buildFeaturePack(FeaturePackDescription.Builder fpBuilder, WildFlyFeaturePackBuild buildConfig) throws MojoExecutionException {
        Path scriptsDir;
        OutputStream out;
        if (buildConfig.hasConfigs()) {
            for (ConfigModel config : buildConfig.getConfigs()) {
                try {
                    fpBuilder.getSpecBuilder().addConfig(config);
                }
                catch (ProvisioningDescriptionException e) {
                    throw new MojoExecutionException("Failed to add config to the feature-pack", (Exception)((Object)e));
                }
            }
        }
        if (buildConfig.hasPlugins()) {
            this.addPlugins(fpBuilder.getSpecBuilder(), buildConfig.getPlugins());
        }
        Util.mkdirs(this.resourcesWildFly);
        if (buildConfig.hasResourcesTasks()) {
            for (ResourcesTask task : buildConfig.getResourcesTasks()) {
                task.execute(this, this.fpResourcesDir);
            }
        }
        try {
            out = Files.newOutputStream(this.resourcesWildFly.resolve("wildfly-tasks.properties"), new OpenOption[0]);
            try {
                this.getFPConfigProperties().store(out, "WildFly feature-pack properties");
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to store feature-pack properties", (Exception)e);
        }
        for (ArtifactCoords.Gav gav : buildConfig.getDependencies().keySet()) {
            this.getArtifactVersions().remove(gav.getGroupId(), gav.getArtifactId());
        }
        try {
            out = Files.newOutputStream(this.resourcesWildFly.resolve("wildfly-channel.properties"), new OpenOption[0]);
            try {
                this.getWildFlyChannelProperties().store(out, "WildFly channel properties");
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to store WildFly channel properties", (Exception)e);
        }
        try {
            Path srcArtifacts = this.resourcesDir.resolve("resources");
            if (Files.exists(srcArtifacts, new LinkOption[0])) {
                IoUtils.copy((Path)srcArtifacts, (Path)this.fpResourcesDir);
            }
            this.getArtifactVersions().store(this.resourcesWildFly.resolve("artifact-versions.properties"));
        }
        catch (IOException | ProvisioningException e) {
            throw new MojoExecutionException("Failed to store artifact versions", (Exception)e);
        }
        DefaultRepositorySystemSession noWorkspaceSession = new DefaultRepositorySystemSession(this.repoSession);
        noWorkspaceSession.setWorkspaceReader(null);
        noWorkspaceSession.setOffline(true);
        ArtifactListBuilder builder = new ArtifactListBuilder(new MavenArtifactRepositoryManager(this.repoSystem, (RepositorySystemSession)noWorkspaceSession, this.repositories), this.repoSession.getLocalRepository().getBasedir().toPath(), this.getLog());
        this.buildArtifactList(builder);
        this.addConfigPackages(this.resourcesDir.resolve("packages"), this.fpDir.resolve("packages"), fpBuilder);
        Util.copyIfExists(this.resourcesDir, this.fpDir, "layers");
        Util.copyIfExists(this.resourcesDir, this.fpDir, "configs");
        this.addFeatures(this.resourcesDir.resolve("features"), this.fpDir.resolve("features"));
        Util.copyDirIfExists(this.resourcesDir.resolve("feature_groups"), this.fpDir.resolve("feature_groups"));
        Path resourcesWildFly = this.getWildFlyResourcesDir();
        if (buildConfig.hasStandaloneExtensions()) {
            this.persistExtensions(resourcesWildFly, "extensions-standalone", buildConfig.getStandaloneExtensions());
        }
        if (buildConfig.hasDomainExtensions()) {
            this.persistExtensions(resourcesWildFly, "extensions-domain", buildConfig.getDomainExtensions());
        }
        if (buildConfig.hasHostExtensions()) {
            this.persistExtensions(resourcesWildFly, "extensions-host", buildConfig.getHostExtensions());
        }
        if (Files.exists(scriptsDir = this.resourcesDir.resolve("scripts"), new LinkOption[0])) {
            if (!Files.isDirectory(scriptsDir, new LinkOption[0])) {
                throw new MojoExecutionException("scripts is not a directory");
            }
            try {
                IoUtils.copy((Path)scriptsDir, (Path)resourcesWildFly.resolve("scripts"));
            }
            catch (IOException e) {
                throw new MojoExecutionException(Errors.copyFile((Path)scriptsDir, (Path)resourcesWildFly.resolve("scripts")), (Exception)e);
            }
        }
        try {
            fpBuilder.getSpecBuilder().setConfigStability(this.defaultConfigStabilityLevel);
            fpBuilder.getSpecBuilder().setPackageStability(this.defaultPackageStabilityLevel);
            FeaturePackDescription fpLayout = fpBuilder.build();
            FeaturePackXmlWriter.getInstance().write((Object)fpLayout.getSpec(), this.getFpDir().resolve("feature-pack.xml"));
        }
        catch (IOException | XMLStreamException | ProvisioningDescriptionException e) {
            throw new MojoExecutionException(Errors.writeFile((Path)this.getFpDir().resolve("feature-pack.xml")), (Exception)e);
        }
        try (DirectoryStream<Path> wdStream = Files.newDirectoryStream(this.getWorkDir(), entry -> Files.isDirectory(entry, new LinkOption[0]));){
            for (Path groupDir : wdStream) {
                DirectoryStream<Path> groupStream = Files.newDirectoryStream(groupDir);
                try {
                    for (Path artifactDir : groupStream) {
                        String artifactId = artifactDir.getFileName().toString();
                        DirectoryStream<Path> artifactStream = Files.newDirectoryStream(artifactDir);
                        try {
                            for (Path versionDir : artifactStream) {
                                Path target = Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve(artifactId + "-" + versionDir.getFileName() + ".zip");
                                if (Files.exists(target, new LinkOption[0])) {
                                    IoUtils.recursiveDelete((Path)target);
                                }
                                try {
                                    FeaturePackDescription desc = FeaturePackDescriber.describeFeaturePack((Path)versionDir, (String)"UTF-8");
                                    AbstractFeaturePackBuildMojo.checkFeaturePackContentStability(this.buildTimestabilityLevel, this.forbidLowerStatibilityLevelPackageReference, this.lowerStabilityPackages, desc.getPackages(), desc.getLayers(), desc.getFeatures(), desc.getConfigs(), this.getLog());
                                }
                                catch (Exception ex) {
                                    throw new RuntimeException(ex);
                                }
                                ZipUtils.zip((Path)versionDir, (Path)target);
                                this.debug("Attaching feature-pack %s as a project artifact", target);
                                this.projectHelper.attachArtifact(this.project, "zip", target.toFile());
                                Path offLinerTarget = Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve(artifactId + "-" + versionDir.getFileName() + "-artifact-list.txt");
                                this.debug("Attaching feature-pack artifact list %s as a project artifact", offLinerTarget);
                                Files.write(offLinerTarget, builder.build().getBytes(), new OpenOption[0]);
                                this.projectHelper.attachArtifact(this.project, ARTIFACT_LIST_EXTENSION, ARTIFACT_LIST_CLASSIFIER, offLinerTarget.toFile());
                                if (!this.generateChannelManifest) continue;
                                Path channelManifestTarget = Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve(artifactId + "-" + versionDir.getFileName() + "-manifest.yaml");
                                this.debug("Attaching channel manifest definition %s as a project artifact", channelManifestTarget);
                                String channelManifest = this.createYAMLChannelManifest(buildConfig);
                                Files.write(channelManifestTarget, channelManifest.getBytes(), new OpenOption[0]);
                                if (!this.deployChannelManifest) continue;
                                this.projectHelper.attachArtifact(this.project, "yaml", "manifest", channelManifestTarget.toFile());
                            }
                        }
                        finally {
                            if (artifactStream == null) continue;
                            artifactStream.close();
                        }
                    }
                }
                finally {
                    if (groupStream == null) continue;
                    groupStream.close();
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create a feature-pack archives from the layout", (Exception)e);
        }
    }

    private static String formatIgnoreMessage(String kind, String name, String pkgName) {
        return AbstractFeaturePackBuildMojo.formatMessage(kind, name, pkgName, MSG_PACKAGE_IGNORED);
    }

    private static String formatErrorMessage(String kind, String name, String pkgName) {
        return AbstractFeaturePackBuildMojo.formatMessage(kind, name, pkgName, MSG_PACKAGE_ERROR);
    }

    private static String formatMessage(String kind, String name, String pkgName, String solution) {
        return kind + name + " depends on the package " + pkgName + ". This package has not been included in the feature-pack due to its stability level being lower than the feature-pack minimum stability level." + solution;
    }

    static void checkFeaturePackContentStability(Stability buildTimestabilityLevel, boolean forbidLowerStatibilityLevelPackageReference, Set<String> lowerStabilityPackages, Collection<PackageSpec> packages, Collection<ConfigLayerSpec> layers, Collection<FeatureSpec> features, Map<String, Map<String, ConfigModel>> configs, Log log) throws Exception {
        String message;
        Stability minStability;
        String validForStability;
        for (PackageSpec packageSpec : packages) {
            if (!packageSpec.hasLocalPackageDeps()) continue;
            for (PackageDependencySpec pds : packageSpec.getLocalPackageDeps()) {
                if (!lowerStabilityPackages.contains(pds.getName())) continue;
                validForStability = pds.getValidForStability();
                if (validForStability != null) {
                    minStability = Stability.fromString((String)validForStability);
                    if (buildTimestabilityLevel.enables(minStability)) continue;
                    log.debug((CharSequence)AbstractFeaturePackBuildMojo.formatIgnoreMessage(PACKAGE, packageSpec.getName(), pds.getName()));
                    continue;
                }
                message = AbstractFeaturePackBuildMojo.formatErrorMessage(PACKAGE, packageSpec.getName(), pds.getName());
                if (forbidLowerStatibilityLevelPackageReference) {
                    throw new Exception(message);
                }
                log.warn((CharSequence)message);
            }
        }
        for (ConfigLayerSpec configLayerSpec : layers) {
            if (!configLayerSpec.hasLocalPackageDeps()) continue;
            for (PackageDependencySpec pds : configLayerSpec.getLocalPackageDeps()) {
                if (!lowerStabilityPackages.contains(pds.getName())) continue;
                validForStability = pds.getValidForStability();
                if (validForStability != null) {
                    minStability = Stability.fromString((String)validForStability);
                    if (buildTimestabilityLevel.enables(minStability)) continue;
                    log.debug((CharSequence)AbstractFeaturePackBuildMojo.formatIgnoreMessage(LAYER, configLayerSpec.getName(), pds.getName()));
                    continue;
                }
                message = AbstractFeaturePackBuildMojo.formatErrorMessage(LAYER, configLayerSpec.getName(), pds.getName());
                if (forbidLowerStatibilityLevelPackageReference) {
                    throw new Exception(message);
                }
                log.warn((CharSequence)message);
            }
        }
        for (FeatureSpec featureSpec : features) {
            if (!featureSpec.hasLocalPackageDeps()) continue;
            for (PackageDependencySpec pds : featureSpec.getLocalPackageDeps()) {
                if (!lowerStabilityPackages.contains(pds.getName())) continue;
                validForStability = pds.getValidForStability();
                if (validForStability != null) {
                    minStability = Stability.fromString((String)validForStability);
                    if (buildTimestabilityLevel.enables(minStability)) continue;
                    log.debug((CharSequence)AbstractFeaturePackBuildMojo.formatIgnoreMessage(FEATURE, featureSpec.getName(), pds.getName()));
                    continue;
                }
                message = AbstractFeaturePackBuildMojo.formatErrorMessage(FEATURE, featureSpec.getName(), pds.getName());
                if (forbidLowerStatibilityLevelPackageReference) {
                    throw new Exception(message);
                }
                log.warn((CharSequence)message);
            }
        }
        for (Map.Entry entry : configs.entrySet()) {
            String modelName = (String)entry.getKey();
            for (Map.Entry cm : ((Map)entry.getValue()).entrySet()) {
                ConfigModel config = (ConfigModel)cm.getValue();
                String configName = (String)cm.getKey();
                if (!config.hasLocalPackageDeps()) continue;
                for (PackageDependencySpec pds : config.getLocalPackageDeps()) {
                    if (!lowerStabilityPackages.contains(pds.getName())) continue;
                    String validForStability2 = pds.getValidForStability();
                    if (validForStability2 != null) {
                        Stability minStability2 = Stability.fromString((String)validForStability2);
                        if (buildTimestabilityLevel.enables(minStability2)) continue;
                        log.debug((CharSequence)AbstractFeaturePackBuildMojo.formatIgnoreMessage(CONFIG, modelName + "/" + configName, pds.getName()));
                        continue;
                    }
                    String message2 = AbstractFeaturePackBuildMojo.formatErrorMessage(CONFIG, modelName + "/" + configName, pds.getName());
                    if (forbidLowerStatibilityLevelPackageReference) {
                        throw new Exception(message2);
                    }
                    log.warn((CharSequence)message2);
                }
            }
        }
    }

    String createYAMLChannelManifest(WildFlyFeaturePackBuild buildConfig) throws IOException {
        ArrayList manifestRequirements = new ArrayList();
        if (this.addFeaturePacksAsRequiredManifests && !buildConfig.getDependencies().isEmpty()) {
            for (ArtifactCoords.Gav gav : new TreeSet<ArtifactCoords.Gav>(buildConfig.getDependencies().keySet())) {
                this.project.getDependencies().stream().filter(dep -> gav.getGroupId().equals(dep.getGroupId()) && gav.getArtifactId().equals(dep.getArtifactId()) && "zip".equals(dep.getType())).findFirst().ifPresent(fp -> manifestRequirements.add(new ManifestRequirement(fp.getGroupId() + ":" + fp.getArtifactId(), new MavenCoordinate(fp.getGroupId(), fp.getArtifactId(), fp.getVersion()))));
            }
        }
        List<org.wildfly.channel.Stream> streams = MavenProjectArtifactVersions.getFilteredArtifacts(this.project, buildConfig).stream().filter(a -> !"zip".equals(a.getType()) && !"pom".equals(a.getType())).map(artifact -> new org.wildfly.channel.Stream(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion())).collect(Collectors.toList());
        streams.add(new org.wildfly.channel.Stream(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion()));
        ChannelManifest channelManifest = new ChannelManifest.Builder().setSchemaVersion("1.1.0").setName(String.format("Manifest for %s feature pack.", this.project.getArtifact())).setId(this.project.getGroupId() + ":" + this.project.getArtifactId()).setDescription(String.format("Generated by org.wildfly.galleon-plugins:wildfly-galleon-maven-plugin at %s", Clock.systemUTC().instant())).addManifestRequirements(manifestRequirements.toArray(new ManifestRequirement[0])).addStreams(streams.toArray(new org.wildfly.channel.Stream[0])).build();
        return ChannelManifestMapper.toYaml((ChannelManifest)channelManifest);
    }

    private void addConfigPackages(Path configDir, Path packagesDir, FeaturePackDescription.Builder fpBuilder) throws MojoExecutionException {
        if (!Files.exists(configDir, new LinkOption[0])) {
            return;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(configDir);){
            for (Path configPackage : stream) {
                Path packageDir = packagesDir.resolve(configPackage.getFileName());
                Path packageFile = packageDir.resolve("package.xml");
                Path packageXml = configPackage.resolve("package.xml");
                if (Files.exists(packageXml, new LinkOption[0])) {
                    PackageSpec pkgSpec;
                    try (BufferedReader reader = Files.newBufferedReader(packageXml);){
                        try {
                            pkgSpec = PackageXmlParser.getInstance().parse((Reader)reader);
                        }
                        catch (XMLStreamException e) {
                            throw new MojoExecutionException("Failed to parse " + packageXml, (Exception)e);
                        }
                    }
                    Stability packageStability = pkgSpec.getStability();
                    if (packageStability != null && this.buildTimestabilityLevel != null && !this.buildTimestabilityLevel.enables(packageStability)) {
                        this.getLog().warn((CharSequence)("Package " + pkgSpec.getName() + " is not included in the feature-pack. Package stability '" + packageStability + "' is not enabled by the '" + this.buildTimestabilityLevel + "' stability level that is the feature-pack minimum stability level."));
                        this.lowerStabilityPackages.add(pkgSpec.getName());
                        continue;
                    }
                    fpBuilder.addPackage(pkgSpec);
                }
                if (Files.exists(packageFile, new LinkOption[0]) && Files.exists(packageXml, new LinkOption[0])) {
                    this.warn("File " + packageFile + " already exists, replacing with " + packageXml, new Object[0]);
                }
                if (!Files.exists(packageDir, new LinkOption[0])) {
                    Util.mkdirs(packageDir);
                }
                IoUtils.copy((Path)configPackage, (Path)packageDir);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to process config packages", (Exception)e);
        }
    }

    private void addFeatures(Path configDir, Path featuresDir) throws MojoExecutionException {
        if (!Files.exists(configDir, new LinkOption[0])) {
            return;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(configDir);){
            for (Path configFeature : stream) {
                FeatureSpec featureSpec;
                Path featureDir = featuresDir.resolve(configFeature.getFileName());
                Path featureXml = configFeature.resolve("spec.xml");
                if (!Files.exists(featureXml, new LinkOption[0])) {
                    throw new MojoExecutionException("Feature spec " + featureXml + " doesn't exist ");
                }
                try (BufferedReader reader = Files.newBufferedReader(featureXml);){
                    try {
                        featureSpec = FeatureSpecXmlParser.getInstance().parse((Reader)reader);
                    }
                    catch (XMLStreamException | ProvisioningDescriptionException e) {
                        throw new MojoExecutionException("Failed to parse " + featureXml, (Exception)e);
                    }
                }
                Stability featureStability = featureSpec.getStability();
                if (featureStability != null && this.buildTimestabilityLevel != null && !this.buildTimestabilityLevel.enables(featureStability)) {
                    this.getLog().warn((CharSequence)("Feature " + featureSpec.getName() + " is not included in the feature-pack. Feature stability '" + featureStability + "' is not enabled by the '" + this.buildTimestabilityLevel + "' stability level that is the feature-pack minimum stability level."));
                    continue;
                }
                if (!Files.exists(featureDir, new LinkOption[0])) {
                    Util.mkdirs(featureDir);
                }
                IoUtils.copy((Path)configFeature, (Path)featureDir);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to process feature spec", (Exception)e);
        }
    }

    private void persistExtensions(Path resourcesWildFly, String name, List<String> extensions) throws MojoExecutionException {
        try {
            Files.write(resourcesWildFly.resolve(name), extensions, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to persist " + name, (Exception)e);
        }
    }

    private Properties getFPConfigProperties() throws MojoExecutionException {
        Properties properties = new Properties();
        properties.put("project.version", this.project.getVersion());
        properties.put("version", this.project.getVersion());
        if (this.releaseName != null) {
            properties.put("product.release.name", this.releaseName);
        }
        if (this.taskPropsFile != null) {
            Path p = this.taskPropsFile.toPath();
            if (!Files.exists(p, new LinkOption[0])) {
                throw new MojoExecutionException(Errors.pathDoesNotExist((Path)p));
            }
            try (BufferedReader reader = Files.newBufferedReader(p);){
                properties.load(reader);
            }
            catch (IOException e) {
                throw new MojoExecutionException(Errors.readFile((Path)p), (Exception)e);
            }
        }
        if (!this.taskProps.isEmpty()) {
            properties.putAll(this.taskProps);
        }
        return properties;
    }

    private Properties getWildFlyChannelProperties() throws MojoExecutionException {
        Properties properties = new Properties();
        properties.put("resolution", this.wildflyChannelResolutionMode.toString());
        return properties;
    }

    private void addPlugins(FeaturePackSpec.Builder fpBuilder, Map<String, ArtifactCoords> plugins) throws MojoExecutionException {
        for (Map.Entry<String, ArtifactCoords> entry : plugins.entrySet()) {
            ArtifactCoords coords = entry.getValue();
            if (coords.getVersion() == null) {
                coords = ArtifactCoordsUtil.fromJBossModules(this.resolveVersion(coords.getGroupId() + ":" + coords.getArtifactId()), "jar");
            }
            try {
                this.resolveArtifact(ArtifactCoords.newInstance((String)coords.getGroupId(), (String)coords.getArtifactId(), (String)coords.getVersion(), (String)coords.getExtension()));
            }
            catch (ProvisioningException e) {
                throw new MojoExecutionException("Failed to resolve feature-pack plugin " + coords, (Exception)((Object)e));
            }
            StringBuilder buf = new StringBuilder(128);
            buf.append(coords.getGroupId()).append(':').append(coords.getArtifactId()).append(':');
            String classifier = coords.getClassifier();
            if (classifier != null && !classifier.isEmpty()) {
                buf.append(classifier).append(':');
            }
            buf.append(coords.getExtension()).append(':').append(coords.getVersion());
            fpBuilder.addPlugin(FeaturePackPlugin.getInstance((String)entry.getKey(), (String)buf.toString()));
        }
    }

    protected void processFeaturePackDependencies(WildFlyFeaturePackBuild buildConfig, FeaturePackSpec.Builder fpBuilder) throws Exception {
        if (buildConfig.getDependencies().isEmpty()) {
            return;
        }
        this.fpDependencies = new LinkedHashMap<String, FeaturePackDescription>(buildConfig.getDependencies().size());
        for (Map.Entry<ArtifactCoords.Gav, FeaturePackDependencySpec> depEntry : buildConfig.getDependencies().entrySet()) {
            ArtifactCoords depCoords = depEntry.getKey().toArtifactCoords();
            if (depCoords.getVersion() == null) {
                String coordsStr = this.artifactVersions.getVersion(depCoords.getGroupId() + ":" + depCoords.getArtifactId());
                if (coordsStr == null) {
                    throw new MojoExecutionException("Failed resolve artifact version for " + depCoords);
                }
                depCoords = ArtifactCoordsUtil.fromJBossModules(coordsStr, "zip");
                if (depCoords.getExtension().equals("pom")) {
                    depCoords = new ArtifactCoords(depCoords.getGroupId(), depCoords.getArtifactId(), depCoords.getVersion(), depCoords.getClassifier(), "zip");
                }
            }
            Path depZip = this.resolveArtifact(depCoords);
            FeaturePackDependencySpec depSpec = depEntry.getValue();
            FeaturePackConfig depConfig = depSpec.getTarget();
            FeaturePackDescription fpDescr = FeaturePackDescriber.describeFeaturePackZip((Path)depZip);
            FeaturePackLocation fpl = depEntry.getValue().getTarget().getLocation();
            if (!fpl.isMavenCoordinates()) {
                fpl = fpDescr.getFPID().getLocation();
            } else if (StringUtils.isEmpty((CharSequence)fpl.getBuild())) {
                fpl = fpl.replaceBuild(depCoords.getVersion());
            }
            fpBuilder.addFeaturePackDep(depSpec.getName(), FeaturePackConfig.builder((FeaturePackLocation)fpl).init(depConfig).build());
            this.fpDependencies.put(depSpec.getName(), fpDescr);
        }
    }

    public Path resolveArtifact(ArtifactCoords coords) throws ProvisioningException {
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        buildingRequest.setLocalRepository(this.session.getLocalRepository());
        buildingRequest.setRemoteRepositories(this.project.getRemoteArtifactRepositories());
        try {
            ArtifactResult result = this.artifactResolver.resolveArtifact((ProjectBuildingRequest)buildingRequest, (Artifact)new DefaultArtifact(coords.getGroupId(), coords.getArtifactId(), coords.getVersion(), "provided", coords.getExtension(), coords.getClassifier(), (ArtifactHandler)new DefaultArtifactHandler(coords.getExtension())));
            return result.getArtifact().getFile().toPath();
        }
        catch (ArtifactResolverException e) {
            throw new ProvisioningException(FpMavenErrors.artifactResolution((String)coords.toString()), (Throwable)e);
        }
    }

    protected void handleLayers(Path srcModulesDir, FeaturePackDescription.Builder fpBuilder, Path targetResources, PackageSpec.Builder modulesAll) throws MojoExecutionException {
        Path layersConf;
        Path layersDir = srcModulesDir.resolve("system").resolve("layers");
        if (Files.exists(layersDir, new LinkOption[0])) {
            try (Stream<Path> layers = Files.list(layersDir);){
                HashMap<String, Path> moduleXmlByPkgName = new HashMap<String, Path>();
                Iterator i = layers.iterator();
                while (i.hasNext()) {
                    Path layerDir = (Path)i.next();
                    Util.findModules(layerDir, moduleXmlByPkgName);
                    if (!moduleXmlByPkgName.isEmpty()) continue;
                    throw new MojoExecutionException("Modules not found in " + layerDir);
                }
                this.packageModules(fpBuilder, targetResources, moduleXmlByPkgName, modulesAll);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to process modules content", (Exception)e);
            }
        }
        if (!Files.exists(layersConf = srcModulesDir.resolve("layers.conf"), new LinkOption[0])) {
            return;
        }
        Path targetPath = this.getPackagesDir().resolve("layers.conf").resolve("content").resolve("modules").resolve("layers.conf");
        try {
            Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
            IoUtils.copy((Path)layersConf, (Path)targetPath);
        }
        catch (IOException e) {
            throw new MojoExecutionException(Errors.copyFile((Path)layersConf, (Path)targetPath), (Exception)e);
        }
        PackageSpec.Builder pkgBuilder = PackageSpec.builder((String)"layers.conf");
        this.addPackage(this.getPackagesDir(), fpBuilder, pkgBuilder);
        fpBuilder.getSpecBuilder().addDefaultPackage("layers.conf");
    }

    protected void handleAddOns(Path srcModulesDir, FeaturePackDescription.Builder fpBuilder, Path targetResources, PackageSpec.Builder modulesAll) throws MojoExecutionException {
        HashMap<String, Path> moduleXmlByPkgName = new HashMap<String, Path>();
        Path addOnsDir = srcModulesDir.resolve("system").resolve("add-ons");
        if (Files.exists(addOnsDir, new LinkOption[0])) {
            try (Stream<Path> addOn = Files.list(addOnsDir);){
                Iterator i = addOn.iterator();
                while (i.hasNext()) {
                    Path addOnDir = (Path)i.next();
                    Util.findModules(addOnDir, moduleXmlByPkgName);
                    if (!moduleXmlByPkgName.isEmpty()) continue;
                    throw new MojoExecutionException("Modules not found in " + addOnDir);
                }
                this.packageModules(fpBuilder, targetResources, moduleXmlByPkgName, modulesAll);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to process modules content", (Exception)e);
            }
        }
    }

    protected void handleModules(Path srcModulesDir, FeaturePackDescription.Builder fpBuilder, Path targetResources, PackageSpec.Builder modulesAll) throws MojoExecutionException {
        try {
            HashMap<String, Path> moduleXmlByPkgName = new HashMap<String, Path>();
            Util.findModules(srcModulesDir, moduleXmlByPkgName);
            this.packageModules(fpBuilder, targetResources, moduleXmlByPkgName, modulesAll);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to process modules content", (Exception)e);
        }
    }

    protected PackageSpec addPackage(Path fpPackagesDir, FeaturePackDescription.Builder fpBuilder, PackageSpec.Builder pkgBuilder) throws MojoExecutionException {
        PackageSpec pkg = pkgBuilder.build();
        fpBuilder.addPackage(pkg);
        this.writeXml(pkg, fpPackagesDir.resolve(pkg.getName()));
        return pkg;
    }

    private void writeXml(PackageSpec pkgSpec, Path dir) throws MojoExecutionException {
        try {
            Util.mkdirs(dir);
            PackageXmlWriter.getInstance().write((Object)pkgSpec, dir.resolve("package.xml"));
        }
        catch (IOException | XMLStreamException e) {
            throw new MojoExecutionException(Errors.writeFile((Path)dir.resolve("package.xml")), e);
        }
    }

    private void packageModules(FeaturePackDescription.Builder fpBuilder, Path resourcesDir, Map<String, Path> moduleXmlByPkgName, PackageSpec.Builder modulesAll) throws IOException, MojoExecutionException {
        HashMap<ModuleIdentifier, Set<ModuleIdentifier>> targetToAlias = new HashMap<ModuleIdentifier, Set<ModuleIdentifier>>();
        for (Map.Entry<String, Path> module : moduleXmlByPkgName.entrySet()) {
            try {
                ModuleXmlParser.populateAlias(module.getValue(), "UTF-8", targetToAlias);
            }
            catch (ParsingException e) {
                throw new IOException(Errors.parseXml((Path)module.getValue()), e);
            }
        }
        for (Map.Entry<String, Path> module : moduleXmlByPkgName.entrySet()) {
            String packageName = module.getKey();
            Path moduleXml = module.getValue();
            Path packageDir = this.getPackagesDir().resolve(packageName);
            PackageSpec.Builder pkgSpecBuilder = PackageSpec.builder((String)packageName);
            try {
                ModuleParseResult parsedModule = ModuleXmlParser.parse(moduleXml, "UTF-8", targetToAlias);
                String packageStability = parsedModule.getProperty("jboss.stability");
                if (packageStability != null) {
                    Stability stab = Stability.fromString((String)packageStability);
                    if (this.buildTimestabilityLevel != null && !this.buildTimestabilityLevel.enables(stab)) {
                        this.getLog().warn((CharSequence)("JBoss Modules module " + parsedModule.getIdentifier() + " is not included in the feature-pack. Package stability '" + packageStability + "' is not enabled by the '" + this.buildTimestabilityLevel + "' stability level that is the feature-pack minimum stability level."));
                        this.lowerStabilityPackages.add(packageName);
                        continue;
                    }
                    pkgSpecBuilder.setStability(stab);
                }
                Path targetXml = packageDir.resolve("pm").resolve("wildfly").resolve("module").resolve(resourcesDir.relativize(moduleXml));
                Util.mkdirs(targetXml.getParent());
                IoUtils.copy((Path)moduleXml.getParent(), (Path)targetXml.getParent());
                if (!parsedModule.dependencies.isEmpty()) {
                    for (ModuleParseResult.ModuleDependency moduleDep : parsedModule.dependencies) {
                        ModuleIdentifier moduleId = moduleDep.getModuleId();
                        Object depName = moduleId.getName();
                        if (!moduleId.getSlot().equals("main")) {
                            depName = (String)depName + "." + moduleId.getSlot();
                        }
                        if (moduleXmlByPkgName.containsKey(depName)) {
                            PackageDependencySpec spec = AbstractFeaturePackBuildMojo.getPackageDepSpec(packageName, moduleXml, moduleDep, (String)depName);
                            if (spec.isOptional()) continue;
                            pkgSpecBuilder.addPackageDep(spec);
                            continue;
                        }
                        Map.Entry<String, FeaturePackDescription> depSrc = null;
                        if (!this.fpDependencies.isEmpty()) {
                            Set alternativeSrc = Collections.emptySet();
                            for (Map.Entry<String, FeaturePackDescription> depEntry : this.fpDependencies.entrySet()) {
                                if (!depEntry.getValue().hasPackage((String)depName)) continue;
                                if (depSrc != null) {
                                    alternativeSrc = CollectionUtils.add(alternativeSrc, (Object)depSrc.getKey());
                                }
                                depSrc = depEntry;
                            }
                            if (!alternativeSrc.isEmpty()) {
                                StringBuilder warn = new StringBuilder();
                                warn.append("Package ").append((String)depName).append(" from ").append(depSrc.getKey()).append(" picked as dependency of ").append(packageName).append(" although ").append((String)depName).append(" also exists in ");
                                org.jboss.galleon.util.StringUtils.append((StringBuilder)warn, (Iterable)alternativeSrc);
                                this.getLog().warn((CharSequence)warn);
                            }
                        }
                        if (depSrc != null) {
                            PackageDependencySpec spec = AbstractFeaturePackBuildMojo.getPackageDepSpec(packageName, moduleXml, moduleDep, (String)depName);
                            if (spec.isOptional()) continue;
                            pkgSpecBuilder.addPackageDep((String)depSrc.getKey(), spec);
                            continue;
                        }
                        if (moduleDep.isOptional() || AbstractFeaturePackBuildMojo.isProvided((String)depName)) continue;
                        throw new MojoExecutionException("Package " + packageName + " has unsatisifed external dependency on package " + (String)depName);
                    }
                }
            }
            catch (ParsingException e) {
                throw new IOException(Errors.parseXml((Path)moduleXml), e);
            }
            PackageSpec pkgSpec = pkgSpecBuilder.build();
            try {
                PackageXmlWriter.getInstance().write((Object)pkgSpec, packageDir.resolve("package.xml"));
            }
            catch (XMLStreamException e) {
                throw new IOException(Errors.writeFile((Path)packageDir.resolve("package.xml")), e);
            }
            if (modulesAll != null) {
                modulesAll.addPackageDep(packageName, true);
            }
            fpBuilder.addPackage(pkgSpec);
        }
    }

    private static PackageDependencySpec getPackageDepSpec(String packageName, Path moduleXml, ModuleParseResult.ModuleDependency moduleDep, String depName) throws ParsingException {
        PackageDependencySpec depSpec;
        String passiveValue = moduleDep.getProperty("galleon.passive");
        if (passiveValue != null && Boolean.parseBoolean(passiveValue)) {
            if (!moduleDep.isOptional()) {
                throw new ParsingException("Required dependency on module " + packageName + " cannot be annotated as galleon.passive in " + moduleXml);
            }
            depSpec = PackageDependencySpec.passive((String)depName);
        } else {
            depSpec = moduleDep.isOptional() ? PackageDependencySpec.optional((String)depName) : PackageDependencySpec.required((String)depName);
        }
        return depSpec;
    }

    protected void debug(String msg, Object ... args) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)String.format(msg, args));
        }
    }

    protected void warn(String msg, Object ... args) {
        if (this.getLog().isWarnEnabled()) {
            this.getLog().warn((CharSequence)String.format(msg, args));
        }
    }

    private void buildArtifactList(ArtifactListBuilder builder) throws MojoExecutionException {
        try {
            MavenProjectArtifactVersions projectArtifacts = MavenProjectArtifactVersions.getInstance(this.project);
            TreeSet<String> allArtifacts = new TreeSet<String>();
            this.addHardCodedArtifacts(allArtifacts);
            allArtifacts.addAll(projectArtifacts.getArtifacts().values());
            for (String artifact : allArtifacts) {
                ArtifactCoords coords = ArtifactCoordsUtil.fromJBossModules(artifact, null);
                builder.add(coords);
            }
        }
        catch (IOException | ArtifactDescriptorException | ProvisioningException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
    }

    private void addHardCodedArtifacts(Set<String> all) throws IOException {
        Path projectModules;
        Path packages = this.resourcesDir.resolve("packages");
        if (Files.exists(packages, new LinkOption[0])) {
            this.processPackages(this.fpDir, all);
        }
        if (Files.exists(projectModules = this.resourcesDir.resolve("modules"), new LinkOption[0])) {
            this.addHardCodedArtifacts(projectModules, all);
        }
    }

    private void processPackages(Path fpDirectory, final Set<String> all) throws IOException {
        Files.walkFileTree(fpDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (dir.endsWith(FeatureSpecGeneratorInvoker.MODULE_PATH_SEGMENT)) {
                    AbstractFeaturePackBuildMojo.this.addHardCodedArtifacts(dir, all);
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void addHardCodedArtifacts(Path source, final Set<String> all) throws IOException {
        Files.walkFileTree(source, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if ("module.xml".equals(file.getFileName().toString())) {
                    try {
                        ModuleXmlVersionResolver.addHardCodedArtifacts(file, (Set<String>)all);
                    }
                    catch (XMLStreamException ex) {
                        throw new IOException("Error while reading " + file, ex);
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

