/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.maven;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.codec.binary.Hex;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.maven.plugin.util.MavenArtifactRepositoryManager;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.wildfly.galleon.plugin.ArtifactCoords;

public class ArtifactListBuilder {
    private static final XMLInputFactory XML_INPUT_FACTORY = XMLInputFactory.newInstance();
    private final Path localMvnRepoPath;
    private final Map<String, String> map = new TreeMap<String, String>();
    private final MessageDigest md;
    private final MavenArtifactRepositoryManager artifactResolver;
    private final Log log;

    public ArtifactListBuilder(MavenArtifactRepositoryManager artifactResolver, Path localMvnRepoPath, Log log) {
        this.localMvnRepoPath = localMvnRepoPath;
        this.artifactResolver = artifactResolver;
        this.log = log;
        try {
            this.md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    Path resolveArtifact(ArtifactCoords coords) throws ProvisioningException {
        MavenArtifact artifact = new MavenArtifact();
        artifact.setArtifactId(coords.getArtifactId());
        artifact.setGroupId(coords.getGroupId());
        artifact.setVersion(coords.getVersion());
        artifact.setClassifier(coords.getClassifier());
        artifact.setExtension(coords.getExtension());
        this.artifactResolver.resolve(artifact);
        return artifact.getPath();
    }

    private String checksum(String filepath) throws IOException {
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(filepath));){
            int count;
            byte[] buffer = new byte[8192];
            while ((count = bis.read(buffer)) > 0) {
                this.md.update(buffer, 0, count);
            }
        }
        byte[] hash = this.md.digest();
        return Hex.encodeHexString((byte[])hash);
    }

    public Path add(ArtifactCoords coords) throws ProvisioningException, ArtifactDescriptorException, IOException {
        this.debug("Add artifact %s:%s:%s", coords.getGroupId(), coords.getArtifactId(), coords.getVersion());
        Path artifactLocalPath = this.resolveArtifact(coords);
        ArtifactCoords pomFileCoords = new ArtifactCoords(coords.getGroupId(), coords.getArtifactId(), coords.getVersion(), null, "pom");
        Path pomFile = this.resolveArtifact(pomFileCoords);
        Model model = null;
        try {
            model = ArtifactListBuilder.readModel(pomFile);
        }
        catch (Throwable ex) {
            throw new ProvisioningException("Exception while reading model for " + coords + ". Resolved pom file " + pomFile, ex);
        }
        Parent artifactParent = model.getParent();
        if (artifactParent != null) {
            ArtifactCoords parentCoords = new ArtifactCoords(artifactParent.getGroupId(), artifactParent.getArtifactId(), artifactParent.getVersion(), null, "pom");
            this.add(parentCoords);
        }
        this.addArtifact(artifactLocalPath);
        this.addArtifact(pomFile);
        return artifactLocalPath;
    }

    private static Model readModel(Path pomXml) throws IOException {
        Model model;
        block8: {
            BufferedReader reader = Files.newBufferedReader(pomXml, ArtifactListBuilder.getEncoding(pomXml));
            try {
                MavenXpp3Reader xpp3Reader = new MavenXpp3Reader();
                Model model2 = xpp3Reader.read((Reader)reader);
                model2.setPomFile(pomXml.toFile());
                model = model2;
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (XmlPullParserException ex) {
                    throw new IOException("Failed to parse artifact POM model", ex);
                }
            }
            reader.close();
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Charset getEncoding(Path pomXml) throws IOException {
        Charset charset = StandardCharsets.UTF_8;
        try (FileReader fileReader = new FileReader(pomXml.toFile());
             XMLStreamReader xmlReader = XML_INPUT_FACTORY.createXMLStreamReader(fileReader);){
            String encoding = xmlReader.getCharacterEncodingScheme();
            if (encoding != null) {
                charset = Charset.forName(encoding);
            }
        }
        catch (XMLStreamException ex) {
            throw new IOException("Failed to retrieve encoding for " + pomXml, ex);
        }
        return charset;
    }

    public String build() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            builder.append(entry.getValue()).append(",").append(entry.getKey()).append(System.lineSeparator());
        }
        return builder.toString();
    }

    protected Map<String, String> getMap() {
        return this.map;
    }

    private void addArtifact(Path artifactLocalPath) {
        Path relativized = this.localMvnRepoPath.relativize(artifactLocalPath);
        try {
            this.map.put("/" + relativized.toString(), this.checksum(artifactLocalPath.toString()));
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't add " + artifactLocalPath + " to offliner file", ex);
        }
    }

    private void debug(String msg, Object ... args) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)String.format(msg, args));
        }
    }
}

