/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.maven;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.jboss.galleon.spec.PackageSpec;
import org.jboss.galleon.xml.PackageXmlWriter;

@Mojo(name="generate-shaded-descriptor", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class ShadedJARModelGeneratorMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.directory}", readonly=true, required=true)
    String projectBuildDir;
    @Parameter(alias="main-class")
    String mainClass;
    @Parameter
    Map<String, String> manifestEntries;
    @Component
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Object classes;
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        if (!"pom".equals(this.project.getArtifact().getType()) && Files.exists((Path)(classes = Paths.get(this.project.getBuild().getOutputDirectory(), new String[0])), new LinkOption[0])) {
            artifacts.add(this.project.getArtifact());
        }
        for (Artifact artifact : this.project.getArtifacts()) {
            if ("test-jar".equals(artifact.getType()) || "system".equals(artifact.getScope())) continue;
            artifacts.add(artifact);
        }
        try {
            String pkgName = this.project.getGroupId() + "." + this.project.getArtifactId() + ".shaded";
            Path pkg = Paths.get(this.projectBuildDir, new String[0]).resolve("resources").resolve("packages").resolve(pkgName);
            Files.createDirectories(pkg, new FileAttribute[0]);
            Path pkgContent = pkg.resolve("pm").resolve("wildfly").resolve("shaded");
            Files.createDirectories(pkgContent, new FileAttribute[0]);
            Path xmlFile = pkgContent.resolve("shaded-model.xml");
            Files.write(xmlFile, ShadedJARModelGeneratorMojo.getXMLContent(this.project.getName(), artifacts, this.mainClass, this.manifestEntries).getBytes(), new OpenOption[0]);
            PackageSpec spec = PackageSpec.builder().setName(pkgName).build();
            Path pkgFile = pkg.resolve("package.xml");
            PackageXmlWriter.getInstance().write((Object)spec, pkgFile);
        }
        catch (IOException | XMLStreamException ex) {
            throw new MojoExecutionException(ex.getLocalizedMessage(), ex);
        }
    }

    public static String getXMLContent(String name, List<Artifact> artifacts, String mainClass, Map<String, String> manifestEntries) {
        StringBuilder builder = new StringBuilder();
        builder.append("<shaded-model>").append(System.lineSeparator());
        builder.append("<name>").append(name).append("</name>").append(System.lineSeparator());
        builder.append("<shaded-dependencies>").append(System.lineSeparator());
        for (Artifact artifact : artifacts) {
            builder.append(ShadedJARModelGeneratorMojo.getDependency(artifact)).append(System.lineSeparator());
        }
        builder.append("</shaded-dependencies>").append(System.lineSeparator());
        if (mainClass != null) {
            builder.append("<main-class>");
            builder.append(mainClass);
            builder.append("</main-class>").append(System.lineSeparator());
        }
        if (manifestEntries != null) {
            builder.append("<manifestEntries>").append(System.lineSeparator());
            for (Map.Entry entry : manifestEntries.entrySet()) {
                builder.append("<" + (String)entry.getKey() + ">");
                builder.append((String)entry.getValue());
                builder.append("</" + (String)entry.getKey() + ">").append(System.lineSeparator());
            }
            builder.append("</manifestEntries>").append(System.lineSeparator());
        }
        builder.append("</shaded-model>").append(System.lineSeparator());
        return builder.toString();
    }

    private static String getDependency(Artifact a) {
        StringBuilder builder = new StringBuilder();
        builder.append("<dependency>");
        builder.append(a.getGroupId()).append(":");
        builder.append(a.getArtifactId()).append(":").append(":");
        if (a.getClassifier() != null && !a.getClassifier().isEmpty()) {
            builder.append(a.getClassifier());
        }
        builder.append(":");
        builder.append(a.getType());
        builder.append("</dependency>").append(System.lineSeparator());
        return builder.toString();
    }
}

