/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.layout.FeaturePackDescriber;
import org.jboss.galleon.layout.FeaturePackDescription;
import org.jboss.galleon.spec.FeaturePackSpec;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.ZipUtils;
import org.wildfly.galleon.maven.AbstractFeaturePackBuildMojo;
import org.wildfly.galleon.maven.FeaturePackDependencySpec;
import org.wildfly.galleon.maven.Util;
import org.wildfly.galleon.maven.WildFlyFeaturePackBuild;
import org.wildfly.galleon.plugin.ArtifactCoords;

@Mojo(name="build-user-feature-pack", requiresDependencyResolution=ResolutionScope.RUNTIME, defaultPhase=LifecyclePhase.COMPILE)
public class UserFeaturePackBuildMojo
extends AbstractFeaturePackBuildMojo {
    private static final String WILDFLY_GALLEON_PACK_PREFIX = "wildfly-";
    private static final String WILDFLY_GALLEON_PACK_SUFFIX = "galleon-pack";
    private static final String FEATURE_PACK_LAYOUT = "user-feature-pack-layout";
    @Parameter(alias="config-file", defaultValue="wildfly-user-feature-pack-build.xml", property="wildfly.user.feature.pack.configFile")
    private String configFile;
    @Parameter(alias="config-dir", defaultValue="${basedir}", property="wildfly.user.feature.pack.configDir")
    private File configDir;
    @Parameter(alias="resources-dir", defaultValue="src/main/resources", property="wildfly.user.feature.pack.resourcesDir", required=true)
    private String resourcesDir;
    @Parameter(defaultValue="${project.build.directory}", property="wildfly.user.feature.pack.buildName")
    private String buildName;
    @Parameter(alias="feature-pack-location", defaultValue="${project.groupId}:${project.artifactId}:${project.version}", required=false)
    private String fpLocation;
    @Parameter(alias="translate-to-fpl", defaultValue="false", required=false)
    private Boolean translateToFpl;
    private WildFlyFeaturePackBuild buildConfig;
    private boolean generate;

    @Override
    protected String getPackaging() {
        return "galleon-user-feature-pack";
    }

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        Path resources = this.configDir.getAbsoluteFile().toPath().resolve(this.resourcesDir);
        this.setupDirs(this.buildName, this.project.getArtifactId(), FEATURE_PACK_LAYOUT, resources);
        this.buildConfig = this.getBuildConfig();
        this.setStability(this.buildConfig);
        FeaturePackLocation fpl = this.buildConfig.getProducer();
        if (!(this.generate || fpl.hasBuild() || fpl.hasUniverse())) {
            fpl = FeaturePackLocation.fromString((String)(fpl.toString() + ":" + this.project.getVersion()));
        }
        FeaturePackDescription.Builder fpBuilder = FeaturePackDescription.builder((FeaturePackSpec.Builder)FeaturePackSpec.builder((FeaturePackLocation.FPID)fpl.getFPID()));
        for (String defaultPackage : this.buildConfig.getDefaultPackages()) {
            fpBuilder.getSpecBuilder().addDefaultPackage(defaultPackage);
        }
        try {
            this.processFeaturePackDependencies(this.buildConfig, fpBuilder.getSpecBuilder());
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to process dependencies", e);
        }
        Path srcModulesDir = resources.resolve("modules");
        if (Files.exists(srcModulesDir, new LinkOption[0])) {
            this.addModulePackages(srcModulesDir, fpBuilder, resources);
        }
        this.buildFeaturePack(fpBuilder, this.buildConfig);
    }

    private void addModulePackages(Path srcModulesDir, FeaturePackDescription.Builder fpBuilder, Path targetResources) throws MojoExecutionException {
        this.debug("UserFeaturePackBuildMojo adding module packages", new Object[0]);
        this.handleLayers(srcModulesDir, fpBuilder, targetResources, null);
        this.handleAddOns(srcModulesDir, fpBuilder, targetResources, null);
        this.handleModules(srcModulesDir, fpBuilder, targetResources, null);
    }

    private WildFlyFeaturePackBuild getBuildConfig() throws MojoExecutionException {
        if (this.buildConfig == null) {
            Path path = Paths.get(this.configDir.getAbsolutePath(), this.configFile);
            this.buildConfig = Files.exists(path, new LinkOption[0]) ? Util.loadFeaturePackBuildConfig(path) : this.generateConfig();
        }
        return this.buildConfig;
    }

    private WildFlyFeaturePackBuild generateConfig() throws MojoExecutionException {
        org.apache.maven.artifact.Artifact a;
        FeaturePackConfig.Builder depBuilder;
        this.generate = true;
        if (this.fpLocation == null) {
            throw new MojoExecutionException("No feature-pack-location set");
        }
        WildFlyFeaturePackBuild.Builder builder = WildFlyFeaturePackBuild.builder();
        builder.setProducer(FeaturePackLocation.fromString((String)this.fpLocation));
        Map<FeaturePackLocation, Artifact> directs = this.retrieveDirectDependencies();
        if (directs.isEmpty()) {
            throw new MojoExecutionException("No dependency on WildFly feature-pack retrieved. WildFly feature-pack must be a dependency of the project.");
        }
        Map<FeaturePackLocation, org.apache.maven.artifact.Artifact> transitives = this.retrieveTransitiveDependencies(directs.keySet());
        for (Map.Entry<FeaturePackLocation, Artifact> entry : directs.entrySet()) {
            depBuilder = FeaturePackConfig.builder((FeaturePackLocation)entry.getKey());
            depBuilder.setInheritConfigs(false);
            depBuilder.setInheritPackages(false);
            a = entry.getValue();
            this.debug("Adding %s:%s dependency", a.getGroupId(), a.getArtifactId());
            builder.addDependency(ArtifactCoords.newGav((String)a.getGroupId(), (String)a.getArtifactId(), null), FeaturePackDependencySpec.create(a.getGroupId() + ":" + a.getArtifactId(), depBuilder.build()));
        }
        for (Map.Entry<FeaturePackLocation, Artifact> entry : transitives.entrySet()) {
            depBuilder = FeaturePackConfig.transitiveBuilder((FeaturePackLocation)entry.getKey());
            a = (org.apache.maven.artifact.Artifact)entry.getValue();
            this.debug("Adding %s:%s transitive dependency", a.getGroupId(), a.getArtifactId());
            builder.addDependency(ArtifactCoords.newGav((String)a.getGroupId(), (String)a.getArtifactId(), null), FeaturePackDependencySpec.create(a.getGroupId() + ":" + a.getArtifactId(), depBuilder.build()));
        }
        return builder.build();
    }

    private Map<FeaturePackLocation, Artifact> retrieveDirectDependencies() {
        HashMap<FeaturePackLocation, Artifact> directs = new HashMap<FeaturePackLocation, Artifact>();
        ArtifactDescriptorRequest descrReq = new ArtifactDescriptorRequest();
        descrReq.setArtifact((Artifact)new DefaultArtifact(this.project.getGroupId(), this.project.getArtifactId(), null, this.project.getVersion()));
        try {
            ArtifactDescriptorResult res = this.repoSystem.readArtifactDescriptor(this.session.getRepositorySession(), descrReq);
            for (Dependency d : res.getDependencies()) {
                FeaturePackLocation fpl = this.getFeaturePackLocation(d.getArtifact().getGroupId(), d.getArtifact().getArtifactId(), d.getArtifact().getVersion(), d.getArtifact().getExtension(), d.getScope());
                if (fpl == null) continue;
                directs.put(fpl, d.getArtifact());
            }
        }
        catch (IOException | ArtifactDescriptorException | ProvisioningException ex) {
            throw new RuntimeException(ex);
        }
        return directs;
    }

    private Map<FeaturePackLocation, org.apache.maven.artifact.Artifact> retrieveTransitiveDependencies(Set<FeaturePackLocation> directs) {
        HashMap<FeaturePackLocation, org.apache.maven.artifact.Artifact> transitives = new HashMap<FeaturePackLocation, org.apache.maven.artifact.Artifact>();
        try {
            for (org.apache.maven.artifact.Artifact a : this.project.getArtifacts()) {
                FeaturePackLocation fpl = this.getFeaturePackLocation(a.getGroupId(), a.getArtifactId(), a.getVersion(), a.getType(), a.getScope());
                if (fpl == null || directs.contains(fpl)) continue;
                transitives.put(fpl, a);
            }
        }
        catch (IOException | ProvisioningException ex) {
            throw new RuntimeException(ex);
        }
        return transitives;
    }

    private FeaturePackLocation getFeaturePackLocation(String groupId, String artifactId, String version, String ext, String scope) throws IOException, ProvisioningException {
        FeaturePackLocation fpl = null;
        if (artifactId.startsWith(WILDFLY_GALLEON_PACK_PREFIX) && artifactId.endsWith(WILDFLY_GALLEON_PACK_SUFFIX) && ext.equals("zip") && !"test".equals(scope) && !"system".equals(scope)) {
            Path fp = this.resolveArtifact(new ArtifactCoords(groupId, artifactId, version, null, "zip"));
            try (FileSystem fs = ZipUtils.newFileSystem((Path)fp);){
                if (Files.exists(fs.getPath("feature-pack.xml", new String[0]), new LinkOption[0])) {
                    fpl = this.translateToFpl.booleanValue() ? FeaturePackDescriber.readSpec((Path)fp).getFPID().getLocation() : FeaturePackLocation.fromString((String)(groupId + ":" + artifactId + ":" + version));
                }
            }
        }
        return fpl;
    }
}

