/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.maven;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.config.ConfigCustomizationsBuilder;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.galleon1.LegacyGalleon1Universe;
import org.jboss.galleon.util.ParsingUtils;
import org.jboss.galleon.xml.ConfigXml;
import org.jboss.galleon.xml.FeaturePackPackagesConfigParser10;
import org.jboss.galleon.xml.ProvisioningXmlParser30;
import org.jboss.galleon.xml.XmlNameProvider;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.galleon.maven.FeaturePackDependencySpec;
import org.wildfly.galleon.maven.WildFlyFeaturePackBuild;
import org.wildfly.galleon.plugin.ArtifactCoords;

class FeaturePackBuildModelParser20
implements XMLElementReader<WildFlyFeaturePackBuild.Builder> {
    public static final String NAMESPACE_2_0 = "urn:wildfly:feature-pack-build:2.0";

    FeaturePackBuildModelParser20() {
    }

    public void readElement(XMLExtendedStreamReader reader, WildFlyFeaturePackBuild.Builder builder) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.noneOf(Attribute.class);
        int count = reader.getAttributeCount();
        if (count != 0) {
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), required);
        }
        block12: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element.ordinal()) {
                        case 4: {
                            this.parseDependencies(reader, builder);
                            continue block12;
                        }
                        case 3: {
                            this.parseDefaultPackages((XMLStreamReader)reader, builder);
                            continue block12;
                        }
                        case 10: {
                            this.parsePackageSchemas((XMLStreamReader)reader, builder);
                            continue block12;
                        }
                        case 1: {
                            ConfigModel.Builder config = ConfigModel.builder();
                            ConfigXml.readConfig((XMLExtendedStreamReader)reader, (ConfigModel.Builder)config);
                            try {
                                builder.addConfig(config.build());
                                continue block12;
                            }
                            catch (ProvisioningDescriptionException e) {
                                throw new XMLStreamException("Failed to create a config model instance", e);
                            }
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void parseDefaultPackages(XMLStreamReader reader, WildFlyFeaturePackBuild.Builder builder) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element.ordinal()) {
                        case 8: {
                            builder.addDefaultPackage(this.parseName(reader));
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void parseDependencies(XMLExtendedStreamReader reader, WildFlyFeaturePackBuild.Builder builder) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element.ordinal()) {
                        case 5: {
                            this.parseDependency(reader, builder);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private void parseDependency(XMLExtendedStreamReader reader, WildFlyFeaturePackBuild.Builder builder) throws XMLStreamException {
        String groupId = null;
        String artifactId = null;
        String version = null;
        int count = reader.getAttributeCount();
        EnumSet<Attribute> required = EnumSet.of(Attribute.GROUP_ID, Attribute.ARTIFACT_ID);
        block19: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute.ordinal()) {
                case 1: {
                    groupId = reader.getAttributeValue(i);
                    continue block19;
                }
                case 0: {
                    artifactId = reader.getAttributeValue(i);
                    continue block19;
                }
                case 3: {
                    version = reader.getAttributeValue(i);
                    continue block19;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), required);
        }
        String depName = null;
        FeaturePackConfig.Builder depBuilder = FeaturePackConfig.builder((FeaturePackLocation)LegacyGalleon1Universe.toFpl(groupId, artifactId, version));
        block20: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    builder.addDependency(ArtifactCoords.newGav((String)groupId, (String)artifactId, (String)version), FeaturePackDependencySpec.create(depName, depBuilder.build()));
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element.ordinal()) {
                        case 7: {
                            depName = reader.getElementText().trim();
                            continue block20;
                        }
                        case 2: {
                            ProvisioningXmlParser30.parseDefaultConfigs((XMLExtendedStreamReader)reader, (ConfigCustomizationsBuilder)depBuilder);
                            continue block20;
                        }
                        case 1: {
                            ConfigModel.Builder configBuilder = ConfigModel.builder();
                            ConfigXml.readConfig((XMLExtendedStreamReader)reader, (ConfigModel.Builder)configBuilder);
                            try {
                                depBuilder.addConfig(configBuilder.build());
                                continue block20;
                            }
                            catch (ProvisioningDescriptionException e) {
                                throw new XMLStreamException(e);
                            }
                        }
                        case 9: {
                            try {
                                FeaturePackPackagesConfigParser10.readPackages((XMLStreamReader)reader, (FeaturePackConfig.Builder)depBuilder);
                                continue block20;
                            }
                            catch (ProvisioningDescriptionException e) {
                                throw new XMLStreamException(e);
                            }
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
    }

    private String parseName(XMLStreamReader reader) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute.ordinal()) {
                case 2: {
                    name = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), required);
        }
        ParsingUtils.parseNoContent((XMLStreamReader)reader);
        return name;
    }

    private void parsePackageSchemas(XMLStreamReader reader, WildFlyFeaturePackBuild.Builder builder) throws XMLStreamException {
        ParsingUtils.parseNoAttributes((XMLStreamReader)reader);
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element.ordinal()) {
                        case 6: {
                            builder.addSchemaGroup(this.parseName(reader));
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    static enum Attribute implements XmlNameProvider
    {
        ARTIFACT_ID("artifact-id"),
        GROUP_ID("group-id"),
        NAME("name"),
        VERSION("version"),
        UNKNOWN(null);

        private static final Map<QName, Attribute> attributes;
        private final String name;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public String getNamespace() {
            return null;
        }

        static {
            HashMap<QName, Attribute> attributesMap = new HashMap<QName, Attribute>(4);
            attributesMap.put(new QName(ARTIFACT_ID.getLocalName()), ARTIFACT_ID);
            attributesMap.put(new QName(GROUP_ID.getLocalName()), GROUP_ID);
            attributesMap.put(new QName(NAME.getLocalName()), NAME);
            attributesMap.put(new QName(VERSION.getLocalName()), VERSION);
            attributes = attributesMap;
        }
    }

    static enum Element {
        BUILD("build"),
        CONFIG("config"),
        DEFAULT_CONFIGS("default-configs"),
        DEFAULT_PACKAGES("default-packages"),
        DEPENDENCIES("dependencies"),
        DEPENDENCY("dependency"),
        GROUP("group"),
        NAME("name"),
        PACKAGE("package"),
        PACKAGES("packages"),
        PACKAGE_SCHEMAS("package-schemas"),
        UNKNOWN(null);

        private static final Map<QName, Element> elements;
        private final String name;

        static Element of(QName qName) {
            QName name = qName.getNamespaceURI().equals("") ? new QName(FeaturePackBuildModelParser20.NAMESPACE_2_0, qName.getLocalPart()) : qName;
            Element element = elements.get(name);
            return element == null ? UNKNOWN : element;
        }

        private Element(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        static {
            HashMap<QName, Element> elementsMap = new HashMap<QName, Element>(11);
            elementsMap.put(new QName(FeaturePackBuildModelParser20.NAMESPACE_2_0, BUILD.getLocalName()), BUILD);
            elementsMap.put(new QName(FeaturePackBuildModelParser20.NAMESPACE_2_0, CONFIG.getLocalName()), CONFIG);
            elementsMap.put(new QName(FeaturePackBuildModelParser20.NAMESPACE_2_0, DEFAULT_CONFIGS.getLocalName()), DEFAULT_CONFIGS);
            elementsMap.put(new QName(FeaturePackBuildModelParser20.NAMESPACE_2_0, DEFAULT_PACKAGES.getLocalName()), DEFAULT_PACKAGES);
            elementsMap.put(new QName(FeaturePackBuildModelParser20.NAMESPACE_2_0, DEPENDENCIES.getLocalName()), DEPENDENCIES);
            elementsMap.put(new QName(FeaturePackBuildModelParser20.NAMESPACE_2_0, DEPENDENCY.getLocalName()), DEPENDENCY);
            elementsMap.put(new QName(FeaturePackBuildModelParser20.NAMESPACE_2_0, GROUP.getLocalName()), GROUP);
            elementsMap.put(new QName(FeaturePackBuildModelParser20.NAMESPACE_2_0, NAME.getLocalName()), NAME);
            elementsMap.put(new QName(FeaturePackBuildModelParser20.NAMESPACE_2_0, PACKAGE.getLocalName()), PACKAGE);
            elementsMap.put(new QName(FeaturePackBuildModelParser20.NAMESPACE_2_0, PACKAGES.getLocalName()), PACKAGES);
            elementsMap.put(new QName(FeaturePackBuildModelParser20.NAMESPACE_2_0, PACKAGE_SCHEMAS.getLocalName()), PACKAGE_SCHEMAS);
            elements = elementsMap;
        }
    }
}

