/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.maven;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.config.ConfigCustomizationsBuilder;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.galleon1.LegacyGalleon1Universe;
import org.jboss.galleon.util.ParsingUtils;
import org.jboss.galleon.xml.ConfigXml;
import org.jboss.galleon.xml.FeaturePackPackagesConfigParser10;
import org.jboss.galleon.xml.ProvisioningXmlParser30;
import org.jboss.galleon.xml.XmlNameProvider;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.galleon.maven.ArtifactCoordsUtil;
import org.wildfly.galleon.maven.FeaturePackDependencySpec;
import org.wildfly.galleon.maven.WildFlyFeaturePackBuild;
import org.wildfly.galleon.maven.build.tasks.CopyResourcesTask;
import org.wildfly.galleon.plugin.ArtifactCoords;

class FeaturePackBuildModelParser31
implements XMLElementReader<WildFlyFeaturePackBuild.Builder> {
    public static final String NAMESPACE = "urn:wildfly:feature-pack-build:3.1";

    FeaturePackBuildModelParser31() {
    }

    public void readElement(XMLExtendedStreamReader reader, WildFlyFeaturePackBuild.Builder builder) throws XMLStreamException {
        FeaturePackLocation fpl = null;
        int count = reader.getAttributeCount();
        block19: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute.ordinal()) {
                case 5: {
                    fpl = FeaturePackLocation.fromString((String)reader.getAttributeValue(i));
                    continue block19;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (fpl == null) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), Collections.singleton(Attribute.PRODUCER));
        }
        builder.setProducer(fpl);
        block20: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element.ordinal()) {
                        case 5: {
                            FeaturePackBuildModelParser31.parseDependencies(reader, builder);
                            continue block20;
                        }
                        case 4: {
                            FeaturePackBuildModelParser31.parseDefaultPackages((XMLStreamReader)reader, builder);
                            continue block20;
                        }
                        case 16: {
                            FeaturePackBuildModelParser31.parsePackageSchemas((XMLStreamReader)reader, builder);
                            continue block20;
                        }
                        case 1: {
                            ConfigModel.Builder config = ConfigModel.builder();
                            ConfigXml.readConfig((XMLExtendedStreamReader)reader, (ConfigModel.Builder)config);
                            try {
                                builder.addConfig(config.build());
                                continue block20;
                            }
                            catch (ProvisioningDescriptionException e) {
                                throw new XMLStreamException("Failed to create a config model instance", e);
                            }
                        }
                        case 22: {
                            FeaturePackBuildModelParser31.parseTransitive(reader, builder);
                            continue block20;
                        }
                        case 18: {
                            FeaturePackBuildModelParser31.parsePlugins(reader, builder);
                            continue block20;
                        }
                        case 20: {
                            FeaturePackBuildModelParser31.parseResources(reader, builder);
                            continue block20;
                        }
                        case 10: {
                            FeaturePackBuildModelParser31.parseGenerateFeatureSpecs(reader, builder);
                            continue block20;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private static void parseDefaultPackages(XMLStreamReader reader, WildFlyFeaturePackBuild.Builder builder) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element.ordinal()) {
                        case 14: {
                            builder.addDefaultPackage(FeaturePackBuildModelParser31.parseName(reader));
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private static void parseDependencies(XMLExtendedStreamReader reader, WildFlyFeaturePackBuild.Builder builder) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element.ordinal()) {
                        case 6: {
                            FeaturePackBuildModelParser31.parseDependency(reader, builder, false);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private static void parseDependency(XMLExtendedStreamReader reader, WildFlyFeaturePackBuild.Builder builder, boolean transitive) throws XMLStreamException {
        FeaturePackConfig.Builder depBuilder;
        String groupId = null;
        String artifactId = null;
        String version = null;
        boolean translateToFpl = false;
        int count = reader.getAttributeCount();
        EnumSet<Attribute> required = EnumSet.of(Attribute.GROUP_ID, Attribute.ARTIFACT_ID);
        block20: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute.ordinal()) {
                case 2: {
                    groupId = reader.getAttributeValue(i);
                    continue block20;
                }
                case 1: {
                    artifactId = reader.getAttributeValue(i);
                    continue block20;
                }
                case 8: {
                    version = reader.getAttributeValue(i);
                    continue block20;
                }
                case 7: {
                    translateToFpl = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block20;
                }
                default: {
                    throw ParsingUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), required);
        }
        FeaturePackLocation fpl = translateToFpl ? LegacyGalleon1Universe.toFpl(groupId, artifactId, version) : FeaturePackLocation.fromString((String)(groupId + ":" + artifactId + ":" + (String)StringUtils.defaultIfEmpty(version, (CharSequence)"")));
        String depName = null;
        FeaturePackConfig.Builder builder2 = depBuilder = transitive ? FeaturePackConfig.transitiveBuilder((FeaturePackLocation)fpl) : FeaturePackConfig.builder((FeaturePackLocation)fpl);
        block21: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    builder.addDependency(ArtifactCoords.newGav((String)groupId, (String)artifactId, (String)version), FeaturePackDependencySpec.create(depName, depBuilder.build()));
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element.ordinal()) {
                        case 13: {
                            depName = reader.getElementText().trim();
                            continue block21;
                        }
                        case 3: {
                            ProvisioningXmlParser30.parseDefaultConfigs((XMLExtendedStreamReader)reader, (ConfigCustomizationsBuilder)depBuilder);
                            continue block21;
                        }
                        case 1: {
                            ConfigModel.Builder configBuilder = ConfigModel.builder();
                            ConfigXml.readConfig((XMLExtendedStreamReader)reader, (ConfigModel.Builder)configBuilder);
                            try {
                                depBuilder.addConfig(configBuilder.build());
                                continue block21;
                            }
                            catch (ProvisioningDescriptionException e) {
                                throw new XMLStreamException(e);
                            }
                        }
                        case 15: {
                            try {
                                FeaturePackPackagesConfigParser10.readPackages((XMLStreamReader)reader, (FeaturePackConfig.Builder)depBuilder);
                                continue block21;
                            }
                            catch (ProvisioningDescriptionException e) {
                                throw new XMLStreamException(e);
                            }
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
    }

    private static void parseTransitive(XMLExtendedStreamReader reader, WildFlyFeaturePackBuild.Builder builder) throws XMLStreamException {
        ParsingUtils.parseNoAttributes((XMLStreamReader)reader);
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element.ordinal()) {
                        case 6: {
                            FeaturePackBuildModelParser31.parseDependency(reader, builder, true);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private static String parseName(XMLStreamReader reader) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute.ordinal()) {
                case 4: {
                    name = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes((Location)reader.getLocation(), required);
        }
        ParsingUtils.parseNoContent((XMLStreamReader)reader);
        return name;
    }

    private static void parsePackageSchemas(XMLStreamReader reader, WildFlyFeaturePackBuild.Builder builder) throws XMLStreamException {
        ParsingUtils.parseNoAttributes((XMLStreamReader)reader);
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element.ordinal()) {
                        case 11: {
                            builder.addSchemaGroup(FeaturePackBuildModelParser31.parseName(reader));
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private static void parsePlugins(XMLExtendedStreamReader reader, WildFlyFeaturePackBuild.Builder builder) throws XMLStreamException {
        ParsingUtils.parseNoAttributes((XMLStreamReader)reader);
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element.ordinal()) {
                        case 17: {
                            FeaturePackBuildModelParser31.parsePlugin(reader, builder);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private static void parsePlugin(XMLExtendedStreamReader reader, WildFlyFeaturePackBuild.Builder builder) throws XMLStreamException {
        String id = null;
        ArtifactCoords coords = null;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute.ordinal()) {
                case 3: {
                    id = reader.getAttributeValue(i);
                    continue block4;
                }
                case 0: {
                    coords = ArtifactCoordsUtil.fromJBossModules(reader.getAttributeValue(i), "jar");
                    continue block4;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        ParsingUtils.parseNoContent((XMLStreamReader)reader);
        if (coords == null) {
            throw new XMLStreamException(ParsingUtils.missingAttributes((Location)reader.getLocation(), Collections.singleton(Attribute.ARTIFACT)));
        }
        if (id == null) {
            id = coords.getArtifactId();
        }
        builder.addPlugin(id, coords);
    }

    private static void parseResources(XMLExtendedStreamReader reader, WildFlyFeaturePackBuild.Builder builder) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element.ordinal()) {
                        case 2: {
                            builder.addResourcesTask(FeaturePackBuildModelParser31.parseCopy((XMLStreamReader)reader));
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private static CopyResourcesTask parseCopy(XMLStreamReader reader) throws XMLStreamException {
        CopyResourcesTask copy = new CopyResourcesTask();
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute.ordinal()) {
                case 0: {
                    copy.setArtifact(reader.getAttributeValue(i));
                    continue block4;
                }
                case 6: {
                    copy.setTo(reader.getAttributeValue(i));
                    continue block4;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        String error = copy.getValidationErrors();
        if (error != null) {
            throw new XMLStreamException(ParsingUtils.error((String)error, (Location)reader.getLocation()));
        }
        ParsingUtils.parseNoContent((XMLStreamReader)reader);
        return copy;
    }

    private static void parseGenerateFeatureSpecs(XMLExtendedStreamReader reader, WildFlyFeaturePackBuild.Builder builder) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element.ordinal()) {
                        case 9: {
                            FeaturePackBuildModelParser31.parseExtensions(reader, builder);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private static void parseExtensions(XMLExtendedStreamReader reader, WildFlyFeaturePackBuild.Builder builder) throws XMLStreamException {
        block9: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element.ordinal()) {
                        case 21: {
                            FeaturePackBuildModelParser31.parseExtensions(reader, builder, Element.STANDALONE);
                            continue block9;
                        }
                        case 7: {
                            FeaturePackBuildModelParser31.parseExtensions(reader, builder, Element.DOMAIN);
                            continue block9;
                        }
                        case 12: {
                            FeaturePackBuildModelParser31.parseExtensions(reader, builder, Element.HOST);
                            continue block9;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    private static void parseExtensions(XMLExtendedStreamReader reader, WildFlyFeaturePackBuild.Builder builder, Element e) throws XMLStreamException {
        ParsingUtils.parseNoAttributes((XMLStreamReader)reader);
        block12: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element.ordinal()) {
                        case 8: {
                            switch (e.ordinal()) {
                                case 21: {
                                    builder.addStandaloneExtension(reader.getElementText().trim());
                                    continue block12;
                                }
                                case 7: {
                                    builder.addDomainExtension(reader.getElementText().trim());
                                    continue block12;
                                }
                                case 12: {
                                    builder.addHostExtension(reader.getElementText().trim());
                                    continue block12;
                                }
                            }
                            throw new XMLStreamException("Unexpected extension target " + String.valueOf((Object)e), reader.getLocation());
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument((Location)reader.getLocation());
    }

    static enum Attribute implements XmlNameProvider
    {
        ARTIFACT("artifact"),
        ARTIFACT_ID("artifact-id"),
        GROUP_ID("group-id"),
        ID("id"),
        NAME("name"),
        PRODUCER("producer"),
        TO("to"),
        TRANSLATE_TO_FPL("translate-to-fpl"),
        VERSION("version"),
        UNKNOWN(null);

        private static final Map<QName, Attribute> attributes;
        private final String name;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public String getNamespace() {
            return null;
        }

        static {
            HashMap<QName, Attribute> attributesMap = new HashMap<QName, Attribute>(9);
            attributesMap.put(new QName(ARTIFACT.getLocalName()), ARTIFACT);
            attributesMap.put(new QName(ARTIFACT_ID.getLocalName()), ARTIFACT_ID);
            attributesMap.put(new QName(GROUP_ID.getLocalName()), GROUP_ID);
            attributesMap.put(new QName(ID.getLocalName()), ID);
            attributesMap.put(new QName(NAME.getLocalName()), NAME);
            attributesMap.put(new QName(PRODUCER.getLocalName()), PRODUCER);
            attributesMap.put(new QName(TO.getLocalName()), TO);
            attributesMap.put(new QName(TRANSLATE_TO_FPL.getLocalName()), TRANSLATE_TO_FPL);
            attributesMap.put(new QName(VERSION.getLocalName()), VERSION);
            attributes = attributesMap;
        }
    }

    static enum Element {
        BUILD("build"),
        CONFIG("config"),
        COPY("copy"),
        DEFAULT_CONFIGS("default-configs"),
        DEFAULT_PACKAGES("default-packages"),
        DEPENDENCIES("dependencies"),
        DEPENDENCY("dependency"),
        DOMAIN("domain"),
        EXTENSION("extension"),
        EXTENSIONS("extensions"),
        GENERATE_FEATURE_SPECS("generate-feature-specs"),
        GROUP("group"),
        HOST("host"),
        NAME("name"),
        PACKAGE("package"),
        PACKAGES("packages"),
        PACKAGE_SCHEMAS("package-schemas"),
        PLUGIN("plugin"),
        PLUGINS("plugins"),
        PRODUCER("producer"),
        RESOURCES("resources"),
        STANDALONE("standalone"),
        TRANSITIVE("transitive"),
        UNKNOWN(null);

        private static final Map<QName, Element> elements;
        private final String name;

        static Element of(QName qName) {
            QName name = qName.getNamespaceURI().equals("") ? new QName(FeaturePackBuildModelParser31.NAMESPACE, qName.getLocalPart()) : qName;
            Element element = elements.get(name);
            return element == null ? UNKNOWN : element;
        }

        private Element(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        static {
            HashMap<QName, Element> elementsMap = new HashMap<QName, Element>(23);
            elementsMap.put(new QName(FeaturePackBuildModelParser31.NAMESPACE, BUILD.getLocalName()), BUILD);
            elementsMap.put(new QName(FeaturePackBuildModelParser31.NAMESPACE, CONFIG.getLocalName()), CONFIG);
            elementsMap.put(new QName(FeaturePackBuildModelParser31.NAMESPACE, COPY.getLocalName()), COPY);
            elementsMap.put(new QName(FeaturePackBuildModelParser31.NAMESPACE, DEFAULT_CONFIGS.getLocalName()), DEFAULT_CONFIGS);
            elementsMap.put(new QName(FeaturePackBuildModelParser31.NAMESPACE, DEFAULT_PACKAGES.getLocalName()), DEFAULT_PACKAGES);
            elementsMap.put(new QName(FeaturePackBuildModelParser31.NAMESPACE, DEPENDENCIES.getLocalName()), DEPENDENCIES);
            elementsMap.put(new QName(FeaturePackBuildModelParser31.NAMESPACE, DEPENDENCY.getLocalName()), DEPENDENCY);
            elementsMap.put(new QName(FeaturePackBuildModelParser31.NAMESPACE, DOMAIN.getLocalName()), DOMAIN);
            elementsMap.put(new QName(FeaturePackBuildModelParser31.NAMESPACE, EXTENSION.getLocalName()), EXTENSION);
            elementsMap.put(new QName(FeaturePackBuildModelParser31.NAMESPACE, EXTENSIONS.getLocalName()), EXTENSIONS);
            elementsMap.put(new QName(FeaturePackBuildModelParser31.NAMESPACE, GENERATE_FEATURE_SPECS.getLocalName()), GENERATE_FEATURE_SPECS);
            elementsMap.put(new QName(FeaturePackBuildModelParser31.NAMESPACE, GROUP.getLocalName()), GROUP);
            elementsMap.put(new QName(FeaturePackBuildModelParser31.NAMESPACE, HOST.getLocalName()), HOST);
            elementsMap.put(new QName(FeaturePackBuildModelParser31.NAMESPACE, NAME.getLocalName()), NAME);
            elementsMap.put(new QName(FeaturePackBuildModelParser31.NAMESPACE, PACKAGE.getLocalName()), PACKAGE);
            elementsMap.put(new QName(FeaturePackBuildModelParser31.NAMESPACE, PACKAGES.getLocalName()), PACKAGES);
            elementsMap.put(new QName(FeaturePackBuildModelParser31.NAMESPACE, PACKAGE_SCHEMAS.getLocalName()), PACKAGE_SCHEMAS);
            elementsMap.put(new QName(FeaturePackBuildModelParser31.NAMESPACE, PLUGIN.getLocalName()), PLUGIN);
            elementsMap.put(new QName(FeaturePackBuildModelParser31.NAMESPACE, PLUGINS.getLocalName()), PLUGINS);
            elementsMap.put(new QName(FeaturePackBuildModelParser31.NAMESPACE, PRODUCER.getLocalName()), PRODUCER);
            elementsMap.put(new QName(FeaturePackBuildModelParser31.NAMESPACE, RESOURCES.getLocalName()), RESOURCES);
            elementsMap.put(new QName(FeaturePackBuildModelParser31.NAMESPACE, STANDALONE.getLocalName()), STANDALONE);
            elementsMap.put(new QName(FeaturePackBuildModelParser31.NAMESPACE, TRANSITIVE.getLocalName()), TRANSITIVE);
            elements = elementsMap;
        }
    }
}

